/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.transaction.lock.NoopLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.CompactionTriggerStrategy;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDowngradeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeDowngradeUtils.class);
    static final String FALSE = "false";
    static final String TRUE = "true";
    static final Map<String, String> SIX_TO_EIGHT_TIMELINE_ACTION_MAP = CollectionUtils.createImmutableMap((Pair[])new Pair[]{Pair.of((Object)"replacecommit", (Object)"clustering")});
    static final Map<String, String> EIGHT_TO_SIX_TIMELINE_ACTION_MAP = CollectionUtils.reverseMap(SIX_TO_EIGHT_TIMELINE_ACTION_MAP);
    static final Set<String> PAYLOAD_CLASSES_TO_HANDLE = new HashSet<String>(Arrays.asList(AWSDmsAvroPayload.class.getName(), DefaultHoodieRecordPayload.class.getName(), EventTimeAvroPayload.class.getName(), MySqlDebeziumAvroPayload.class.getName(), OverwriteNonDefaultsWithLatestAvroPayload.class.getName(), OverwriteWithLatestAvroPayload.class.getName(), PartialUpdateAvroPayload.class.getName(), PostgresDebeziumAvroPayload.class.getName()));

    public static void syncCompactionRequestedFileToAuxiliaryFolder(HoodieTable table) {
        HoodieTableMetaClient metaClient = table.getMetaClient();
        TimelineFactory timelineFactory = metaClient.getTableFormat().getTimelineFactory();
        InstantFileNameGenerator instantFileNameGenerator = metaClient.getInstantFileNameGenerator();
        HoodieTimeline compactionTimeline = timelineFactory.createActiveTimeline(metaClient, false).filterPendingCompactionTimeline().filter(instant -> instant.getState() == HoodieInstant.State.REQUESTED);
        compactionTimeline.getInstantsAsStream().forEach(instant -> {
            String fileName = instantFileNameGenerator.getFileName(instant);
            try {
                if (!metaClient.getStorage().exists(new StoragePath(metaClient.getMetaAuxiliaryPath(), fileName))) {
                    FileIOUtils.copy((HoodieStorage)metaClient.getStorage(), (StoragePath)new StoragePath(metaClient.getTimelinePath(), fileName), (StoragePath)new StoragePath(metaClient.getMetaAuxiliaryPath(), fileName));
                }
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
    }

    static void updateMetadataTableVersion(HoodieEngineContext context, HoodieTableVersion toVersion, HoodieTableMetaClient dataMetaClient) throws HoodieIOException {
        try {
            StoragePath metadataBasePath = new StoragePath(dataMetaClient.getBasePath(), ".hoodie/metadata");
            if (dataMetaClient.getStorage().exists(metadataBasePath)) {
                HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getStorageConf().newInstance()).setBasePath(metadataBasePath).build();
                metaClient.getTableConfig().setTableVersion(toVersion);
                HoodieTableConfig.update((HoodieStorage)metaClient.getStorage(), (StoragePath)metaClient.getMetaPath(), (Properties)metaClient.getTableConfig().getProps());
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Error while updating metadata table version", e);
        }
    }

    public static long convertCompletionTimeToEpoch(HoodieInstant instant) {
        try {
            String completionTime = instant.getCompletionTime();
            String completionTimeInSecs = Long.parseLong(completionTime) / 1000L + "";
            DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime ldtInSecs = LocalDateTime.parse(completionTimeInSecs, inputFormatter);
            long millis = Long.parseLong(completionTime.substring(completionTime.length() - 3));
            return ldtInSecs.atZone(zoneId).toEpochSecond() * 1000L + millis;
        }
        catch (Exception e) {
            LOG.warn("Failed to parse completion time string for instant {}", (Object)instant, (Object)e);
            return -1L;
        }
    }

    static void rollbackFailedWritesAndCompact(HoodieTable table, HoodieEngineContext context, HoodieWriteConfig config, SupportsUpgradeDowngrade upgradeDowngradeHelper, boolean shouldCompact, HoodieTableVersion tableVersion) {
        try {
            HoodieInstantTimeGenerator.setCommitTimeZone((HoodieTimelineTimeZone)table.getMetaClient().getTableConfig().getTimelineTimezone());
            TypedProperties properties = new TypedProperties();
            properties.putAll((Map)config.getProps());
            properties.put((Object)HoodieTimeGeneratorConfig.TIME_GENERATOR_REUSE_ENABLE.key(), (Object)FALSE);
            properties.put((Object)HoodieLockConfig.LOCK_PROVIDER_CLASS_NAME.key(), (Object)NoopLockProvider.class.getName());
            properties.put((Object)HoodieWriteConfig.AUTO_ADJUST_LOCK_CONFIGS.key(), (Object)FALSE);
            if (table.isMetadataTable() && tableVersion.equals((Object)HoodieTableVersion.NINE)) {
                properties.put((Object)HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), (Object)WriteConcurrencyMode.SINGLE_WRITER.name());
            }
            Set metadataPartitions = table.getMetaClient().getTableConfig().getMetadataPartitions();
            metadataPartitions.addAll(table.getMetaClient().getTableConfig().getMetadataPartitionsInflight());
            UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions(properties, metadataPartitions, table);
            HoodieWriteConfig rollbackWriteConfig = HoodieWriteConfig.newBuilder().withProps((Map)properties).withWriteTableVersion(tableVersion.versionCode()).withAutoUpgradeVersion(false).build();
            rollbackWriteConfig.setValue(HoodieCleanConfig.FAILED_WRITES_CLEANER_POLICY.key(), HoodieFailedWritesCleaningPolicy.EAGER.name());
            rollbackWriteConfig.setValue(HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE.key(), String.valueOf(config.shouldRollbackUsingMarkers()));
            if (shouldCompact) {
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT.key(), TRUE);
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key(), "1");
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT_TRIGGER_STRATEGY.key(), CompactionTriggerStrategy.NUM_COMMITS.name());
                rollbackWriteConfig.setValue(HoodieCompactionConfig.COMPACTION_STRATEGY.key(), UnBoundedCompactionStrategy.class.getName());
            } else {
                rollbackWriteConfig.setValue(HoodieCompactionConfig.INLINE_COMPACT.key(), FALSE);
            }
            try (BaseHoodieWriteClient writeClient = upgradeDowngradeHelper.getWriteClient(rollbackWriteConfig, context);){
                Option<String> compactionInstantOpt;
                writeClient.rollbackFailedWrites(table.getMetaClient());
                if (shouldCompact && (compactionInstantOpt = writeClient.scheduleCompaction((Option<Map<String, String>>)Option.empty())).isPresent()) {
                    HoodieWriteMetadata result = writeClient.compact((String)compactionInstantOpt.get());
                    writeClient.commitCompaction((String)compactionInstantOpt.get(), result, (Option<HoodieTable>)Option.empty());
                }
            }
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
    }

    @VisibleForTesting
    public static void setPropertiesBasedOnMetadataPartitions(TypedProperties properties, Set<String> metadataPartitions, HoodieTable table) {
        if (metadataPartitions.isEmpty()) {
            properties.put((Object)HoodieMetadataConfig.ENABLE.key(), (Object)FALSE);
            return;
        }
        Option indexMetadataOpt = table.getMetaClient().getIndexMetadata();
        Map indexDefinitions = indexMetadataOpt.isEmpty() ? Collections.emptyMap() : ((HoodieIndexMetadata)indexMetadataOpt.get()).getIndexDefinitions();
        properties.put((Object)HoodieMetadataConfig.ENABLE.key(), (Object)TRUE);
        Iterator<String> iterator = metadataPartitions.iterator();
        block11: while (iterator.hasNext()) {
            String partition;
            switch (partition = iterator.next()) {
                case "partition_stats": 
                case "column_stats": {
                    properties.put((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), (Object)TRUE);
                    if (!indexDefinitions.containsKey("column_stats")) break;
                    List sourceFields = ((HoodieIndexDefinition)indexDefinitions.get("column_stats")).getSourceFields();
                    if (sourceFields.isEmpty()) continue block11;
                    properties.put((Object)HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key(), (Object)String.join((CharSequence)",", sourceFields));
                    break;
                }
                case "bloom_filters": {
                    properties.put((Object)HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key(), (Object)TRUE);
                    break;
                }
                case "record_index": {
                    if (indexDefinitions.containsKey("record_index")) {
                        Map options = ((HoodieIndexDefinition)indexDefinitions.get("record_index")).getIndexOptions();
                        if (options.getOrDefault("isPartitioned", FALSE).equals(TRUE)) {
                            properties.put((Object)HoodieMetadataConfig.RECORD_LEVEL_INDEX_ENABLE_PROP.key(), (Object)TRUE);
                            break;
                        }
                        properties.put((Object)HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), (Object)TRUE);
                        break;
                    }
                    properties.put((Object)HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), (Object)TRUE);
                    break;
                }
            }
        }
    }

    static void checkAndHandleMetadataTable(HoodieEngineContext context, HoodieTable table, HoodieWriteConfig config, HoodieTableMetaClient metaClient, boolean checkforMetadataLagging) {
        if (!table.isMetadataTable() && config.isMetadataTableEnabled() && (!checkforMetadataLagging || UpgradeDowngradeUtils.isMetadataTableBehindDataTable(config, metaClient))) {
            HoodieTableMetadataUtil.deleteMetadataTable((String)config.getBasePath(), (HoodieEngineContext)context);
        }
    }

    static boolean isMetadataTableBehindDataTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
        if (!metaClient.getTableConfig().isMetadataTableAvailable()) {
            return false;
        }
        HoodieInstant lastCommitInstantInDataTable = (HoodieInstant)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().orElse(null);
        HoodieTableMetaClient metadataTableMetaClient = HoodieTableMetaClient.builder().setConf(metaClient.getStorageConf().newInstance()).setBasePath(HoodieTableMetadata.getMetadataTableBasePath((String)config.getBasePath())).build();
        HoodieInstant lastCommitInstantInMetadataTable = (HoodieInstant)metadataTableMetaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().orElse(null);
        return lastCommitInstantInDataTable != null && lastCommitInstantInMetadataTable != null && InstantComparison.compareTimestamps((String)lastCommitInstantInMetadataTable.requestedTime(), (BiPredicate)InstantComparison.LESSER_THAN, (String)lastCommitInstantInDataTable.requestedTime());
    }

    public static void dropNonV1IndexPartitions(HoodieWriteConfig config, HoodieEngineContext context, HoodieTable table, SupportsUpgradeDowngrade upgradeDowngradeHelper, String operationType) {
        HoodieTableMetaClient metaClient = table.getMetaClient();
        try (BaseHoodieWriteClient writeClient = upgradeDowngradeHelper.getWriteClient(config, context);){
            Set metadataPartitions = metaClient.getTableConfig().getMetadataPartitions();
            List<String> mdtPartitions = metadataPartitions.stream().filter(partition -> (Boolean)metaClient.getIndexForMetadataPartition(partition).map(indexDef -> HoodieIndexVersion.V1.lowerThan(indexDef.getVersion())).orElse((Object)false)).collect(Collectors.toList());
            String colStatsPartition = MetadataPartitionType.COLUMN_STATS.getPartitionPath();
            String partitionStatsPartition = MetadataPartitionType.PARTITION_STATS.getPartitionPath();
            if (mdtPartitions.contains(colStatsPartition) && metadataPartitions.contains(partitionStatsPartition)) {
                mdtPartitions.add(partitionStatsPartition);
            }
            LOG.info("Dropping from MDT partitions for {}: {}", (Object)operationType, mdtPartitions);
            if (!mdtPartitions.isEmpty()) {
                writeClient.dropIndex(mdtPartitions);
            }
        }
    }
}

