/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonClientUtils.class);

    public static void validateTableVersion(HoodieTableConfig tableConfig, HoodieWriteConfig writeConfig) {
        if (!CommonClientUtils.areTableVersionsCompatible(tableConfig.getTableVersion(), writeConfig.getWriteVersion())) {
            throw new HoodieNotSupportedException(String.format("Table version (%s) and Writer version (%s) do not match for table at: %s.", tableConfig.getTableVersion(), writeConfig.getWriteVersion(), writeConfig.getBasePath()));
        }
        if (tableConfig.getTableVersion().lesserThan(HoodieTableVersion.EIGHT) && writeConfig.shouldWritePartialUpdates()) {
            throw new HoodieNotSupportedException("Partial updates are not supported for table versions < 8. Please unset " + HoodieWriteConfig.WRITE_PARTIAL_UPDATE_SCHEMA.key());
        }
        if (tableConfig.getTableVersion().lesserThan(HoodieTableVersion.EIGHT) && writeConfig.isNonBlockingConcurrencyControl()) {
            throw new HoodieNotSupportedException("Non-blocking concurrency control is not supported for table versions < 8.");
        }
    }

    public static boolean areTableVersionsCompatible(HoodieTableVersion tableVersion, HoodieTableVersion writeVersion) {
        if (tableVersion.equals((Object)writeVersion)) {
            return true;
        }
        if (tableVersion.lesserThan(writeVersion)) {
            return true;
        }
        if (tableVersion.greaterThan(HoodieTableVersion.SIX) && writeVersion.versionCode() < tableVersion.versionCode() && writeVersion.greaterThanOrEquals(HoodieTableVersion.SIX)) {
            LOG.info("Table version is greater than 6, and writer version is lower than table version and must be >= 6.");
            return true;
        }
        return false;
    }

    public static HoodieFileFormat getBaseFileFormat(HoodieWriteConfig writeConfig, HoodieTableConfig tableConfig) {
        if (tableConfig.isMultipleBaseFileFormatsEnabled() && writeConfig.contains(HoodieWriteConfig.BASE_FILE_FORMAT)) {
            return writeConfig.getBaseFileFormat();
        }
        return tableConfig.getBaseFileFormat();
    }

    public static HoodieLogBlock.HoodieLogBlockType getLogBlockType(HoodieWriteConfig writeConfig, HoodieTableConfig tableConfig) {
        Option<HoodieLogBlock.HoodieLogBlockType> logBlockTypeOpt = writeConfig.getLogDataBlockFormat();
        if (logBlockTypeOpt.isPresent()) {
            return (HoodieLogBlock.HoodieLogBlockType)logBlockTypeOpt.get();
        }
        HoodieFileFormat baseFileFormat = CommonClientUtils.getBaseFileFormat(writeConfig, tableConfig);
        switch (CommonClientUtils.getBaseFileFormat(writeConfig, tableConfig)) {
            case PARQUET: 
            case ORC: {
                return HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK;
            }
            case HFILE: {
                return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
            }
        }
        throw new HoodieException("Base file format " + baseFileFormat + " does not have associated log block type");
    }

    public static String generateWriteToken(TaskContextSupplier taskContextSupplier) {
        try {
            return FSUtils.makeWriteToken((int)((Integer)taskContextSupplier.getPartitionIdSupplier().get()), (int)((Integer)taskContextSupplier.getStageIdSupplier().get()), (long)((Long)taskContextSupplier.getAttemptIdSupplier().get()));
        }
        catch (Throwable t) {
            LOG.warn("Error generating write token, using default.", t);
            return "0-0-0";
        }
    }

    public static <O> HoodieWriteMetadata stitchCompactionHoodieWriteStats(HoodieWriteMetadata<O> writeMetadata, List<HoodieWriteStat> writeStats) {
        HoodieCommitMetadata commitMetadata = (HoodieCommitMetadata)writeMetadata.getCommitMetadata().get();
        commitMetadata.setCompacted(Boolean.valueOf(true));
        for (HoodieWriteStat stat : writeStats) {
            commitMetadata.addWriteStat(stat.getPartitionPath(), stat);
        }
        writeMetadata.setCommitted(true);
        writeMetadata.setCommitMetadata((Option<HoodieCommitMetadata>)Option.of((Object)commitMetadata));
        return writeMetadata;
    }

    public static Map<String, List<String>> getPartitionToReplacedFileIds(HoodieClusteringPlan clusteringPlan, HoodieWriteMetadata<?> writeMetadata, HoodieWriteConfig config) {
        Set newFilesWritten = ((List)writeMetadata.getWriteStats().get()).stream().map(s -> new HoodieFileGroupId(s.getPartitionPath(), s.getFileId())).collect(Collectors.toSet());
        return ClusteringUtils.getFileGroupsFromClusteringPlan((HoodieClusteringPlan)clusteringPlan).filter(fg -> "org.apache.hudi.client.clustering.run.strategy.SparkSingleFileSortExecutionStrategy".equals(config.getClusteringExecutionStrategyClass()) || !newFilesWritten.contains(fg)).collect(Collectors.groupingBy(HoodieFileGroupId::getPartitionPath, Collectors.mapping(HoodieFileGroupId::getFileId, Collectors.toList())));
    }
}

