/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.util.Map;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new AfterburnerModule());
    private final String serverHost;
    private final int serverPort;
    private final int timeoutSecs;
    private final int maxRetry;

    public HttpRequestClient(HoodieWriteConfig writeConfig) {
        this(writeConfig.getViewStorageConfig().getRemoteViewServerHost(), writeConfig.getViewStorageConfig().getRemoteViewServerPort(), writeConfig.getViewStorageConfig().getRemoteTimelineClientTimeoutSecs(), writeConfig.getViewStorageConfig().getRemoteTimelineClientMaxRetryNumbers());
    }

    public HttpRequestClient(String serverHost, int serverPort, int timeoutSecs, int maxRetry) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.timeoutSecs = timeoutSecs;
        this.maxRetry = maxRetry;
    }

    public <T> T executeRequestWithRetry(String requestPath, Map<String, String> queryParameters, TypeReference<T> reference, RequestMethod method) {
        int retry = this.maxRetry;
        while (--retry >= 0) {
            try {
                return this.executeRequest(requestPath, queryParameters, reference, method);
            }
            catch (IOException e) {
                LOG.warn("Failed to execute request ({}) to timeline server", (Object)requestPath, (Object)e);
            }
        }
        throw new HoodieException("Failed to execute timeline server request (" + requestPath + ")");
    }

    public <T> T executeRequest(String requestPath, Map<String, String> queryParameters, TypeReference<T> reference, RequestMethod method) throws IOException {
        Response response;
        URIBuilder builder = new URIBuilder().setHost(this.serverHost).setPort(this.serverPort).setPath(requestPath).setScheme("http");
        queryParameters.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
        String url = builder.toString();
        LOG.debug("Sending request : ( {} )", (Object)url);
        int timeout = this.timeoutSecs * 1000;
        switch (method) {
            case GET: {
                response = Request.Get((String)url).connectTimeout(timeout).socketTimeout(timeout).execute();
                break;
            }
            default: {
                response = Request.Post((String)url).connectTimeout(timeout).socketTimeout(timeout).execute();
            }
        }
        String content = response.returnContent().asString();
        return (T)MAPPER.readValue(content, reference);
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

