/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class TimeMicrosWrapper
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -893193196778204874L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"TimeMicrosWrapper\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record wrapping Time-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"long\",\"logicalType\":\"time-micros\"}}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<TimeMicrosWrapper> ENCODER;
    private static final BinaryMessageDecoder<TimeMicrosWrapper> DECODER;
    private LocalTime value;
    private static final Conversion<?>[] conversions;
    private static final DatumWriter<TimeMicrosWrapper> WRITER$;
    private static final DatumReader<TimeMicrosWrapper> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<TimeMicrosWrapper> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<TimeMicrosWrapper> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<TimeMicrosWrapper> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static TimeMicrosWrapper fromByteBuffer(ByteBuffer b) throws IOException {
        return (TimeMicrosWrapper)((Object)DECODER.decode(b));
    }

    public TimeMicrosWrapper() {
    }

    public TimeMicrosWrapper(LocalTime value) {
        this.value = value.truncatedTo(ChronoUnit.MICROS);
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public Conversion<?> getConversion(int field) {
        return conversions[field];
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (LocalTime)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public LocalTime getValue() {
        return this.value;
    }

    public void setValue(LocalTime value) {
        this.value = value.truncatedTo(ChronoUnit.MICROS);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(TimeMicrosWrapper other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        MODEL$.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMillisConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        conversions = new Conversion[]{new TimeConversions.TimeMicrosConversion(), null};
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<TimeMicrosWrapper>
    implements RecordBuilder<TimeMicrosWrapper> {
        private LocalTime value;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (LocalTime)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
        }

        private Builder(TimeMicrosWrapper other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.value)) {
                this.value = (LocalTime)this.data().deepCopy(this.fields()[0].schema(), (Object)other.value);
                this.fieldSetFlags()[0] = true;
            }
        }

        public LocalTime getValue() {
            return this.value;
        }

        public Builder setValue(LocalTime value) {
            this.validate(this.fields()[0], value);
            this.value = value.truncatedTo(ChronoUnit.MICROS);
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public TimeMicrosWrapper build() {
            try {
                TimeMicrosWrapper record = new TimeMicrosWrapper();
                record.value = this.fieldSetFlags()[0] ? this.value : (LocalTime)this.defaultValue(this.fields()[0]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

