/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FileIOUtils {
    public static final Logger LOG = LogManager.getLogger(FileIOUtils.class);
    public static final long KB = 1024L;

    public static void deleteDirectory(File directory) throws IOException {
        if (directory.exists()) {
            Files.walk(directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(java.nio.file.Path::toFile).forEach(File::delete);
            directory.delete();
            if (directory.exists()) {
                throw new IOException("Unable to delete directory " + directory);
            }
        }
    }

    public static void mkdir(File directory) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!directory.isDirectory()) {
            throw new IOException("Unable to create :" + directory);
        }
    }

    public static String readAsUTFString(InputStream input) throws IOException {
        return FileIOUtils.readAsUTFString(input, 128);
    }

    public static String readAsUTFString(InputStream input, int length) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        FileIOUtils.copy(input, bos);
        return new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static List<String> readAsUTFStringLines(InputStream input) {
        ArrayList<String> lines = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        lines = bufferedReader.lines().collect(Collectors.toList());
        FileIOUtils.closeQuietly(bufferedReader);
        return lines;
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, len);
        }
    }

    public static void copy(FileSystem fileSystem, Path sourceFilePath, Path destFilePath) {
        FSDataInputStream fsDataInputStream = null;
        FSDataOutputStream fsDataOutputStream = null;
        try {
            fsDataInputStream = fileSystem.open(sourceFilePath);
            fsDataOutputStream = fileSystem.create(destFilePath, false);
            FileIOUtils.copy((InputStream)fsDataInputStream, (OutputStream)fsDataOutputStream);
        }
        catch (IOException e) {
            try {
                throw new HoodieIOException(String.format("Cannot copy from %s to %s", sourceFilePath.toString(), destFilePath.toString()), e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
                FileIOUtils.closeQuietly(fsDataOutputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
    }

    public static byte[] readAsByteArray(InputStream input) throws IOException {
        return FileIOUtils.readAsByteArray(input, 128);
    }

    public static byte[] readAsByteArray(InputStream input, int outputSize) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(outputSize);
        FileIOUtils.copy(input, bos);
        return bos.toByteArray();
    }

    public static void writeStringToFile(String str, String filePath) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(filePath));
        out.println(str);
        out.flush();
        out.close();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOG.warn((Object)"IOException during close", (Throwable)e);
        }
    }

    public static void createFileInPath(FileSystem fileSystem, Path fullPath, Option<byte[]> content, boolean ignoreIOE) {
        block6: {
            try {
                if (!fileSystem.exists(fullPath)) {
                    if (fileSystem.createNewFile(fullPath)) {
                        LOG.info((Object)("Created a new file in meta path: " + fullPath));
                    } else {
                        throw new HoodieIOException("Failed to create file " + fullPath);
                    }
                }
                if (content.isPresent()) {
                    FSDataOutputStream fsout = fileSystem.create(fullPath, true);
                    fsout.write(content.get());
                    fsout.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to create file " + fullPath), (Throwable)e);
                if (ignoreIOE) break block6;
                throw new HoodieIOException("Failed to create file " + fullPath, e);
            }
        }
    }

    public static void createFileInPath(FileSystem fileSystem, Path fullPath, Option<byte[]> content) {
        FileIOUtils.createFileInPath(fileSystem, fullPath, content, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Option<byte[]> readDataFromPath(FileSystem fileSystem, Path detailPath, boolean ignoreIOE) {
        try (FSDataInputStream is = fileSystem.open(detailPath);){
            Option<byte[]> option = Option.of(FileIOUtils.readAsByteArray((InputStream)is));
            return option;
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not read commit details from " + detailPath), (Throwable)e);
            if (ignoreIOE) return Option.empty();
            throw new HoodieIOException("Could not read commit details from " + detailPath, e);
        }
    }

    public static Option<byte[]> readDataFromPath(FileSystem fileSystem, Path detailPath) {
        return FileIOUtils.readDataFromPath(fileSystem, detailPath, false);
    }

    public static String[] getConfiguredLocalDirs() {
        if (FileIOUtils.isRunningInYarnContainer()) {
            return FileIOUtils.getYarnLocalDirs().split(",");
        }
        if (System.getProperty("java.io.tmpdir") != null) {
            return System.getProperty("java.io.tmpdir").split(",");
        }
        return null;
    }

    private static boolean isRunningInYarnContainer() {
        return System.getenv("CONTAINER_ID") != null;
    }

    private static String getYarnLocalDirs() {
        String localDirs = Option.of(System.getenv("LOCAL_DIRS")).orElse("");
        if (localDirs.isEmpty()) {
            throw new HoodieIOException("Yarn Local dirs can't be empty");
        }
        return localDirs;
    }
}

