/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class AvroSchemaEvolutionUtils {
    public static InternalSchema reconcileSchema(Schema incomingSchema, InternalSchema oldTableSchema) {
        InternalSchema inComingInternalSchema = AvroInternalSchemaConverter.convert(incomingSchema);
        List<String> colNamesFromIncoming = inComingInternalSchema.getAllColsFullName();
        List<String> colNamesFromOldSchema = oldTableSchema.getAllColsFullName();
        List diffFromOldSchema = colNamesFromOldSchema.stream().filter(f -> !colNamesFromIncoming.contains(f)).collect(Collectors.toList());
        ArrayList newFields = new ArrayList();
        if (colNamesFromIncoming.size() == colNamesFromOldSchema.size() && diffFromOldSchema.size() == 0) {
            return oldTableSchema;
        }
        List diffFromEvolutionSchema = colNamesFromIncoming.stream().filter(f -> !colNamesFromOldSchema.contains(f)).collect(Collectors.toList());
        TreeMap<Integer, String> finalAddAction = new TreeMap<Integer, String>();
        for (int i = 0; i < diffFromEvolutionSchema.size(); ++i) {
            String parentName;
            String name = (String)diffFromEvolutionSchema.get(i);
            int splitPoint = name.lastIndexOf(".");
            String string = parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            if (!parentName.isEmpty() && diffFromEvolutionSchema.contains(parentName)) continue;
            finalAddAction.put(inComingInternalSchema.findIdByName(name), name);
        }
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(oldTableSchema);
        finalAddAction.entrySet().stream().forEach(f -> {
            String name = (String)f.getValue();
            int splitPoint = name.lastIndexOf(".");
            String parentName = splitPoint > 0 ? name.substring(0, splitPoint) : "";
            String rawName = splitPoint > 0 ? name.substring(splitPoint + 1) : name;
            Optional<String> inferPosition = colNamesFromIncoming.stream().filter(c -> c.lastIndexOf(".") == splitPoint && c.startsWith(parentName) && inComingInternalSchema.findIdByName((String)c) > inComingInternalSchema.findIdByName(name) && oldTableSchema.findIdByName((String)c) > 0).sorted((s1, s2) -> oldTableSchema.findIdByName((String)s1) - oldTableSchema.findIdByName((String)s2)).findFirst();
            addChange.addColumns(parentName, rawName, inComingInternalSchema.findType(name), null);
            inferPosition.map(i -> addChange.addPositionChange(name, (String)i, "before"));
        });
        return SchemaChangeUtils.applyTableChanges2Schema(oldTableSchema, addChange);
    }

    public static Schema canonicalizeColumnNullability(Schema writeSchema, Schema readSchema) {
        if (writeSchema.getFields().isEmpty() || readSchema.getFields().isEmpty()) {
            return writeSchema;
        }
        InternalSchema writeInternalSchema = AvroInternalSchemaConverter.convert(writeSchema);
        InternalSchema readInternalSchema = AvroInternalSchemaConverter.convert(readSchema);
        List<String> colNamesWriteSchema = writeInternalSchema.getAllColsFullName();
        List<String> colNamesFromReadSchema = readInternalSchema.getAllColsFullName();
        List candidateUpdateCols = colNamesWriteSchema.stream().filter(f -> {
            boolean exist = colNamesFromReadSchema.contains(f);
            return exist && writeInternalSchema.findField((String)f).isOptional() != readInternalSchema.findField((String)f).isOptional();
        }).collect(Collectors.toList());
        if (candidateUpdateCols.isEmpty()) {
            return writeSchema;
        }
        TableChanges.ColumnUpdateChange schemaChange = CollectionUtils.reduce(candidateUpdateCols, TableChanges.ColumnUpdateChange.get(writeInternalSchema), (change, field) -> change.updateColumnNullability((String)field, true));
        return AvroInternalSchemaConverter.convert(SchemaChangeUtils.applyTableChanges2Schema(writeInternalSchema, schemaChange), writeSchema.getFullName());
    }
}

