/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMercifulJsonConverter {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final MercifulJsonConverter CONVERTER = new MercifulJsonConverter(true, "__");

    @Test
    public void basicConversion() throws IOException {
        Schema simpleSchema = SchemaTestUtil.getSimpleSchema();
        String name = "John Smith";
        int number = 1337;
        String color = "Blue. No yellow!";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("favorite_number", number);
        data.put("favorite_color", color);
        String json = MAPPER.writeValueAsString(data);
        GenericData.Record rec = new GenericData.Record(simpleSchema);
        rec.put("name", (Object)name);
        rec.put("favorite_number", (Object)number);
        rec.put("favorite_color", (Object)color);
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, simpleSchema));
    }

    @Test
    public void conversionWithFieldNameSanitization() throws IOException {
        String sanitizedSchemaString = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\", \"fields\": [{\"name\": \"__name\", \"type\": \"string\"}, {\"name\": \"favorite__number\", \"type\": \"int\"}, {\"name\": \"favorite__color__\", \"type\": \"string\"}]}";
        Schema sanitizedSchema = Schema.parse((String)sanitizedSchemaString);
        String name = "John Smith";
        int number = 1337;
        String color = "Blue. No yellow!";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("$name", name);
        data.put("favorite-number", number);
        data.put("favorite.color!", color);
        String json = MAPPER.writeValueAsString(data);
        GenericData.Record rec = new GenericData.Record(sanitizedSchema);
        rec.put("__name", (Object)name);
        rec.put("favorite__number", (Object)number);
        rec.put("favorite__color__", (Object)color);
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, sanitizedSchema));
    }

    @Test
    public void conversionWithFieldNameAliases() throws IOException {
        String schemaStringWithAliases = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\", \"fields\": [{\"name\": \"name\", \"type\": \"string\", \"aliases\": [\"$name\"]}, {\"name\": \"favorite_number\",  \"type\": \"int\", \"aliases\": [\"unused\", \"favorite-number\"]}, {\"name\": \"favorite_color\", \"type\": \"string\", \"aliases\": [\"favorite.color!\"]}, {\"name\": \"unmatched\", \"type\": \"string\", \"default\": \"default_value\"}]}";
        Schema sanitizedSchema = Schema.parse((String)schemaStringWithAliases);
        String name = "John Smith";
        int number = 1337;
        String color = "Blue. No yellow!";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("$name", name);
        data.put("favorite-number", number);
        data.put("favorite.color!", color);
        String json = MAPPER.writeValueAsString(data);
        GenericData.Record rec = new GenericData.Record(sanitizedSchema);
        rec.put("name", (Object)name);
        rec.put("favorite_number", (Object)number);
        rec.put("favorite_color", (Object)color);
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, sanitizedSchema));
    }
}

