/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.metrics.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRegistry {
    @Test
    public void testGetRegistry() throws Exception {
        Registry r = Registry.getRegistry((String)"testGetRegistry_1");
        Assertions.assertEquals((Object)r, (Object)Registry.getRegistry((String)"testGetRegistry_1"));
    }

    private void registerMetrics(Map<String, Long> map, Registry registry) {
        map.forEach((k, v) -> registry.add(k, v.longValue()));
    }

    @Test
    public void testGetAllMetrics() throws Exception {
        String registryName = "testGetAllMetrics";
        Registry r = Registry.getRegistry((String)registryName);
        HashMap<String, Long> countsMap = new HashMap<String, Long>();
        countsMap.put("one", 1L);
        this.registerMetrics(countsMap, r);
        Map allMetrics1 = Registry.getAllMetrics((boolean)false, (boolean)true);
        Assertions.assertTrue((boolean)allMetrics1.containsKey(registryName + ".one"));
        countsMap.remove("one");
        countsMap.put("two", 2L);
        this.registerMetrics(countsMap, r);
        Map allMetrics2 = Registry.getAllMetrics((boolean)true, (boolean)true);
        Assertions.assertTrue((boolean)allMetrics2.containsKey(registryName + ".one"));
        Assertions.assertTrue((boolean)allMetrics2.containsKey(registryName + ".two"));
        Map allMetrics3 = Registry.getAllMetrics((boolean)false, (boolean)true);
        Assertions.assertTrue((boolean)allMetrics3.isEmpty());
    }

    @Test
    public void testCounts() throws Exception {
        Registry r = Registry.getRegistry((String)"testCounts");
        HashMap<String, Long> countsMap = new HashMap<String, Long>();
        countsMap.put("one", 1L);
        countsMap.put("two", 2L);
        this.registerMetrics(countsMap, r);
        Assertions.assertEquals(countsMap, (Object)r.getAllCounts());
    }
}

