/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Date;
import java.util.UUID;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieWriteStat {
    @Test
    public void testSetPaths() {
        String instantTime = HoodieActiveTimeline.formatDate((Date)new Date());
        String basePathString = "/data/tables/some-hoodie-table";
        String partitionPathString = "2017/12/31";
        String fileName = UUID.randomUUID().toString();
        String writeToken = "1-0-1";
        StoragePath basePath = new StoragePath(basePathString);
        StoragePath partitionPath = new StoragePath(basePath, partitionPathString);
        StoragePath finalizeFilePath = new StoragePath(partitionPath, FSUtils.makeBaseFileName((String)instantTime, (String)writeToken, (String)fileName, (String)((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension()));
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setPath(basePath, finalizeFilePath);
        Assertions.assertEquals((Object)finalizeFilePath, (Object)new StoragePath(basePath, writeStat.getPath()));
        writeStat = new HoodieWriteStat();
        writeStat.setPath(basePath, finalizeFilePath);
        Assertions.assertEquals((Object)finalizeFilePath, (Object)new StoragePath(basePath, writeStat.getPath()));
        Assertions.assertNull((Object)writeStat.getTempPath());
    }
}

