/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assertions;

public class CompactionTestUtils {
    private static String TEST_WRITE_TOKEN = "1-0-1";

    public static Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> setupAndValidateCompactionOperations(HoodieTableMetaClient metaClient, boolean inflight, int numEntriesInPlan1, int numEntriesInPlan2, int numEntriesInPlan3, int numEntriesInPlan4) throws IOException {
        HoodieCompactionPlan plan1 = CompactionTestUtils.createCompactionPlan(metaClient, "000", "001", numEntriesInPlan1, true, true);
        HoodieCompactionPlan plan2 = CompactionTestUtils.createCompactionPlan(metaClient, "002", "003", numEntriesInPlan2, false, true);
        HoodieCompactionPlan plan3 = CompactionTestUtils.createCompactionPlan(metaClient, "004", "005", numEntriesInPlan3, true, false);
        HoodieCompactionPlan plan4 = CompactionTestUtils.createCompactionPlan(metaClient, "006", "007", numEntriesInPlan4, false, false);
        if (inflight) {
            CompactionTestUtils.scheduleInflightCompaction(metaClient, "001", plan1);
            CompactionTestUtils.scheduleInflightCompaction(metaClient, "003", plan2);
            CompactionTestUtils.scheduleInflightCompaction(metaClient, "005", plan3);
            CompactionTestUtils.scheduleInflightCompaction(metaClient, "007", plan4);
        } else {
            CompactionTestUtils.scheduleCompaction(metaClient, "001", plan1);
            CompactionTestUtils.scheduleCompaction(metaClient, "003", plan2);
            CompactionTestUtils.scheduleCompaction(metaClient, "005", plan3);
            CompactionTestUtils.scheduleCompaction(metaClient, "007", plan4);
        }
        CompactionTestUtils.createDeltaCommit(metaClient, "000");
        CompactionTestUtils.createDeltaCommit(metaClient, "002");
        CompactionTestUtils.createDeltaCommit(metaClient, "004");
        CompactionTestUtils.createDeltaCommit(metaClient, "006");
        HashMap<String, String> baseInstantsToCompaction = new HashMap<String, String>(){
            {
                this.put("000", "001");
                this.put("002", "003");
                this.put("004", "005");
                this.put("006", "007");
            }
        };
        List<Integer> expectedNumEntries = Arrays.asList(numEntriesInPlan1, numEntriesInPlan2, numEntriesInPlan3, numEntriesInPlan4);
        List plans = CollectionUtils.createImmutableList((Object[])new HoodieCompactionPlan[]{plan1, plan2, plan3, plan4});
        IntStream.range(0, 4).boxed().forEach(idx -> {
            if ((Integer)expectedNumEntries.get((int)idx) > 0) {
                Assertions.assertEquals((long)((Integer)expectedNumEntries.get((int)idx)).longValue(), (long)((HoodieCompactionPlan)plans.get((int)idx)).getOperations().size(), (String)("check if plan " + idx + " has exp entries"));
            } else {
                Assertions.assertNull((Object)((HoodieCompactionPlan)plans.get((int)idx)).getOperations(), (String)("Plan " + idx + " has null ops"));
            }
        });
        metaClient = HoodieTestUtils.createMetaClient(metaClient.getStorageConf().newInstance(), metaClient.getBasePath());
        Map pendingCompactionMap = CompactionUtils.getAllPendingCompactionOperations((HoodieTableMetaClient)metaClient);
        Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> expPendingCompactionMap = CompactionTestUtils.generateExpectedCompactionOperations(Arrays.asList(plan1, plan2, plan3, plan4), (Map<String, String>)baseInstantsToCompaction);
        Assertions.assertEquals(expPendingCompactionMap, (Object)pendingCompactionMap);
        return expPendingCompactionMap;
    }

    public static Map<HoodieFileGroupId, Pair<String, HoodieCompactionOperation>> generateExpectedCompactionOperations(List<HoodieCompactionPlan> plans, Map<String, String> baseInstantsToCompaction) {
        return plans.stream().flatMap(plan -> {
            if (plan.getOperations() != null) {
                return plan.getOperations().stream().map(op -> Pair.of((Object)new HoodieFileGroupId(op.getPartitionPath(), op.getFileId()), (Object)Pair.of(baseInstantsToCompaction.get(op.getBaseInstantTime()), (Object)op)));
            }
            return Stream.empty();
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static void scheduleCompaction(HoodieTableMetaClient metaClient, String instantTime, HoodieCompactionPlan compactionPlan) throws IOException {
        metaClient.getActiveTimeline().saveToCompactionRequested(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime), TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)compactionPlan));
    }

    public static void createDeltaCommit(HoodieTableMetaClient metaClient, String instantTime) {
        HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, "deltacommit", instantTime);
        metaClient.getActiveTimeline().createNewInstant(requested);
        metaClient.getActiveTimeline().transitionRequestedToInflight(requested, Option.empty());
        metaClient.getActiveTimeline().saveAsComplete(new HoodieInstant(HoodieInstant.State.INFLIGHT, "deltacommit", instantTime), Option.empty());
    }

    public static void scheduleInflightCompaction(HoodieTableMetaClient metaClient, String instantTime, HoodieCompactionPlan compactionPlan) throws IOException {
        CompactionTestUtils.scheduleCompaction(metaClient, instantTime, compactionPlan);
        metaClient.getActiveTimeline().transitionCompactionRequestedToInflight(new HoodieInstant(HoodieInstant.State.REQUESTED, "compaction", instantTime));
    }

    public static HoodieCompactionPlan createCompactionPlan(HoodieTableMetaClient metaClient, String instantTime, String compactionInstantTime, int numFileIds, boolean createDataFile, boolean deltaCommitsAfterCompactionRequests) {
        List ops = IntStream.range(0, numFileIds).boxed().map(idx -> {
            try {
                String basePath = metaClient.getBasePath();
                String partition = HoodieTestUtils.DEFAULT_PARTITION_PATHS[0];
                String fileId = UUID.randomUUID().toString();
                if (createDataFile) {
                    FileCreateUtils.createBaseFile(basePath, partition, instantTime, fileId);
                }
                FileCreateUtils.createLogFile(basePath, partition, instantTime, fileId, 1);
                FileCreateUtils.createLogFile(basePath, partition, instantTime, fileId, 2);
                FileSlice slice = new FileSlice(partition, instantTime, fileId);
                if (createDataFile) {
                    slice.setBaseFile((HoodieBaseFile)new DummyHoodieBaseFile(Paths.get(basePath, partition, FileCreateUtils.baseFileName(instantTime, fileId)).toString()));
                }
                String logFilePath1 = Paths.get(basePath, partition, FileCreateUtils.logFileName(instantTime, fileId, 1)).toString();
                String logFilePath2 = Paths.get(basePath, partition, FileCreateUtils.logFileName(instantTime, fileId, 2)).toString();
                slice.addLogFile(new HoodieLogFile(new StoragePath(logFilePath1)));
                slice.addLogFile(new HoodieLogFile(new StoragePath(logFilePath2)));
                HoodieCompactionOperation op = CompactionUtils.buildFromFileSlice((String)partition, (FileSlice)slice, (Option)Option.empty());
                if (deltaCommitsAfterCompactionRequests) {
                    FileCreateUtils.createLogFile(basePath, partition, compactionInstantTime, fileId, 1);
                    FileCreateUtils.createLogFile(basePath, partition, compactionInstantTime, fileId, 2);
                }
                return op;
            }
            catch (Exception e) {
                throw new HoodieException(e.getMessage(), (Throwable)e);
            }
        }).collect(Collectors.toList());
        return new HoodieCompactionPlan(ops.isEmpty() ? null : ops, new HashMap(), CompactionUtils.LATEST_COMPACTION_METADATA_VERSION, null, null);
    }

    public static class DummyHoodieBaseFile
    extends HoodieBaseFile {
        private final String path;

        public DummyHoodieBaseFile(String path) {
            super(path);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getFileId() {
            return UUID.randomUUID().toString();
        }

        public String getCommitTime() {
            return "100";
        }

        public long getFileSize() {
            return 0L;
        }
    }
}

