/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCreateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileCreateUtils.class);
    private static final String WRITE_TOKEN = "1-0-1";
    private static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static String baseFileName(String instantTime, String fileId) {
        return FileCreateUtils.baseFileName(instantTime, fileId, BASE_FILE_EXTENSION);
    }

    public static String baseFileName(String instantTime, String fileId, String fileExtension) {
        return FSUtils.makeBaseFileName((String)instantTime, (String)WRITE_TOKEN, (String)fileId, (String)fileExtension);
    }

    public static String logFileName(String instantTime, String fileId, int version) {
        return FileCreateUtils.logFileName(instantTime, fileId, version, HoodieFileFormat.HOODIE_LOG.getFileExtension());
    }

    public static String logFileName(String instantTime, String fileId, int version, String fileExtension) {
        return FSUtils.makeLogFileName((String)fileId, (String)fileExtension, (String)instantTime, (int)version, (String)WRITE_TOKEN);
    }

    public static String markerFileName(String fileName, IOType ioType) {
        return String.format("%s%s.%s", fileName, ".marker", ioType.name());
    }

    public static String dataFileMarkerFileName(String instantTime, String fileId, IOType ioType, String fileExtension, String writeToken) {
        return FileCreateUtils.markerFileName(FSUtils.makeBaseFileName((String)instantTime, (String)writeToken, (String)fileId, (String)fileExtension), ioType);
    }

    public static String logFileMarkerFileName(String instantTime, String fileId, IOType ioType, int logVersion) {
        return FileCreateUtils.logFileMarkerFileName(instantTime, fileId, ioType, ".log", logVersion);
    }

    public static String logFileMarkerFileName(String instantTime, String fileId, IOType ioType, String fileExtension, int logVersion) {
        return FileCreateUtils.markerFileName(FSUtils.makeLogFileName((String)fileId, (String)fileExtension, (String)instantTime, (int)logVersion, (String)WRITE_TOKEN), ioType);
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix, HoodieStorage storage) throws IOException {
        StoragePath metaFilePath;
        StoragePath parentPath = new StoragePath(basePath, ".hoodie");
        if (!storage.exists(parentPath)) {
            storage.create(parentPath).close();
        }
        if (!storage.exists(metaFilePath = new StoragePath(parentPath, instantTime + suffix))) {
            storage.create(metaFilePath).close();
        }
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, suffix, StringUtils.getUTF8Bytes((String)""));
    }

    private static void createMetaFile(String basePath, String instantTime, String suffix, byte[] content) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie");
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            if (content.length == 0) {
                Files.createFile(metaFilePath, new FileAttribute[0]);
            } else {
                Files.write(metaFilePath, content, new OpenOption[0]);
            }
        }
    }

    private static void deleteMetaFile(String basePath, String instantTime, String suffix, HoodieStorage storage) throws IOException {
        StoragePath parentPath = new StoragePath(basePath, ".hoodie");
        StoragePath metaFilePath = new StoragePath(parentPath, instantTime + suffix);
        if (storage.exists(metaFilePath)) {
            storage.deleteFile(metaFilePath);
        }
    }

    private static void deleteMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie");
        Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.exists(metaFilePath, new LinkOption[0])) {
            Files.delete(metaFilePath);
        }
    }

    public static void createCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".commit");
    }

    public static void createCommit(String basePath, String instantTime, Option<HoodieCommitMetadata> metadata) throws IOException {
        if (metadata.isPresent()) {
            FileCreateUtils.createMetaFile(basePath, instantTime, ".commit", StringUtils.getUTF8Bytes((String)((HoodieCommitMetadata)metadata.get()).toJsonString()));
        } else {
            FileCreateUtils.createMetaFile(basePath, instantTime, ".commit");
        }
    }

    public static void createSavepointCommit(String basePath, String instantTime, HoodieSavepointMetadata savepointMetadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".savepoint", (byte[])TimelineMetadataUtils.serializeSavepointMetadata((HoodieSavepointMetadata)savepointMetadata).get());
    }

    public static void createCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".commit", storage);
    }

    public static void createRequestedCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".commit.requested");
    }

    public static void createInflightCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".inflight");
    }

    public static void createDeltaCommit(String basePath, String instantTime, HoodieCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit", StringUtils.getUTF8Bytes((String)metadata.toJsonString()));
    }

    public static void createDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit");
    }

    public static void createDeltaCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit", storage);
    }

    public static void createRequestedDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit.requested");
    }

    public static void createInflightDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".deltacommit.inflight");
    }

    public static void createInflightReplaceCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.inflight");
    }

    public static void createReplaceCommit(String basePath, String instantTime, HoodieReplaceCommitMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit", StringUtils.getUTF8Bytes((String)metadata.toJsonString()));
    }

    public static void createRequestedReplaceCommit(String basePath, String instantTime, Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata) throws IOException {
        if (requestedReplaceMetadata.isPresent()) {
            FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.requested", (byte[])TimelineMetadataUtils.serializeRequestedReplaceMetadata((HoodieRequestedReplaceMetadata)((HoodieRequestedReplaceMetadata)requestedReplaceMetadata.get())).get());
        } else {
            FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.requested");
        }
    }

    public static void createInflightReplaceCommit(String basePath, String instantTime, Option<HoodieCommitMetadata> inflightReplaceMetadata) throws IOException {
        if (inflightReplaceMetadata.isPresent()) {
            FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.inflight", StringUtils.getUTF8Bytes((String)((HoodieCommitMetadata)inflightReplaceMetadata.get()).toJsonString()));
        } else {
            FileCreateUtils.createMetaFile(basePath, instantTime, ".replacecommit.inflight");
        }
    }

    public static void createRequestedCompactionCommit(String basePath, String instantTime, HoodieCompactionPlan requestedCompactionPlan) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION, (byte[])TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)requestedCompactionPlan).get());
    }

    public static void createCleanFile(String basePath, String instantTime, HoodieCleanMetadata metadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean", (byte[])TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)metadata).get());
    }

    public static void createCleanFile(String basePath, String instantTime, HoodieCleanMetadata metadata, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean", isEmpty ? EMPTY_BYTES : (byte[])TimelineMetadataUtils.serializeCleanMetadata((HoodieCleanMetadata)metadata).get());
    }

    public static void createRequestedCleanFile(String basePath, String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean.requested", (byte[])TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan).get());
    }

    public static void createRequestedCleanFile(String basePath, String instantTime, HoodieCleanerPlan cleanerPlan, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean.requested", isEmpty ? EMPTY_BYTES : (byte[])TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan).get());
    }

    public static void createInflightCleanFile(String basePath, String instantTime, HoodieCleanerPlan cleanerPlan) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean.inflight", (byte[])TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan).get());
    }

    public static void createInflightCleanFile(String basePath, String instantTime, HoodieCleanerPlan cleanerPlan, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".clean.inflight", isEmpty ? EMPTY_BYTES : (byte[])TimelineMetadataUtils.serializeCleanerPlan((HoodieCleanerPlan)cleanerPlan).get());
    }

    public static void createRequestedRollbackFile(String basePath, String instantTime, HoodieRollbackPlan plan) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".rollback.requested", (byte[])TimelineMetadataUtils.serializeRollbackPlan((HoodieRollbackPlan)plan).get());
    }

    public static void createRequestedRollbackFile(String basePath, String instantTime, byte[] content) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".rollback.requested", content);
    }

    public static void createRequestedRollbackFile(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".rollback.requested");
    }

    public static void createInflightRollbackFile(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".rollback.inflight");
    }

    public static void createRollbackFile(String basePath, String instantTime, HoodieRollbackMetadata hoodieRollbackMetadata, boolean isEmpty) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, ".rollback", isEmpty ? EMPTY_BYTES : (byte[])TimelineMetadataUtils.serializeRollbackMetadata((HoodieRollbackMetadata)hoodieRollbackMetadata).get());
    }

    public static void createRestoreFile(String basePath, String instantTime, HoodieRestoreMetadata hoodieRestoreMetadata) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, "restore", (byte[])TimelineMetadataUtils.serializeRestoreMetadata((HoodieRestoreMetadata)hoodieRestoreMetadata).get());
    }

    private static void createAuxiliaryMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.aux");
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            Files.createFile(metaFilePath, new FileAttribute[0]);
        }
    }

    public static void createRequestedCompaction(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createAuxiliaryMetaFile(basePath, instantTime, HoodieTimeline.REQUESTED_COMPACTION_EXTENSION);
    }

    public static void createInflightCompaction(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createAuxiliaryMetaFile(basePath, instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION);
    }

    public static void createPendingInflightCompaction(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createMetaFile(basePath, instantTime, HoodieTimeline.INFLIGHT_COMPACTION_EXTENSION);
    }

    public static void createInflightSavepoint(String basePath, String instantTime) throws IOException {
        FileCreateUtils.createAuxiliaryMetaFile(basePath, instantTime, ".savepoint.inflight");
    }

    public static void createPartitionMetaFile(String basePath, String partitionPath) throws IOException {
        Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path metaFilePath = parentPath.resolve(".hoodie_partition_metadata");
        if (Files.notExists(metaFilePath, new LinkOption[0])) {
            Files.createFile(metaFilePath, new FileAttribute[0]);
        }
    }

    public static String createBaseFile(String basePath, String partitionPath, String instantTime, String fileId) throws Exception {
        return FileCreateUtils.createBaseFile(basePath, partitionPath, instantTime, fileId, 1L);
    }

    public static String createBaseFile(String basePath, String partitionPath, String instantTime, String fileId, long length) throws Exception {
        return FileCreateUtils.createBaseFile(basePath, partitionPath, instantTime, fileId, length, Instant.now().toEpochMilli());
    }

    public static String createBaseFile(String basePath, String partitionPath, String instantTime, String fileId, long length, long lastModificationTimeMilli) throws Exception {
        Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path baseFilePath = parentPath.resolve(FileCreateUtils.baseFileName(instantTime, fileId));
        if (Files.notExists(baseFilePath, new LinkOption[0])) {
            Files.createFile(baseFilePath, new FileAttribute[0]);
        }
        try (RandomAccessFile raf = new RandomAccessFile(baseFilePath.toFile(), "rw");){
            raf.setLength(length);
        }
        Files.setLastModifiedTime(baseFilePath, FileTime.fromMillis(lastModificationTimeMilli));
        return baseFilePath.toString();
    }

    public static Path getBaseFilePath(String basePath, String partitionPath, String instantTime, String fileId) {
        Path parentPath = Paths.get(basePath, partitionPath);
        return parentPath.resolve(FileCreateUtils.baseFileName(instantTime, fileId));
    }

    public static String createLogFile(String basePath, String partitionPath, String instantTime, String fileId, int version) throws Exception {
        return FileCreateUtils.createLogFile(basePath, partitionPath, instantTime, fileId, version, 0);
    }

    public static String createLogFile(String basePath, String partitionPath, String instantTime, String fileId, int version, int length) throws Exception {
        Path parentPath = Paths.get(basePath, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path logFilePath = parentPath.resolve(FileCreateUtils.logFileName(instantTime, fileId, version));
        if (Files.notExists(logFilePath, new LinkOption[0])) {
            Files.createFile(logFilePath, new FileAttribute[0]);
        }
        RandomAccessFile raf = new RandomAccessFile(logFilePath.toFile(), "rw");
        raf.setLength(length);
        raf.close();
        return logFilePath.toString();
    }

    public static String createMarkerFile(String basePath, String partitionPath, String instantTime, String fileId, IOType ioType) throws IOException {
        return FileCreateUtils.createMarkerFile(basePath, partitionPath, instantTime, instantTime, fileId, ioType, WRITE_TOKEN);
    }

    public static String createMarkerFile(String basePath, String partitionPath, String commitInstant, String instantTime, String fileId, IOType ioType, String writeToken) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(FileCreateUtils.dataFileMarkerFileName(instantTime, fileId, ioType, BASE_FILE_EXTENSION, writeToken));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static String createLogFileMarker(String basePath, String partitionPath, String instantTime, String fileId, IOType ioType) throws IOException {
        return FileCreateUtils.createLogFileMarker(basePath, partitionPath, instantTime, fileId, ioType, HoodieLogFile.LOGFILE_BASE_VERSION);
    }

    public static String createLogFileMarker(String basePath, String partitionPath, String instantTime, String fileId, IOType ioType, int logVersion) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(FileCreateUtils.logFileMarkerFileName(instantTime, fileId, ioType, logVersion));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    public static String createFileMarkerByFileName(String basePath, String partitionPath, String instantTime, String fileName, IOType ioType) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        Files.createDirectories(parentPath, new FileAttribute[0]);
        Path markerFilePath = parentPath.resolve(FileCreateUtils.markerFileName(fileName, ioType));
        if (Files.notExists(markerFilePath, new LinkOption[0])) {
            Files.createFile(markerFilePath, new FileAttribute[0]);
        }
        return markerFilePath.toAbsolutePath().toString();
    }

    private static void removeMetaFile(String basePath, String instantTime, String suffix) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie");
        Path metaFilePath = parentPath.resolve(instantTime + suffix);
        if (Files.exists(metaFilePath, new LinkOption[0])) {
            Files.delete(metaFilePath);
        }
    }

    public static void deleteCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFile(basePath, instantTime, ".commit");
    }

    public static void deleteRequestedCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFile(basePath, instantTime, ".commit.requested");
    }

    public static void deleteInflightCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFile(basePath, instantTime, ".inflight");
    }

    public static void deleteDeltaCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFile(basePath, instantTime, ".deltacommit");
    }

    public static void deleteReplaceCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFile(basePath, instantTime, ".replacecommit");
    }

    public static void deleteRollbackCommit(String basePath, String instantTime) throws IOException {
        FileCreateUtils.removeMetaFile(basePath, instantTime, ".rollback");
    }

    public static Path renameFileToTemp(Path sourcePath, String instantTime) throws IOException {
        Path dummyFilePath = sourcePath.getParent().resolve(instantTime + ".temp");
        Files.move(sourcePath, dummyFilePath, new CopyOption[0]);
        return dummyFilePath;
    }

    public static void renameTempToMetaFile(Path tempFilePath, Path destPath) throws IOException {
        Files.move(tempFilePath, destPath, new CopyOption[0]);
    }

    public static long getTotalMarkerFileCount(String basePath, String partitionPath, String instantTime, IOType ioType) throws IOException {
        Path parentPath = Paths.get(basePath, ".hoodie/.temp", instantTime, partitionPath);
        if (Files.notExists(parentPath, new LinkOption[0])) {
            return 0L;
        }
        return Files.list(parentPath).filter(p -> p.getFileName().toString().endsWith(String.format("%s.%s", ".marker", ioType))).count();
    }

    public static List<Path> getPartitionPaths(Path basePath) throws IOException {
        if (Files.notExists(basePath, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return Files.list(basePath).filter(entry -> !entry.getFileName().toString().equals(".hoodie") && !FileCreateUtils.isBaseOrLogFilename(entry.getFileName().toString()) && !entry.getFileName().toString().startsWith(".hoodie_partition_metadata")).collect(Collectors.toList());
    }

    public static boolean isBaseOrLogFilename(String filename) {
        for (HoodieFileFormat format : HoodieFileFormat.values()) {
            if (!filename.contains(format.getFileExtension())) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Long> getBaseFileCountsForPaths(String basePath, HoodieStorage storage, String ... paths) {
        HashMap<String, Long> toReturn = new HashMap<String, Long>();
        try {
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(storage.getConf(), basePath);
            for (String path : paths) {
                HoodieTableFileSystemView fileSystemView = new HoodieTableFileSystemView(metaClient, metaClient.getCommitsTimeline().filterCompletedInstants(), storage.globEntries(new StoragePath(path)));
                toReturn.put(path, fileSystemView.getLatestBaseFiles().count());
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new HoodieException("Error reading hoodie table as a dataframe", (Throwable)e);
        }
    }

    public static void deleteDeltaCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.deleteMetaFile(basePath, instantTime, ".deltacommit", storage);
    }

    public static void deleteSavepointCommit(String basePath, String instantTime, HoodieStorage storage) throws IOException {
        FileCreateUtils.deleteMetaFile(basePath, instantTime, ".savepoint.inflight", storage);
        FileCreateUtils.deleteMetaFile(basePath, instantTime, ".savepoint", storage);
    }
}

