/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.hudi.common.util.BinaryUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBinaryUtil {
    @Test
    public void testIntConvert() {
        int i;
        int[] testInt = new int[]{-1, 1, -2, 10000, -100000, 2, Integer.MAX_VALUE, Integer.MIN_VALUE};
        ArrayList<OriginValueWrapper<Integer>> valueWrappers = new ArrayList<OriginValueWrapper<Integer>>();
        ArrayList<ConvertResultWrapper<Integer>> convertResultWrappers = new ArrayList<ConvertResultWrapper<Integer>>();
        for (i = 0; i < testInt.length; ++i) {
            valueWrappers.add(new OriginValueWrapper<Integer>(i, testInt[i]));
            convertResultWrappers.add(new ConvertResultWrapper<Integer>(i, BinaryUtil.intTo8Byte((int)testInt[i])));
        }
        Collections.sort(valueWrappers, (o1, o2) -> ((Integer)o1.originValue).compareTo((Integer)o2.originValue));
        Collections.sort(convertResultWrappers, (o1, o2) -> BinaryUtil.compareTo((byte[])o1.result, (int)0, (int)o1.result.length, (byte[])o2.result, (int)0, (int)o2.result.length));
        for (i = 0; i < testInt.length; ++i) {
            Assertions.assertEquals((Integer)((Integer)((OriginValueWrapper)valueWrappers.get((int)i)).index), (Integer)((Integer)((ConvertResultWrapper)convertResultWrappers.get((int)i)).index));
        }
    }

    @Test
    public void testLongConvert() {
        int i;
        long[] testLong = new long[]{-1L, 1L, -2L, 10000L, -100000L, 2L, Long.MAX_VALUE, Long.MIN_VALUE};
        ArrayList<OriginValueWrapper<Long>> valueWrappers = new ArrayList<OriginValueWrapper<Long>>();
        ArrayList<ConvertResultWrapper<Long>> convertResultWrappers = new ArrayList<ConvertResultWrapper<Long>>();
        for (i = 0; i < testLong.length; ++i) {
            valueWrappers.add(new OriginValueWrapper<Long>(Long.valueOf(i), testLong[i]));
            convertResultWrappers.add(new ConvertResultWrapper<Long>(Long.valueOf(i), BinaryUtil.longTo8Byte((long)testLong[i])));
        }
        Collections.sort(valueWrappers, (o1, o2) -> ((Long)o1.originValue).compareTo((Long)o2.originValue));
        Collections.sort(convertResultWrappers, (o1, o2) -> BinaryUtil.compareTo((byte[])o1.result, (int)0, (int)o1.result.length, (byte[])o2.result, (int)0, (int)o2.result.length));
        for (i = 0; i < testLong.length; ++i) {
            Assertions.assertEquals((Long)((Long)((OriginValueWrapper)valueWrappers.get((int)i)).index), (Long)((Long)((ConvertResultWrapper)convertResultWrappers.get((int)i)).index));
        }
    }

    @Test
    public void testDoubleConvert() {
        int i;
        double[] testDouble = new double[]{-1.0, 1.05, -2.3, 10000.002, -100000.7, 2.9, Double.MAX_VALUE};
        ArrayList<OriginValueWrapper<Double>> valueWrappers = new ArrayList<OriginValueWrapper<Double>>();
        ArrayList<ConvertResultWrapper<Double>> convertResultWrappers = new ArrayList<ConvertResultWrapper<Double>>();
        for (i = 0; i < testDouble.length; ++i) {
            valueWrappers.add(new OriginValueWrapper<Double>((double)i * 1.0, testDouble[i]));
            convertResultWrappers.add(new ConvertResultWrapper<Double>((double)i * 1.0, BinaryUtil.doubleTo8Byte((double)testDouble[i])));
        }
        Collections.sort(valueWrappers, (o1, o2) -> ((Double)o1.originValue).compareTo((Double)o2.originValue));
        Collections.sort(convertResultWrappers, (o1, o2) -> BinaryUtil.compareTo((byte[])o1.result, (int)0, (int)o1.result.length, (byte[])o2.result, (int)0, (int)o2.result.length));
        for (i = 0; i < testDouble.length; ++i) {
            Assertions.assertEquals((Double)((Double)((OriginValueWrapper)valueWrappers.get((int)i)).index), (Double)((Double)((ConvertResultWrapper)convertResultWrappers.get((int)i)).index));
        }
    }

    @Test
    public void testFloatConvert() {
        int i;
        float[] testDouble = new float[]{-1.0f, 1.05f, -2.3f, 10000.002f, -100000.7f, 2.9f, Float.MAX_VALUE, Float.MIN_VALUE};
        ArrayList<OriginValueWrapper<Float>> valueWrappers = new ArrayList<OriginValueWrapper<Float>>();
        ArrayList<ConvertResultWrapper<Float>> convertResultWrappers = new ArrayList<ConvertResultWrapper<Float>>();
        for (i = 0; i < testDouble.length; ++i) {
            valueWrappers.add(new OriginValueWrapper<Float>(Float.valueOf((float)((double)i * 1.0)), Float.valueOf(testDouble[i])));
            convertResultWrappers.add(new ConvertResultWrapper<Float>(Float.valueOf((float)((double)i * 1.0)), BinaryUtil.doubleTo8Byte((double)testDouble[i])));
        }
        Collections.sort(valueWrappers, (o1, o2) -> ((Float)o1.originValue).compareTo((Float)o2.originValue));
        Collections.sort(convertResultWrappers, (o1, o2) -> BinaryUtil.compareTo((byte[])o1.result, (int)0, (int)o1.result.length, (byte[])o2.result, (int)0, (int)o2.result.length));
        for (i = 0; i < testDouble.length; ++i) {
            Assertions.assertEquals((Float)((Float)((OriginValueWrapper)valueWrappers.get((int)i)).index), (Float)((Float)((ConvertResultWrapper)convertResultWrappers.get((int)i)).index));
        }
    }

    @Test
    public void testConvertBytesToLong() {
        long[] tests = new long[]{Long.MIN_VALUE, -1L, 0L, 1L, Long.MAX_VALUE};
        for (int i = 0; i < tests.length; ++i) {
            Assertions.assertEquals((long)BinaryUtil.convertBytesToLong((byte[])this.convertLongToBytes(tests[i])), (long)tests[i]);
        }
    }

    @Test
    public void testConvertBytesToLongWithPadding() {
        byte[] bytes = new byte[]{2, 127};
        Assertions.assertEquals((long)BinaryUtil.convertBytesToLong((byte[])bytes), (long)639L);
    }

    private byte[] convertLongToBytes(long num) {
        byte[] byteNum = new byte[8];
        for (int i = 0; i < 8; ++i) {
            int offset = 64 - (i + 1) * 8;
            byteNum[i] = (byte)(num >> offset & 0xFFL);
        }
        return byteNum;
    }

    private class OriginValueWrapper<T> {
        T index;
        T originValue;

        public OriginValueWrapper(T index, T originValue) {
            this.index = index;
            this.originValue = originValue;
        }
    }

    private class ConvertResultWrapper<T> {
        T index;
        byte[] result;

        public ConvertResultWrapper(T index, byte[] result) {
            this.index = index;
            this.result = result;
        }
    }
}

