/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestObjectSizeCalculator {
    @Test
    public void testGetObjectSize() {
        EmptyClass emptyClass = new EmptyClass();
        StringClass stringClass = new StringClass();
        PayloadClass payloadClass = new PayloadClass();
        String emptyString = "";
        String string = "hello";
        String[] stringArray = new String[]{emptyString, string, " world"};
        String[] anotherStringArray = new String[100];
        ArrayList stringList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder(100);
        int maxIntPrimitive = Integer.MAX_VALUE;
        int minIntPrimitive = Integer.MIN_VALUE;
        Integer maxInteger = Integer.MAX_VALUE;
        Integer minInteger = Integer.MIN_VALUE;
        long zeroLong = 0L;
        double zeroDouble = 0.0;
        boolean booleanField = true;
        Object object = new Object();
        String name = "Alice Bob";
        Person person = new Person(name);
        if (HoodieTestUtils.getJavaVersion() == 11 || HoodieTestUtils.getJavaVersion() == 17) {
            Assertions.assertEquals((long)48L, (long)ObjectSizeCalculator.getObjectSize((Object)string));
            Assertions.assertEquals((long)168L, (long)ObjectSizeCalculator.getObjectSize((Object)stringArray));
            Assertions.assertEquals((long)144L, (long)ObjectSizeCalculator.getObjectSize((Object)stringBuilder));
            Assertions.assertEquals((long)72L, (long)ObjectSizeCalculator.getObjectSize((Object)((Object)DayOfWeek.TUESDAY)));
            Assertions.assertEquals((long)(HoodieAvroUtils.gteqAvro1_9() ? 1256L : 1176L), (long)ObjectSizeCalculator.getObjectSize((Object)Schema.create((Schema.Type)Schema.Type.STRING)));
            Assertions.assertEquals((long)96L, (long)ObjectSizeCalculator.getObjectSize((Object)person));
        } else {
            Assertions.assertEquals((long)56L, (long)ObjectSizeCalculator.getObjectSize((Object)string));
            Assertions.assertEquals((long)184L, (long)ObjectSizeCalculator.getObjectSize((Object)stringArray));
            Assertions.assertEquals((long)240L, (long)ObjectSizeCalculator.getObjectSize((Object)stringBuilder));
            Assertions.assertEquals((long)80L, (long)ObjectSizeCalculator.getObjectSize((Object)((Object)DayOfWeek.TUESDAY)));
            Assertions.assertEquals((long)(HoodieAvroUtils.gteqAvro1_9() ? 1320L : 1240L), (long)ObjectSizeCalculator.getObjectSize((Object)Schema.create((Schema.Type)Schema.Type.STRING)));
            Assertions.assertEquals((long)104L, (long)ObjectSizeCalculator.getObjectSize((Object)person));
        }
        Assertions.assertEquals((long)40L, (long)ObjectSizeCalculator.getObjectSize((Object)emptyString));
        Assertions.assertEquals((long)416L, (long)ObjectSizeCalculator.getObjectSize((Object)anotherStringArray));
        Assertions.assertEquals((long)40L, (long)ObjectSizeCalculator.getObjectSize(stringList));
        Assertions.assertEquals((long)16L, (long)ObjectSizeCalculator.getObjectSize((Object)maxIntPrimitive));
        Assertions.assertEquals((long)16L, (long)ObjectSizeCalculator.getObjectSize((Object)minIntPrimitive));
        Assertions.assertEquals((long)16L, (long)ObjectSizeCalculator.getObjectSize((Object)maxInteger));
        Assertions.assertEquals((long)16L, (long)ObjectSizeCalculator.getObjectSize((Object)minInteger));
        Assertions.assertEquals((long)24L, (long)ObjectSizeCalculator.getObjectSize((Object)zeroLong));
        Assertions.assertEquals((long)24L, (long)ObjectSizeCalculator.getObjectSize((Object)zeroDouble));
        Assertions.assertEquals((long)16L, (long)ObjectSizeCalculator.getObjectSize((Object)booleanField));
        Assertions.assertEquals((long)16L, (long)ObjectSizeCalculator.getObjectSize((Object)object));
        Assertions.assertEquals((long)32L, (long)ObjectSizeCalculator.getObjectSize((Object)emptyClass));
        Assertions.assertEquals((long)40L, (long)ObjectSizeCalculator.getObjectSize((Object)stringClass));
        Assertions.assertEquals((long)40L, (long)ObjectSizeCalculator.getObjectSize((Object)payloadClass));
    }

    public static enum DayOfWeek {
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        SUNDAY;

    }

    class Person {
        private String name;

        public Person(String name) {
            this.name = name;
        }
    }

    class PayloadClass
    implements Serializable {
        private HoodieRecord record;

        PayloadClass() {
        }
    }

    class StringClass {
        private String s;

        StringClass() {
        }
    }

    class EmptyClass {
        EmptyClass() {
        }
    }
}

