/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.RateLimiter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRatelimiter {
    @Test
    public void testRateLimiterWithNoThrottling() throws InterruptedException {
        RateLimiter limiter = RateLimiter.create((int)1000, (TimeUnit)TimeUnit.SECONDS);
        long start = System.currentTimeMillis();
        Assertions.assertEquals((Object)true, (Object)limiter.tryAcquire(1000));
        Thread.sleep(500L);
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start < TimeUnit.SECONDS.toMillis(2L) ? 1 : 0) != 0);
    }

    @Test
    public void testRateLimiterWithThrottling() throws InterruptedException {
        RateLimiter limiter = RateLimiter.create((int)100, (TimeUnit)TimeUnit.SECONDS);
        long start = System.currentTimeMillis();
        Assertions.assertEquals((Object)true, (Object)limiter.tryAcquire(400));
        Thread.sleep(500L);
        long end = System.currentTimeMillis();
        Assertions.assertTrue((end - start >= TimeUnit.SECONDS.toMillis(2L) ? 1 : 0) != 0);
    }
}

