/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSerDeHelper {
    @Test
    public void testComplexSchema2Json() {
        Types.RecordType recordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)7, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)8, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)13, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)14, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)15, (boolean)false, (String)"y", (Type)Types.LongType.get())}))), Types.Field.get((int)5, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)16, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)6, (boolean)true, (String)"properties", (Type)Types.MapType.get((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        InternalSchema internalSchema = new InternalSchema(recordType);
        String result = SerDeHelper.toJson((InternalSchema)internalSchema);
        InternalSchema convertedSchema = (InternalSchema)SerDeHelper.fromJson((String)result).get();
        Assertions.assertEquals((Object)internalSchema, (Object)convertedSchema);
        String results = SerDeHelper.toJson(Arrays.asList(internalSchema));
        TreeMap convertedSchemas = SerDeHelper.parseSchemas((String)results);
        Assertions.assertEquals((int)1, (int)convertedSchemas.size());
    }

    @Test
    public void testPrimitive2Json() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"bool", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"int", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"long", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"float", (Type)Types.FloatType.get()), Types.Field.get((int)4, (String)"double", (Type)Types.DoubleType.get()), Types.Field.get((int)5, (String)"date", (Type)Types.DateType.get()), Types.Field.get((int)6, (String)"time", (Type)Types.TimeType.get()), Types.Field.get((int)7, (String)"timestamp", (Type)Types.TimestampType.get()), Types.Field.get((int)8, (String)"string", (Type)Types.StringType.get()), Types.Field.get((int)9, (String)"uuid", (Type)Types.UUIDType.get()), Types.Field.get((int)10, (String)"fixed", (Type)Types.FixedType.getFixed((int)10)), Types.Field.get((int)11, (String)"binary", (Type)Types.BinaryType.get()), Types.Field.get((int)12, (String)"decimal", (Type)Types.DecimalType.get((int)10, (int)2))));
        InternalSchema internalSchema = new InternalSchema(record);
        String result = SerDeHelper.toJson((InternalSchema)internalSchema);
        InternalSchema convertedSchema = (InternalSchema)SerDeHelper.fromJson((String)result).get();
        Assertions.assertEquals((Object)internalSchema, (Object)convertedSchema);
    }

    @Test
    public void testSearchSchema() {
        ArrayList<InternalSchema> schemas = new ArrayList<InternalSchema>();
        for (int i = 0; i < 100; ++i) {
            schemas.add(new InternalSchema((long)(i * 10), Types.RecordType.get(Arrays.asList(Types.Field.get((int)1, (boolean)true, (String)("schema" + i * 10), (Type)Types.LongType.get())))));
        }
        Assertions.assertEquals(InternalSchemaUtils.searchSchema((long)0L, schemas).getRecord().fields().get(0), (Object)Types.Field.get((int)1, (boolean)true, (String)"schema0", (Type)Types.LongType.get()));
        Assertions.assertEquals(InternalSchemaUtils.searchSchema((long)9L, schemas).getRecord().fields().get(0), (Object)Types.Field.get((int)1, (boolean)true, (String)"schema0", (Type)Types.LongType.get()));
        Assertions.assertEquals(InternalSchemaUtils.searchSchema((long)99L, schemas).getRecord().fields().get(0), (Object)Types.Field.get((int)1, (boolean)true, (String)"schema90", (Type)Types.LongType.get()));
        Assertions.assertEquals(InternalSchemaUtils.searchSchema((long)9999L, schemas).getRecord().fields().get(0), (Object)Types.Field.get((int)1, (boolean)true, (String)"schema990", (Type)Types.LongType.get()));
    }

    @Test
    public void testInheritSchemas() {
        ArrayList<InternalSchema> schemas = new ArrayList<InternalSchema>();
        for (int i = 0; i < 2; ++i) {
            schemas.add(new InternalSchema((long)i, Types.RecordType.get(Arrays.asList(Types.Field.get((int)1, (boolean)true, (String)("schema" + i), (Type)Types.LongType.get())))));
        }
        String oldSchemas = SerDeHelper.toJson(schemas);
        InternalSchema newSchema = new InternalSchema(3L, Types.RecordType.get(Arrays.asList(Types.Field.get((int)1, (boolean)true, (String)"schema3", (Type)Types.LongType.get()))));
        String finalResult = SerDeHelper.inheritSchemas((InternalSchema)newSchema, (String)oldSchemas);
        Assertions.assertEquals((int)SerDeHelper.parseSchemas((String)finalResult).size(), (int)3);
    }
}

