/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.Arrays;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.InternalSchemaChangeApplier;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableChanges {
    @Test
    public void testPrimitiveAdd() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"col2", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"col3", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get())));
        Types.RecordType checkRecord = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get()), Types.Field.get((int)4, (boolean)true, (String)"c1", (Type)Types.BooleanType.get(), (String)"add c1 after col1"), Types.Field.get((int)1, (String)"col2", (Type)Types.IntType.get()), Types.Field.get((int)5, (boolean)true, (String)"c2", (Type)Types.IntType.get(), (String)"add c2 before col3"), Types.Field.get((int)2, (String)"col3", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get())));
        InternalSchema oldSchema = new InternalSchema(record);
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get((InternalSchema)oldSchema);
        addChange.addColumns("c1", (Type)Types.BooleanType.get(), "add c1 after col1");
        Assertions.assertThrows(HoodieSchemaException.class, () -> addChange.addColumns("c1", (Type)Types.BooleanType.get(), "add c1 after col1"));
        addChange.addPositionChange("c1", "col1", "after");
        addChange.addColumns("c2", (Type)Types.IntType.get(), "add c2 before col3");
        addChange.addPositionChange("c2", "col3", "before");
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnAddChange)addChange);
        Assertions.assertEquals((Object)newSchema.getRecord(), (Object)checkRecord);
    }

    @Test
    public void testNestAdd() {
        Types.RecordType recordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)7, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)8, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)13, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)14, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)15, (boolean)false, (String)"y", (Type)Types.LongType.get())}))), Types.Field.get((int)5, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)16, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)6, (boolean)true, (String)"properties", (Type)Types.MapType.get((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        InternalSchema oldSchema = new InternalSchema(recordType);
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get((InternalSchema)oldSchema);
        addChange.addColumns("c1", (Type)Types.StringType.get(), "add c1 first");
        addChange.addPositionChange("c1", "id", "before");
        addChange.addColumns("preferences", "cx", (Type)Types.BooleanType.get(), "add preferences.cx before preferences.feature2");
        Assertions.assertThrows(HoodieSchemaException.class, () -> addChange.addColumns("preferences", "cx", (Type)Types.BooleanType.get(), "add preferences.cx before preferences.feature2"));
        addChange.addPositionChange("preferences.cx", "preferences.feature2", "before");
        addChange.addColumns("locations.value", "lax", (Type)Types.BooleanType.get(), "add locations.value.lax before locations.value.long");
        addChange.addPositionChange("locations.value.lax", "locations.value.long", "before");
        addChange.addColumns("points.element", "z", (Type)Types.BooleanType.get(), "add points.element.z after points.element.y");
        addChange.addPositionChange("points.element.z", "points.element.y", "after");
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnAddChange)addChange);
        Types.RecordType expectedRecordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)19, (boolean)true, (String)"c1", (Type)Types.StringType.get(), (String)"add c1 first"), Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)7, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)20, (boolean)true, (String)"cx", (Type)Types.BooleanType.get(), (String)"add preferences.cx before preferences.feature2"), Types.Field.get((int)8, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)21, (boolean)true, (String)"lax", (Type)Types.BooleanType.get(), (String)"add locations.value.lax before locations.value.long"), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)13, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)14, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)15, (boolean)false, (String)"y", (Type)Types.LongType.get()), Types.Field.get((int)22, (boolean)true, (String)"z", (Type)Types.BooleanType.get(), (String)"add points.element.z after points.element.y")}))), Types.Field.get((int)5, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)16, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)6, (boolean)true, (String)"properties", (Type)Types.MapType.get((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        Assertions.assertEquals((Object)expectedRecordType, (Object)newSchema.getRecord());
    }

    @Test
    public void testPrimitiveDelete() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"col2", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"col3", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get())));
        InternalSchema oldSchema = new InternalSchema(record);
        TableChanges.ColumnDeleteChange deleteChange = TableChanges.ColumnDeleteChange.get((InternalSchema)oldSchema);
        deleteChange.deleteColumn("col1");
        deleteChange.deleteColumn("col1");
        deleteChange.deleteColumn("col3");
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnDeleteChange)deleteChange);
        Types.RecordType checkRecord = Types.RecordType.get(Arrays.asList(Types.Field.get((int)1, (String)"col2", (Type)Types.IntType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get())));
        Assertions.assertEquals((Object)newSchema.getRecord(), (Object)checkRecord);
    }

    @Test
    public void testNestDelete() {
        Types.RecordType recordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)9, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)10, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)11, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)12, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)13, (boolean)false, (String)"y", (Type)Types.LongType.get())})))});
        InternalSchema oldSchema = new InternalSchema(recordType);
        TableChanges.ColumnDeleteChange deleteChange = TableChanges.ColumnDeleteChange.get((InternalSchema)oldSchema);
        deleteChange.deleteColumn("data");
        deleteChange.deleteColumn("preferences.feature2");
        deleteChange.deleteColumn("preferences.feature2");
        deleteChange.deleteColumn("locations.value.lat");
        deleteChange.deleteColumn("points.element.y");
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnDeleteChange)deleteChange);
        Types.RecordType checkedRecordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)10, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)11, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)12, (boolean)false, (String)"x", (Type)Types.LongType.get())})))});
        Assertions.assertEquals((Object)checkedRecordType, (Object)newSchema.getRecord());
    }

    @Test
    public void testPrimitiveUpdate() {
        Types.RecordType record = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get()), Types.Field.get((int)1, (String)"col2", (Type)Types.IntType.get()), Types.Field.get((int)2, (String)"col3", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get())));
        InternalSchema oldSchema = new InternalSchema(record);
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get((InternalSchema)oldSchema);
        updateChange.updateColumnType("col2", (Type)Types.LongType.get()).updateColumnComment("col2", "alter col2 comments").renameColumn("col2", "colx").addPositionChange("col2", "col4", "after");
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnUpdateChange)updateChange);
        Types.RecordType checkedRecord = Types.RecordType.get(Arrays.asList(Types.Field.get((int)0, (String)"col1", (Type)Types.BooleanType.get()), Types.Field.get((int)2, (String)"col3", (Type)Types.LongType.get()), Types.Field.get((int)3, (String)"col4", (Type)Types.FloatType.get()), Types.Field.get((int)1, (boolean)true, (String)"colx", (Type)Types.LongType.get(), (String)"alter col2 comments")));
        Assertions.assertEquals((Object)newSchema.getRecord(), (Object)checkedRecord);
    }

    @Test
    public void testNestUpdate() {
        Types.RecordType recordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)9, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)10, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)11, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)12, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)13, (boolean)false, (String)"y", (Type)Types.LongType.get())})))});
        InternalSchema oldSchema = new InternalSchema(recordType);
        TableChanges.ColumnUpdateChange updateChange = TableChanges.ColumnUpdateChange.get((InternalSchema)oldSchema);
        updateChange.updateColumnNullability("id", true).renameColumn("id", "idx").addPositionChange("data", "points", "after");
        updateChange.updateColumnComment("preferences.feature1", "add feature1 comment").renameColumn("preferences.feature1", "f1").addPositionChange("preferences.feature1", "preferences.feature1", "first");
        updateChange.updateColumnComment("locations.value.lat", "add lat comment").renameColumn("locations.value.lat", "lax").addPositionChange("locations.value.lat", "locations.value.lat", "first");
        updateChange.renameColumn("points.element.x", "z").addPositionChange("points.element.x", "points.element.y", "after");
        InternalSchema newSchema = SchemaChangeUtils.applyTableChanges2Schema((InternalSchema)oldSchema, (TableChanges.ColumnUpdateChange)updateChange);
        Types.RecordType expectedRecordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)true, (String)"idx", (Type)Types.IntType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)5, (boolean)false, (String)"f1", (Type)Types.BooleanType.get(), (String)"add feature1 comment"), Types.Field.get((int)6, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)9, (boolean)false, (String)"lax", (Type)Types.FloatType.get(), (String)"add lat comment"), Types.Field.get((int)10, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)11, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)13, (boolean)false, (String)"y", (Type)Types.LongType.get()), Types.Field.get((int)12, (boolean)false, (String)"z", (Type)Types.LongType.get())}))), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get())});
        Assertions.assertEquals((Object)expectedRecordType, (Object)newSchema.getRecord());
    }

    @Test
    public void testChangeApplier() {
        Types.RecordType recordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)7, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)8, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)13, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)14, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)15, (boolean)false, (String)"y", (Type)Types.LongType.get())}))), Types.Field.get((int)5, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)16, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)6, (boolean)true, (String)"properties", (Type)Types.MapType.get((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        InternalSchema oldSchema = new InternalSchema(recordType);
        InternalSchema newSchema = TestTableChanges.addOperationForSchemaChangeApplier(oldSchema, "c1", (Type)Types.StringType.get(), "add c1 first", "id", TableChange.ColumnPositionChange.ColumnPositionType.BEFORE);
        InternalSchema currSchema = newSchema = TestTableChanges.addOperationForSchemaChangeApplier(newSchema, "preferences.cx", (Type)Types.BooleanType.get(), "add preferences.cx before preferences.feature2", "preferences.feature2", TableChange.ColumnPositionChange.ColumnPositionType.BEFORE);
        Assertions.assertThrows(HoodieSchemaException.class, () -> TestTableChanges.addOperationForSchemaChangeApplier(currSchema, "preferences.cx", (Type)Types.BooleanType.get(), "add preferences.cx before preferences.feature2"));
        newSchema = TestTableChanges.addOperationForSchemaChangeApplier(newSchema, "locations.value.lax", (Type)Types.BooleanType.get(), "add locations.value.lax before locations.value.long");
        newSchema = TestTableChanges.reOrderOperationForSchemaChangeApplier(newSchema, "locations.value.lax", "locations.value.long", TableChange.ColumnPositionChange.ColumnPositionType.BEFORE);
        newSchema = TestTableChanges.addOperationForSchemaChangeApplier(newSchema, "points.element.z", (Type)Types.BooleanType.get(), "add points.element.z after points.element.y", "points.element.y", TableChange.ColumnPositionChange.ColumnPositionType.AFTER);
        Types.RecordType expectedRecordType = Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)19, (boolean)true, (String)"c1", (Type)Types.StringType.get(), (String)"add c1 first"), Types.Field.get((int)0, (boolean)false, (String)"id", (Type)Types.IntType.get()), Types.Field.get((int)1, (boolean)true, (String)"data", (Type)Types.StringType.get()), Types.Field.get((int)2, (boolean)true, (String)"preferences", (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)7, (boolean)false, (String)"feature1", (Type)Types.BooleanType.get()), Types.Field.get((int)20, (boolean)true, (String)"cx", (Type)Types.BooleanType.get(), (String)"add preferences.cx before preferences.feature2"), Types.Field.get((int)8, (boolean)true, (String)"feature2", (Type)Types.BooleanType.get())})), Types.Field.get((int)3, (boolean)false, (String)"locations", (Type)Types.MapType.get((int)9, (int)10, (Type)Types.StringType.get(), (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)11, (boolean)false, (String)"lat", (Type)Types.FloatType.get()), Types.Field.get((int)21, (boolean)true, (String)"lax", (Type)Types.BooleanType.get(), (String)"add locations.value.lax before locations.value.long"), Types.Field.get((int)12, (boolean)false, (String)"long", (Type)Types.FloatType.get())}), (boolean)false)), Types.Field.get((int)4, (boolean)true, (String)"points", (Type)Types.ArrayType.get((int)13, (boolean)true, (Type)Types.RecordType.get((Types.Field[])new Types.Field[]{Types.Field.get((int)14, (boolean)false, (String)"x", (Type)Types.LongType.get()), Types.Field.get((int)15, (boolean)false, (String)"y", (Type)Types.LongType.get()), Types.Field.get((int)22, (boolean)true, (String)"z", (Type)Types.BooleanType.get(), (String)"add points.element.z after points.element.y")}))), Types.Field.get((int)5, (boolean)false, (String)"doubles", (Type)Types.ArrayType.get((int)16, (boolean)false, (Type)Types.DoubleType.get())), Types.Field.get((int)6, (boolean)true, (String)"properties", (Type)Types.MapType.get((int)17, (int)18, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        Assertions.assertEquals((Object)expectedRecordType, (Object)newSchema.getRecord());
    }

    private static InternalSchema addOperationForSchemaChangeApplier(InternalSchema schema, String colName, Type colType, String doc, String position, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        InternalSchemaChangeApplier applier = new InternalSchemaChangeApplier(schema);
        return applier.applyAddChange(colName, colType, doc, position, positionType);
    }

    private static InternalSchema reOrderOperationForSchemaChangeApplier(InternalSchema schema, String colName, String position, TableChange.ColumnPositionChange.ColumnPositionType positionType) {
        InternalSchemaChangeApplier applier = new InternalSchemaChangeApplier(schema);
        return applier.applyReOrderColPositionChange(colName, position, positionType);
    }

    private static InternalSchema addOperationForSchemaChangeApplier(InternalSchema schema, String colName, Type colType, String doc) {
        return TestTableChanges.addOperationForSchemaChangeApplier(schema, colName, colType, doc, "", TableChange.ColumnPositionChange.ColumnPositionType.NO_OPERATION);
    }
}

