/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hudi.common.data.HoodieBaseListData;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListPairData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieListData<T>
extends HoodieBaseListData<T>
implements HoodieData<T> {
    private HoodieListData(List<T> data, boolean lazy) {
        super(data, lazy);
    }

    HoodieListData(Stream<T> dataStream, boolean lazy) {
        super(dataStream, lazy);
    }

    public static <T> HoodieListData<T> eager(List<T> listData) {
        return new HoodieListData<T>(listData, false);
    }

    public static <T> HoodieListData<T> lazy(List<T> listData) {
        return new HoodieListData<T>(listData, true);
    }

    @Override
    public int getId() {
        return -1;
    }

    @Override
    public void persist(String level) {
    }

    @Override
    public void persist(String level, HoodieEngineContext engineContext, HoodieData.HoodieDataCacheKey cacheKey) {
    }

    @Override
    public void unpersist() {
    }

    @Override
    public <O> HoodieData<O> map(SerializableFunction<T, O> func) {
        return new HoodieListData<O>(this.asStream().map(FunctionWrapper.throwingMapWrapper(func)), this.lazy);
    }

    @Override
    public <O> HoodieData<O> mapPartitions(SerializableFunction<Iterator<T>, Iterator<O>> func, boolean preservesPartitioning) {
        Function mapper = FunctionWrapper.throwingMapWrapper(func);
        return new HoodieListData<O>(StreamSupport.stream(Spliterators.spliteratorUnknownSize(mapper.apply(this.asStream().iterator()), 16), true), this.lazy);
    }

    @Override
    public <O> HoodieData<O> flatMap(SerializableFunction<T, Iterator<O>> func) {
        Function mapper = FunctionWrapper.throwingMapWrapper(func);
        Stream mappedStream = this.asStream().flatMap((? super T e) -> StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)mapper.apply(e), 16), true));
        return new HoodieListData(mappedStream, this.lazy);
    }

    @Override
    public <K, V> HoodiePairData<K, V> flatMapToPair(SerializableFunction<T, Iterator<? extends Pair<K, V>>> func) {
        Function mapper = FunctionWrapper.throwingMapWrapper(func);
        Stream mappedStream = this.asStream().flatMap((? super T e) -> StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)mapper.apply(e), 16), true));
        return new HoodieListPairData(mappedStream, this.lazy);
    }

    @Override
    public <K, V> HoodiePairData<K, V> mapToPair(SerializablePairFunction<T, K, V> func) {
        Function<T, Pair<K, V>> throwableMapToPairFunc = FunctionWrapper.throwingMapToPairWrapper(func);
        return new HoodieListPairData<K, V>(this.asStream().map(throwableMapToPairFunc), this.lazy);
    }

    @Override
    public HoodieData<T> distinct() {
        return new HoodieListData(this.asStream().distinct(), this.lazy);
    }

    @Override
    public HoodieData<T> distinct(int parallelism) {
        return this.distinct();
    }

    @Override
    public <O> HoodieData<T> distinctWithKey(SerializableFunction<T, O> keyGetter, int parallelism) {
        return this.mapToPair(i -> Pair.of(keyGetter.apply(i), i)).reduceByKey((value1, value2) -> value1, parallelism).values();
    }

    @Override
    public HoodieData<T> filter(SerializableFunction<T, Boolean> filterFunc) {
        return new HoodieListData<Object>(this.asStream().filter((? super T r) -> (Boolean)FunctionWrapper.throwingMapWrapper(filterFunc).apply(r)), this.lazy);
    }

    @Override
    public HoodieData<T> union(HoodieData<T> other) {
        ValidationUtils.checkArgument((boolean)(other instanceof HoodieListData));
        return new HoodieListData(Stream.concat(this.asStream(), ((HoodieListData)other).asStream()), this.lazy);
    }

    @Override
    public HoodieData<T> repartition(int parallelism) {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public long count() {
        return super.count();
    }

    @Override
    public int getNumPartitions() {
        return 1;
    }

    @Override
    public List<T> collectAsList() {
        return super.collectAsList();
    }
}

