/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.util.Option;

public enum HoodieOperation {
    INSERT("I", 0),
    UPDATE_BEFORE("-U", 1),
    UPDATE_AFTER("U", 2),
    DELETE("D", 3);

    private final String name;
    private final byte value;

    private HoodieOperation(String name, byte value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public byte getValue() {
        return this.value;
    }

    public static HoodieOperation fromValue(byte value) {
        switch (value) {
            case 0: {
                return INSERT;
            }
            case 1: {
                return UPDATE_BEFORE;
            }
            case 2: {
                return UPDATE_AFTER;
            }
            case 3: {
                return DELETE;
            }
        }
        throw new AssertionError();
    }

    public static HoodieOperation fromName(Option<String> nameOpt) {
        if (!nameOpt.isPresent()) {
            return null;
        }
        return HoodieOperation.fromName((String)nameOpt.get());
    }

    public static HoodieOperation fromName(String name) {
        switch (name) {
            case "I": {
                return INSERT;
            }
            case "-U": {
                return UPDATE_BEFORE;
            }
            case "U": {
                return UPDATE_AFTER;
            }
            case "D": {
                return DELETE;
            }
        }
        throw new AssertionError();
    }

    public static boolean isInsert(HoodieOperation operation) {
        return operation == INSERT;
    }

    public static boolean isUpdateBefore(HoodieOperation operation) {
        return operation == UPDATE_BEFORE;
    }

    public static boolean isUpdateAfter(HoodieOperation operation) {
        return operation == UPDATE_AFTER;
    }

    public static boolean isDelete(HoodieOperation operation) {
        return operation == DELETE;
    }
}

