/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieDefaultTimeline
implements HoodieTimeline {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieDefaultTimeline.class);
    private static final long serialVersionUID = 1L;
    private static final String HASHING_ALGORITHM = "SHA-256";
    protected transient Function<HoodieInstant, Option<byte[]>> details;
    private List<HoodieInstant> instants;
    private volatile transient Set<String> instantTimeSet;
    private volatile transient Set<String> pendingReplaceClusteringInstants;
    private volatile transient Option<HoodieInstant> firstNonSavepointCommit;
    private String timelineHash;

    public HoodieDefaultTimeline(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details) {
        this.details = details;
        this.setInstants(instants.collect(Collectors.toList()));
    }

    public void setInstants(List<HoodieInstant> instants) {
        MessageDigest md;
        this.instants = instants;
        try {
            md = MessageDigest.getInstance(HASHING_ALGORITHM);
            this.instants.forEach(i -> md.update(StringUtils.getUTF8Bytes((String)StringUtils.joinUsingDelim((String)"_", (String[])new String[]{i.getTimestamp(), i.getAction(), i.getState().name()}))));
        }
        catch (NoSuchAlgorithmException nse) {
            throw new HoodieException((Throwable)nse);
        }
        this.timelineHash = StringUtils.toHexString((byte[])md.digest());
    }

    public HoodieDefaultTimeline() {
    }

    @Override
    public HoodieTimeline filterInflights() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter(HoodieInstant::isInflight), this.details);
    }

    @Override
    public HoodieTimeline filterInflightsAndRequested() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T i) -> i.getState().equals((Object)HoodieInstant.State.REQUESTED) || i.getState().equals((Object)HoodieInstant.State.INFLIGHT)), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingCompaction() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T instant) -> !instant.isCompleted() && !instant.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingLogCompaction() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T instant) -> !instant.isCompleted() && !instant.getAction().equals("logcompaction")), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingMajorAndMinorCompaction() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T instant) -> !instant.isCompleted() && (!instant.getAction().equals("compaction") || !instant.getAction().equals("logcompaction"))), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedInstants() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedAndCompactionInstants() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.isCompleted() || s.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedOrMajorOrMinorCompactionInstants() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.isCompleted() || s.getAction().equals("compaction") || s.getAction().equals("logcompaction")), this.details);
    }

    @Override
    public HoodieDefaultTimeline filterCompletedInstantsOrRewriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("compaction", "logcompaction", "replacecommit");
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.isCompleted() || validActions.contains(s.getAction())), this.details);
    }

    @Override
    public HoodieDefaultTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "logcompaction", "replacecommit");
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> validActions.contains(s.getAction())), this.details);
    }

    @Override
    public HoodieTimeline getContiguousCompletedWriteTimeline() {
        Option<HoodieInstant> earliestPending = this.getWriteTimeline().filterInflightsAndRequested().firstInstant();
        if (earliestPending.isPresent()) {
            return this.getWriteTimeline().filterCompletedInstants().filter(instant -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), LESSER_THAN, ((HoodieInstant)earliestPending.get()).getTimestamp()));
        }
        return this.getWriteTimeline().filterCompletedInstants();
    }

    @Override
    public HoodieTimeline getCompletedReplaceTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("replacecommit")).filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterPendingReplaceTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("replacecommit") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingRollbackTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("rollback") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterRequestedRollbackTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("rollback") && s.isRequested()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingCompactionTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("compaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingLogCompactionTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("logcompaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingMajorOrMinorCompactionTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("compaction") || s.getAction().equals("logcompaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsInRange(String startTs, String endTs) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.isInRange(s.getTimestamp(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsInClosedRange(String startTs, String endTs) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T instant) -> HoodieTimeline.isInClosedRange(instant.getTimestamp(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsInRangeByStateTransitionTime(String startTs, String endTs) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.isInRange(s.getStateTransitionTime(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsModifiedAfterByStateTransitionTime(String instantTime) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getStateTransitionTime(), GREATER_THAN, instantTime) && !s.getTimestamp().equals(instantTime)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsAfter(String instantTime, int numCommits) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), GREATER_THAN, instantTime)).limit(numCommits), this.details);
    }

    @Override
    public HoodieTimeline findInstantsAfter(String instantTime) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), GREATER_THAN, instantTime)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsAfterOrEquals(String commitTime, int numCommits) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), GREATER_THAN_OR_EQUALS, commitTime)).limit(numCommits), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsBefore(String instantTime) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), LESSER_THAN, instantTime)), this.details);
    }

    @Override
    public Option<HoodieInstant> findInstantBefore(String instantTime) {
        return Option.fromJavaOptional(this.instants.stream().filter((? super T instant) -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), LESSER_THAN, instantTime)).max(Comparator.comparing(HoodieInstant::getTimestamp)));
    }

    @Override
    public HoodieDefaultTimeline findInstantsBeforeOrEquals(String instantTime) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), LESSER_THAN_OR_EQUALS, instantTime)), this.details);
    }

    @Override
    public HoodieTimeline filter(Predicate<HoodieInstant> filter) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter(filter), this.details);
    }

    @Override
    public HoodieTimeline filterPendingIndexTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("indexing") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedIndexTimeline() {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("indexing") && s.isCompleted()), this.details);
    }

    public HoodieTimeline getCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit"));
    }

    public HoodieTimeline getCommitsAndCompactionTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit", "compaction"));
    }

    public HoodieTimeline getAllCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "clean", "compaction", "savepoint", "rollback", "replacecommit", "indexing", "logcompaction"));
    }

    public HoodieTimeline getCommitAndReplaceTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "replacecommit"));
    }

    public HoodieTimeline getCommitTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit"));
    }

    public HoodieTimeline getDeltaCommitTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("deltacommit"), this::getInstantDetails);
    }

    public HoodieTimeline getTimelineOfActions(Set<String> actions) {
        return new HoodieDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> actions.contains(s.getAction())), this::getInstantDetails);
    }

    public HoodieTimeline getCleanerTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("clean"), this::getInstantDetails);
    }

    public HoodieTimeline getRollbackTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("rollback"), this::getInstantDetails);
    }

    public HoodieTimeline getRollbackAndRestoreTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("rollback", "restore"));
    }

    public HoodieTimeline getSavePointTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("savepoint"), this::getInstantDetails);
    }

    public HoodieTimeline getRestoreTimeline() {
        return new HoodieDefaultTimeline(this.filterInstantsByAction("restore"), this::getInstantDetails);
    }

    protected Stream<HoodieInstant> filterInstantsByAction(String action) {
        return this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals(action));
    }

    @Override
    public boolean empty() {
        return this.instants.isEmpty();
    }

    @Override
    public int countInstants() {
        return this.instants.size();
    }

    @Override
    public Option<HoodieInstant> firstInstant() {
        return Option.fromJavaOptional(this.getInstantsAsStream().findFirst());
    }

    @Override
    public Option<HoodieInstant> firstInstant(String action, HoodieInstant.State state) {
        return Option.fromJavaOptional(this.getInstantsAsStream().filter((? super T s) -> action.equals(s.getAction()) && state.equals((Object)s.getState())).findFirst());
    }

    @Override
    public Option<HoodieInstant> nthInstant(int n) {
        if (this.empty() || n >= this.countInstants()) {
            return Option.empty();
        }
        return Option.of((Object)this.getInstants().get(n));
    }

    @Override
    public Option<HoodieInstant> lastInstant() {
        return this.empty() ? Option.empty() : this.nthInstant(this.countInstants() - 1);
    }

    @Override
    public Option<HoodieInstant> nthFromLastInstant(int n) {
        if (this.countInstants() < n + 1) {
            return Option.empty();
        }
        return this.nthInstant(this.countInstants() - 1 - n);
    }

    @Override
    public boolean containsInstant(HoodieInstant instant) {
        return this.getInstantsAsStream().anyMatch(s -> s.equals(instant));
    }

    @Override
    public boolean containsInstant(String ts) {
        if (this.getOrCreateInstantSet().contains(ts)) {
            return true;
        }
        if (ts.length() == HoodieInstantTimeGenerator.MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH && ts.endsWith("999")) {
            String actualOlderFormatTs = ts.substring(0, ts.length() - "999".length());
            return this.containsInstant(actualOlderFormatTs);
        }
        return false;
    }

    @Override
    public boolean containsOrBeforeTimelineStarts(String instant) {
        return this.containsInstant(instant) || this.isBeforeTimelineStarts(instant);
    }

    @Override
    public String getTimelineHash() {
        return this.timelineHash;
    }

    @Override
    public Stream<HoodieInstant> getInstantsAsStream() {
        return this.instants.stream();
    }

    @Override
    public List<HoodieInstant> getInstants() {
        return new ArrayList<HoodieInstant>(this.instants);
    }

    @Override
    public Stream<HoodieInstant> getReverseOrderedInstants() {
        return this.getInstantsAsStream().sorted(HoodieInstant.COMPARATOR.reversed());
    }

    @Override
    public Stream<HoodieInstant> getInstantsOrderedByStateTransitionTime() {
        return this.getInstantsAsStream().sorted(HoodieInstant.STATE_TRANSITION_COMPARATOR);
    }

    @Override
    public boolean isBeforeTimelineStarts(String instant) {
        Option<HoodieInstant> firstNonSavepointCommit = this.getFirstNonSavepointCommit();
        return firstNonSavepointCommit.isPresent() && HoodieTimeline.compareTimestamps(instant, LESSER_THAN, ((HoodieInstant)firstNonSavepointCommit.get()).getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<HoodieInstant> getFirstNonSavepointCommit() {
        if (this.firstNonSavepointCommit == null) {
            HoodieDefaultTimeline hoodieDefaultTimeline = this;
            synchronized (hoodieDefaultTimeline) {
                if (this.firstNonSavepointCommit == null) {
                    this.firstNonSavepointCommit = HoodieDefaultTimeline.findFirstNonSavepointCommit(this.instants);
                }
            }
        }
        return this.firstNonSavepointCommit;
    }

    @Override
    public Option<HoodieInstant> getLastClusteringInstant() {
        return Option.fromJavaOptional(this.getCommitsTimeline().filter(s -> s.getAction().equalsIgnoreCase("replacecommit")).getReverseOrderedInstants().filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i)).findFirst());
    }

    @Override
    public Option<HoodieInstant> getFirstPendingClusterInstant() {
        return this.getLastOrFirstPendingClusterInstant(false);
    }

    @Override
    public Option<HoodieInstant> getLastPendingClusterInstant() {
        return this.getLastOrFirstPendingClusterInstant(true);
    }

    private Option<HoodieInstant> getLastOrFirstPendingClusterInstant(boolean isLast) {
        HoodieTimeline replaceTimeline = this.filterPendingReplaceTimeline();
        Stream<HoodieInstant> replaceStream = isLast ? replaceTimeline.getReverseOrderedInstants() : replaceTimeline.getInstantsAsStream();
        return Option.fromJavaOptional(replaceStream.filter((? super T i) -> ClusteringUtils.isClusteringInstant(this, i)).findFirst());
    }

    @Override
    public boolean isPendingClusterInstant(String instantTime) {
        return this.getOrCreatePendingClusteringInstantSet().contains(instantTime);
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return this.details.apply(instant);
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return ((byte[])this.getInstantDetails(instant).get()).length == 0;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getInstantsAsStream().map(Object::toString).collect(Collectors.joining(","));
    }

    public HoodieDefaultTimeline mergeTimeline(HoodieDefaultTimeline timeline) {
        Stream<HoodieInstant> instantStream = Stream.concat(this.getInstantsAsStream(), timeline.getInstantsAsStream()).sorted();
        Function<HoodieInstant, Option<byte[]>> details = instant -> {
            if (this.getInstantsAsStream().anyMatch(i -> i.equals(instant))) {
                return this.getInstantDetails((HoodieInstant)instant);
            }
            return timeline.getInstantDetails((HoodieInstant)instant);
        };
        return new HoodieDefaultTimeline(instantStream, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOrCreateInstantSet() {
        if (this.instantTimeSet == null) {
            HoodieDefaultTimeline hoodieDefaultTimeline = this;
            synchronized (hoodieDefaultTimeline) {
                if (this.instantTimeSet == null) {
                    this.instantTimeSet = this.instants.stream().map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
                }
            }
        }
        return this.instantTimeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOrCreatePendingClusteringInstantSet() {
        if (this.pendingReplaceClusteringInstants == null) {
            HoodieDefaultTimeline hoodieDefaultTimeline = this;
            synchronized (hoodieDefaultTimeline) {
                if (this.pendingReplaceClusteringInstants == null) {
                    List<HoodieInstant> pendingReplaceInstants = this.getCommitsTimeline().filterPendingReplaceTimeline().getInstants();
                    pendingReplaceInstants.stream().collect(Collectors.groupingBy(HoodieInstant::getTimestamp)).forEach((timestamp, instants) -> {
                        if (instants.size() > 1) {
                            throw new IllegalStateException("Multiple instants with same timestamp: " + timestamp + " instants: " + instants);
                        }
                    });
                    this.pendingReplaceClusteringInstants = pendingReplaceInstants.stream().filter((? super T instant) -> ClusteringUtils.isClusteringInstant(this, instant)).map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
                }
            }
        }
        return this.pendingReplaceClusteringInstants;
    }

    private static Option<HoodieInstant> findFirstNonSavepointCommit(List<HoodieInstant> instants) {
        Set savepointTimestamps = instants.stream().filter((? super T entry) -> entry.getAction().equals("savepoint")).map(HoodieInstant::getTimestamp).collect(Collectors.toSet());
        if (!savepointTimestamps.isEmpty()) {
            return Option.fromJavaOptional(instants.stream().filter((? super T entry) -> !savepointTimestamps.contains(entry.getTimestamp())).findFirst());
        }
        return Option.fromJavaOptional(instants.stream().findFirst());
    }
}

