/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.timeline.dto.BaseFileDTO;
import org.apache.hudi.common.table.timeline.dto.LogFileDTO;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileSliceDTO {
    @JsonProperty(value="baseFile")
    BaseFileDTO baseFile;
    @JsonProperty(value="logFiles")
    List<LogFileDTO> logFiles;
    @JsonProperty(value="partition")
    private String partitionPath;
    @JsonProperty(value="fileId")
    private String fileId;
    @JsonProperty(value="baseInstant")
    private String baseInstantTime;

    public static FileSliceDTO fromFileSlice(FileSlice slice) {
        FileSliceDTO dto = new FileSliceDTO();
        dto.partitionPath = slice.getPartitionPath();
        dto.baseInstantTime = slice.getBaseInstantTime();
        dto.fileId = slice.getFileId();
        dto.baseFile = (BaseFileDTO)slice.getBaseFile().map(BaseFileDTO::fromHoodieBaseFile).orElse(null);
        dto.logFiles = slice.getLogFiles().map(LogFileDTO::fromHoodieLogFile).collect(Collectors.toList());
        return dto;
    }

    public static FileSlice toFileSlice(FileSliceDTO dto) {
        FileSlice slice = new FileSlice(dto.partitionPath, dto.baseInstantTime, dto.fileId);
        slice.setBaseFile(BaseFileDTO.toHoodieBaseFile(dto.baseFile));
        dto.logFiles.stream().forEach(lf -> slice.addLogFile(LogFileDTO.toHoodieLogFile(lf)));
        return slice;
    }
}

