/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.conflict.detection;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.conflict.detection.EarlyConflictDetectionStrategy;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public abstract class DirectMarkerBasedDetectionStrategy
implements EarlyConflictDetectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMarkerBasedDetectionStrategy.class);
    protected final HoodieStorage storage;
    protected final String partitionPath;
    protected final String fileId;
    protected final String instantTime;
    protected final HoodieActiveTimeline activeTimeline;
    protected final HoodieConfig config;

    public DirectMarkerBasedDetectionStrategy(HoodieStorage storage, String partitionPath, String fileId, String instantTime, HoodieActiveTimeline activeTimeline, HoodieConfig config) {
        this.storage = storage;
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.instantTime = instantTime;
        this.activeTimeline = activeTimeline;
        this.config = config;
    }

    public boolean checkMarkerConflict(String basePath, long maxAllowableHeartbeatIntervalInMs) throws IOException {
        String tempFolderPath = basePath + "/" + ".hoodie/.temp";
        List<String> candidateInstants = MarkerUtils.getCandidateInstants(this.activeTimeline, this.storage.listDirectEntries(new StoragePath(tempFolderPath)).stream().map(StoragePathInfo::getPath).collect(Collectors.toList()), this.instantTime, maxAllowableHeartbeatIntervalInMs, this.storage, basePath);
        long res = candidateInstants.stream().flatMap(currentMarkerDirPath -> {
            try {
                StoragePath markerPartitionPath = StringUtils.isNullOrEmpty((String)this.partitionPath) ? new StoragePath(currentMarkerDirPath) : new StoragePath(currentMarkerDirPath, this.partitionPath);
                if (!StringUtils.isNullOrEmpty((String)this.partitionPath) && !this.storage.exists(markerPartitionPath)) {
                    return Stream.empty();
                }
                return ((Stream)this.storage.listDirectEntries(markerPartitionPath).stream().parallel()).filter(path -> path.toString().contains(this.fileId));
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException occurs during checking marker file conflict");
            }
        }).count();
        if (res != 0L) {
            LOG.warn("Detected conflict marker files: " + this.partitionPath + "/" + this.fileId + " for " + this.instantTime);
            return true;
        }
        return false;
    }
}

