/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class SizeAwareDataInputStream {
    private final DataInputStream dis;
    private final AtomicInteger numberOfBytesRead;

    public SizeAwareDataInputStream(DataInputStream dis) {
        this.dis = dis;
        this.numberOfBytesRead = new AtomicInteger(0);
    }

    public int readInt() throws IOException {
        this.numberOfBytesRead.addAndGet(4);
        return this.dis.readInt();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.numberOfBytesRead.addAndGet(len);
        this.dis.readFully(b, off, len);
    }

    public void readFully(byte[] b) throws IOException {
        this.numberOfBytesRead.addAndGet(b.length);
        this.dis.readFully(b);
    }

    public int skipBytes(int n) throws IOException {
        this.numberOfBytesRead.addAndGet(n);
        return this.dis.skipBytes(n);
    }

    public void close() throws IOException {
        this.dis.close();
    }

    public Integer getNumberOfBytesRead() {
        return this.numberOfBytesRead.get();
    }
}

