/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public interface HoodieRecordMerger
extends Serializable {
    public static final String DEFAULT_MERGE_STRATEGY_UUID = "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    public static final String COMMIT_TIME_BASED_MERGE_STRATEGY_UUID = "ce9acb64-bde0-424c-9b91-f6ebba25356d";
    public static final String PAYLOAD_BASED_MERGE_STRATEGY_UUID = "00000000-0000-0000-0000-000000000000";

    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord var1, Schema var2, HoodieRecord var3, Schema var4, TypedProperties var5) throws IOException;

    default public Option<Pair<HoodieRecord, Schema>> partialMerge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, Schema readerSchema, TypedProperties props) throws IOException {
        throw new UnsupportedOperationException("Partial merging logic is not implemented.");
    }

    default public boolean shouldFlush(HoodieRecord record, Schema schema, TypedProperties props) throws IOException {
        return true;
    }

    default public List<Pair<HoodieRecord, Schema>> fullOuterMerge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        throw new UnsupportedOperationException("Partial merging logic is not implemented.");
    }

    default public boolean isProjectionCompatible() {
        return false;
    }

    default public String[] getMandatoryFieldsForMerging(Schema dataSchema, HoodieTableConfig cfg, TypedProperties properties) {
        ArrayList<Object> requiredFields = new ArrayList<Object>();
        if (cfg.populateMetaFields()) {
            requiredFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        } else {
            Option<String[]> fields = cfg.getRecordKeyFields();
            if (fields.isPresent()) {
                requiredFields.addAll(Arrays.asList((Object[])fields.get()));
            }
        }
        String preCombine = cfg.getPreCombineField();
        if (!StringUtils.isNullOrEmpty((String)preCombine)) {
            requiredFields.add(preCombine);
        }
        return requiredFields.toArray(new String[0]);
    }

    public HoodieRecord.HoodieRecordType getRecordType();

    public String getMergingStrategy();
}

