/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.OrderedProperties;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigClassProperty(name="Hudi Table Basic Configs", groupName=ConfigGroups.Names.TABLE_CONFIG, description="Configurations of the Hudi Table like type of ingestion, storage formats, hive table name etc. Configurations are loaded from hoodie.properties, these properties are usually set during initializing a path as hoodie base path and never changes during the lifetime of a hoodie table.")
@Immutable
public class HoodieTableConfig
extends HoodieConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTableConfig.class);
    public static final String HOODIE_PROPERTIES_FILE = "hoodie.properties";
    public static final String HOODIE_PROPERTIES_FILE_BACKUP = "hoodie.properties.backup";
    public static final String HOODIE_WRITE_TABLE_NAME_KEY = "hoodie.datasource.write.table.name";
    public static final String HOODIE_TABLE_NAME_KEY = "hoodie.table.name";
    public static final ConfigProperty<String> DATABASE_NAME = ConfigProperty.key("hoodie.database.name").noDefaultValue().withDocumentation("Database name. If different databases have the same table name during incremental query, we can set it to limit the table name under a specific database");
    public static final ConfigProperty<String> NAME = ConfigProperty.key("hoodie.table.name").noDefaultValue().withDocumentation("Table name that will be used for registering with Hive. Needs to be same across runs.");
    public static final ConfigProperty<HoodieTableType> TYPE = ConfigProperty.key("hoodie.table.type").defaultValue(HoodieTableType.COPY_ON_WRITE).withDocumentation("The table type for the underlying data.");
    public static final ConfigProperty<HoodieTableVersion> VERSION = ConfigProperty.key("hoodie.table.version").defaultValue(HoodieTableVersion.current()).withDocumentation("Version of table, used for running upgrade/downgrade steps between releases with potentially breaking/backwards compatible changes.");
    public static final ConfigProperty<HoodieTableVersion> INITIAL_VERSION = ConfigProperty.key("hoodie.table.initial.version").defaultValue(HoodieTableVersion.current()).sinceVersion("1.0.0").withDocumentation("Initial Version of table when the table was created. Used for upgrade/downgrade to identify what upgrade/downgrade paths happened on the table. This is only configured when the table is initially setup.");
    public static final ConfigProperty<String> PRECOMBINE_FIELD = ConfigProperty.key("hoodie.table.precombine.field").noDefaultValue().withDocumentation("Field used in preCombining before actual write. By default, when two records have the same key value, the largest value for the precombine field determined by Object.compareTo(..), is picked.");
    public static final ConfigProperty<String> PARTITION_FIELDS = ConfigProperty.key("hoodie.table.partition.fields").noDefaultValue().withDocumentation("Comma separated field names used to partition the table. These field names also include the partition type which is used by custom key generators");
    public static final ConfigProperty<String> RECORDKEY_FIELDS = ConfigProperty.key("hoodie.table.recordkey.fields").noDefaultValue().withDocumentation("Columns used to uniquely identify the table. Concatenated values of these fields are used as  the record key component of HoodieKey.");
    public static final ConfigProperty<Boolean> CDC_ENABLED = ConfigProperty.key("hoodie.table.cdc.enabled").defaultValue(false).sinceVersion("0.13.0").withDocumentation("When enable, persist the change data if necessary, and can be queried as a CDC query mode.");
    public static final ConfigProperty<String> CDC_SUPPLEMENTAL_LOGGING_MODE = ConfigProperty.key("hoodie.table.cdc.supplemental.logging.mode").defaultValue(HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER.name()).withDocumentation(HoodieCDCSupplementalLoggingMode.class).sinceVersion("0.13.0");
    public static final ConfigProperty<String> CREATE_SCHEMA = ConfigProperty.key("hoodie.table.create.schema").noDefaultValue().withDocumentation("Schema used when creating the table");
    public static final ConfigProperty<HoodieFileFormat> BASE_FILE_FORMAT = ConfigProperty.key("hoodie.table.base.file.format").defaultValue(HoodieFileFormat.PARQUET).withAlternatives("hoodie.table.ro.file.format").withDocumentation("Base file format to store all the base file data.");
    public static final ConfigProperty<HoodieFileFormat> LOG_FILE_FORMAT = ConfigProperty.key("hoodie.table.log.file.format").defaultValue(HoodieFileFormat.HOODIE_LOG).withAlternatives("hoodie.table.rt.file.format").withDocumentation("Log format used for the delta logs.");
    public static final ConfigProperty<String> TIMELINE_LAYOUT_VERSION = ConfigProperty.key("hoodie.timeline.layout.version").noDefaultValue().withDocumentation("Version of timeline used, by the table.");
    public static final ConfigProperty<RecordMergeMode> RECORD_MERGE_MODE = ConfigProperty.key("hoodie.record.merge.mode").defaultValue(RecordMergeMode.EVENT_TIME_ORDERING).sinceVersion("1.0.0").withDocumentation(RecordMergeMode.class);
    public static final ConfigProperty<String> PAYLOAD_CLASS_NAME = ConfigProperty.key("hoodie.compaction.payload.class").noDefaultValue().deprecatedAfter("1.0.0").withDocumentation("Payload class to use for performing merges, compactions, i.e merge delta logs with current base file and then  produce a new base file.");
    public static final String DEFAULT_PAYLOAD_CLASS_NAME = DefaultHoodieRecordPayload.class.getName();
    public static final ConfigProperty<String> RECORD_MERGE_STRATEGY_ID = ConfigProperty.key("hoodie.record.merge.strategy.id").noDefaultValue().withAlternatives("hoodie.compaction.record.merger.strategy").sinceVersion("0.13.0").withDocumentation("Id of merger strategy. Hudi will pick HoodieRecordMerger implementations in `hoodie.write.record.merge.custom.implementation.classes` which has the same merger strategy id");
    public static final ConfigProperty<String> ARCHIVELOG_FOLDER = ConfigProperty.key("hoodie.archivelog.folder").defaultValue("archived").deprecatedAfter("1.0.0").withDocumentation("path under the meta folder, to store archived timeline instants at.");
    public static final ConfigProperty<String> TIMELINE_HISTORY_PATH = ConfigProperty.key("hoodie.timeline.history.path").defaultValue("history").withDocumentation("path under the meta folder, to store timeline history at.");
    public static final ConfigProperty<String> TIMELINE_PATH = ConfigProperty.key("hoodie.timeline.path").defaultValue("timeline").withDocumentation("path under the meta folder, to store timeline instants at.");
    public static final ConfigProperty<Boolean> BOOTSTRAP_INDEX_ENABLE = ConfigProperty.key("hoodie.bootstrap.index.enable").defaultValue(true).withDocumentation("Whether or not, this is a bootstrapped table, with bootstrap base data and an mapping index defined, default true.");
    public static final ConfigProperty<String> BOOTSTRAP_INDEX_CLASS_NAME = ConfigProperty.key("hoodie.bootstrap.index.class").defaultValue(HFileBootstrapIndex.class.getName()).deprecatedAfter("1.0.0").withDocumentation("Implementation to use, for mapping base files to bootstrap base file, that contain actual data.");
    public static final ConfigProperty<String> BOOTSTRAP_INDEX_TYPE = ConfigProperty.key("hoodie.bootstrap.index.type").defaultValue(BootstrapIndexType.HFILE.name()).sinceVersion("1.0.0").withDocumentation("Bootstrap index type determines which implementation to use, for mapping base files to bootstrap base file, that contain actual data.");
    public static final ConfigProperty<String> BOOTSTRAP_BASE_PATH = ConfigProperty.key("hoodie.bootstrap.base.path").noDefaultValue().withDocumentation("Base path of the dataset that needs to be bootstrapped as a Hudi table");
    public static final ConfigProperty<Boolean> POPULATE_META_FIELDS = ConfigProperty.key("hoodie.populate.meta.fields").defaultValue(true).withDocumentation("When enabled, populates all meta fields. When disabled, no meta fields are populated and incremental queries will not be functional. This is only meant to be used for append only/immutable data for batch processing");
    public static final ConfigProperty<String> KEY_GENERATOR_CLASS_NAME = ConfigProperty.key("hoodie.table.keygenerator.class").noDefaultValue().deprecatedAfter("1.0.0").withDocumentation("Key Generator class property for the hoodie table");
    public static final ConfigProperty<String> KEY_GENERATOR_TYPE = ConfigProperty.key("hoodie.table.keygenerator.type").noDefaultValue().sinceVersion("1.0.0").withDocumentation("Key Generator type to determine key generator class");
    public static final ConfigProperty<HoodieTimelineTimeZone> TIMELINE_TIMEZONE = ConfigProperty.key("hoodie.table.timeline.timezone").defaultValue(HoodieTimelineTimeZone.LOCAL).withDocumentation("User can set hoodie commit timeline timezone, such as utc, local and so on. local is default");
    public static final ConfigProperty<Boolean> PARTITION_METAFILE_USE_BASE_FORMAT = ConfigProperty.key("hoodie.partition.metafile.use.base.format").defaultValue(false).withDocumentation("If true, partition metafiles are saved in the same format as base-files for this dataset (e.g. Parquet / ORC). If false (default) partition metafiles are saved as properties files.");
    public static final ConfigProperty<Boolean> DROP_PARTITION_COLUMNS = ConfigProperty.key("hoodie.datasource.write.drop.partition.columns").defaultValue(false).markAdvanced().withDocumentation("When set to true, will not write the partition columns into hudi. By default, false.");
    public static final ConfigProperty<Boolean> MULTIPLE_BASE_FILE_FORMATS_ENABLE = ConfigProperty.key("hoodie.table.multiple.base.file.formats.enable").defaultValue(false).sinceVersion("1.0.0").withDocumentation("When set to true, the table can support reading and writing multiple base file formats.");
    public static final ConfigProperty<String> URL_ENCODE_PARTITIONING = KeyGeneratorOptions.URL_ENCODE_PARTITIONING;
    public static final ConfigProperty<String> HIVE_STYLE_PARTITIONING_ENABLE = KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE;
    public static final List<ConfigProperty<String>> PERSISTED_CONFIG_LIST = Arrays.asList(TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD, TimestampKeyGeneratorConfig.INPUT_TIME_UNIT, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_TIMEZONE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_TIMEZONE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT, TimestampKeyGeneratorConfig.DATE_TIME_PARSER);
    public static final ConfigProperty<String> TABLE_CHECKSUM = ConfigProperty.key("hoodie.table.checksum").noDefaultValue().sinceVersion("0.11.0").withDocumentation("Table checksum is used to guard against partial writes in HDFS. It is added as the last entry in hoodie.properties and then used to validate while reading table config.");
    public static final ConfigProperty<String> TABLE_METADATA_PARTITIONS_INFLIGHT = ConfigProperty.key("hoodie.table.metadata.partitions.inflight").noDefaultValue().sinceVersion("0.11.0").withDocumentation("Comma-separated list of metadata partitions whose building is in progress. These partitions are not yet ready for use by the readers.");
    public static final ConfigProperty<String> TABLE_METADATA_PARTITIONS = ConfigProperty.key("hoodie.table.metadata.partitions").noDefaultValue().sinceVersion("0.11.0").withDocumentation("Comma-separated list of metadata partitions that have been completely built and in-sync with data table. These partitions are ready for use by the readers");
    public static final ConfigProperty<String> SECONDARY_INDEXES_METADATA = ConfigProperty.key("hoodie.table.secondary.indexes.metadata").noDefaultValue().sinceVersion("0.13.0").withDocumentation("The metadata of secondary indexes");
    public static final ConfigProperty<String> RELATIVE_INDEX_DEFINITION_PATH = ConfigProperty.key("hoodie.table.index.defs.path").noDefaultValue().sinceVersion("1.0.0").withDocumentation("Relative path to table base path where the index definitions are stored");
    private static final String TABLE_CHECKSUM_FORMAT = "%s.%s";
    @Deprecated
    public static final String HOODIE_RO_FILE_FORMAT_PROP_NAME = "hoodie.table.ro.file.format";
    @Deprecated
    public static final String HOODIE_RT_FILE_FORMAT_PROP_NAME = "hoodie.table.rt.file.format";
    @Deprecated
    public static final String HOODIE_TABLE_NAME_PROP_NAME = NAME.key();
    @Deprecated
    public static final String HOODIE_TABLE_TYPE_PROP_NAME = TYPE.key();
    @Deprecated
    public static final String HOODIE_TABLE_VERSION_PROP_NAME = VERSION.key();
    @Deprecated
    public static final String HOODIE_TABLE_PRECOMBINE_FIELD = PRECOMBINE_FIELD.key();
    @Deprecated
    public static final String HOODIE_BASE_FILE_FORMAT_PROP_NAME = BASE_FILE_FORMAT.key();
    @Deprecated
    public static final String HOODIE_LOG_FILE_FORMAT_PROP_NAME = LOG_FILE_FORMAT.key();
    @Deprecated
    public static final String HOODIE_TIMELINE_LAYOUT_VERSION = TIMELINE_LAYOUT_VERSION.key();
    @Deprecated
    public static final String HOODIE_PAYLOAD_CLASS_PROP_NAME = PAYLOAD_CLASS_NAME.key();
    @Deprecated
    public static final String HOODIE_ARCHIVELOG_FOLDER_PROP_NAME = TIMELINE_HISTORY_PATH.key();
    @Deprecated
    public static final String HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME = BOOTSTRAP_INDEX_CLASS_NAME.key();
    @Deprecated
    public static final String HOODIE_BOOTSTRAP_BASE_PATH = BOOTSTRAP_BASE_PATH.key();
    @Deprecated
    public static final HoodieTableType DEFAULT_TABLE_TYPE = TYPE.defaultValue();
    @Deprecated
    public static final HoodieTableVersion DEFAULT_TABLE_VERSION = VERSION.defaultValue();
    @Deprecated
    public static final HoodieFileFormat DEFAULT_BASE_FILE_FORMAT = BASE_FILE_FORMAT.defaultValue();
    @Deprecated
    public static final HoodieFileFormat DEFAULT_LOG_FILE_FORMAT = LOG_FILE_FORMAT.defaultValue();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_INDEX_CLASS = BOOTSTRAP_INDEX_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String DEFAULT_ARCHIVELOG_FOLDER = TIMELINE_HISTORY_PATH.defaultValue();

    static List<ConfigProperty<?>> definedTableConfigs() {
        Field[] fields = ReflectionUtils.getClass((String)HoodieTableConfig.class.getName()).getDeclaredFields();
        return Arrays.stream(fields).filter(f -> f.getType().equals(ConfigProperty.class) && Modifier.isPublic(f.getModifiers()) && Modifier.isStatic(f.getModifiers())).map(f -> {
            try {
                return (ConfigProperty)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new HoodieException("Error reading defined table configs, for " + f.getName(), (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    public static HoodieTableConfig loadFromHoodieProps(HoodieStorage storage, String basePath) {
        StoragePath metaPath = new StoragePath(basePath, ".hoodie");
        return new HoodieTableConfig(storage, metaPath);
    }

    public static HoodieTableConfig loadFromHoodieProps(HoodieStorage storage, StoragePath metaPath) {
        return new HoodieTableConfig(storage, metaPath);
    }

    private HoodieTableConfig(HoodieStorage storage, StoragePath metaPath) {
        this(storage, metaPath, null, null, null, false);
    }

    public HoodieTableConfig(HoodieStorage storage, StoragePath metaPath, RecordMergeMode recordMergeMode, String payloadClassName, String recordMergeStrategyId) {
        this(storage, metaPath, recordMergeMode, payloadClassName, recordMergeStrategyId, true);
    }

    public HoodieTableConfig(HoodieStorage storage, StoragePath metaPath, RecordMergeMode recordMergeMode, String payloadClassName, String recordMergeStrategyId, boolean autoUpdate) {
        StoragePath propertyPath = new StoragePath(metaPath, HOODIE_PROPERTIES_FILE);
        LOG.info("Loading table properties from " + propertyPath);
        try {
            this.props = ConfigUtils.fetchConfigs(storage, metaPath, HOODIE_PROPERTIES_FILE, HOODIE_PROPERTIES_FILE_BACKUP, 5, 1000);
            if (autoUpdate) {
                this.autoUpdateHoodieProperties(storage, metaPath, recordMergeMode, payloadClassName, recordMergeStrategyId);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load properties from " + propertyPath, e);
        }
    }

    private void autoUpdateHoodieProperties(HoodieStorage storage, StoragePath metaPath, RecordMergeMode recordMergeMode, String payloadClassName, String recordMergeStrategyId) {
        block17: {
            StoragePath propertyPath = new StoragePath(metaPath, HOODIE_PROPERTIES_FILE);
            try {
                boolean needStore = false;
                if (this.contains(PAYLOAD_CLASS_NAME) && payloadClassName != null && !this.getString(PAYLOAD_CLASS_NAME).equals(payloadClassName)) {
                    this.setValue(PAYLOAD_CLASS_NAME, payloadClassName);
                    needStore = true;
                }
                if (this.contains(RECORD_MERGE_MODE) && recordMergeMode != null && !recordMergeMode.equals((Object)RecordMergeMode.getValue(this.getString(RECORD_MERGE_MODE)))) {
                    this.setValue(RECORD_MERGE_MODE, recordMergeMode.name());
                    needStore = true;
                }
                if (this.contains(RECORD_MERGE_STRATEGY_ID) && recordMergeStrategyId != null && !this.getString(RECORD_MERGE_STRATEGY_ID).equals(recordMergeStrategyId)) {
                    this.setValue(RECORD_MERGE_STRATEGY_ID, recordMergeStrategyId);
                    needStore = true;
                }
                if (!needStore) break block17;
                try (OutputStream outputStream = storage.create(propertyPath);){
                    HoodieTableConfig.storeProperties(this.props, outputStream);
                }
            }
            catch (IOException e) {
                throw new HoodieIOException("Could not store properties in " + propertyPath, e);
            }
        }
    }

    private static Properties getOrderedPropertiesWithTableChecksum(Properties props) {
        OrderedProperties orderedProps = new OrderedProperties(props);
        ((Properties)orderedProps).put(TABLE_CHECKSUM.key(), String.valueOf(HoodieTableConfig.generateChecksum(props)));
        return orderedProps;
    }

    private static String storeProperties(Properties props, OutputStream outputStream) throws IOException {
        String checksum;
        if (HoodieTableConfig.isValidChecksum(props)) {
            checksum = props.getProperty(TABLE_CHECKSUM.key());
            props.store(outputStream, "Updated at " + Instant.now());
        } else {
            Properties propsWithChecksum = HoodieTableConfig.getOrderedPropertiesWithTableChecksum(props);
            propsWithChecksum.store(outputStream, "Properties saved on " + Instant.now());
            checksum = propsWithChecksum.getProperty(TABLE_CHECKSUM.key());
            props.setProperty(TABLE_CHECKSUM.key(), checksum);
        }
        return checksum;
    }

    private static boolean isValidChecksum(Properties props) {
        return props.containsKey(TABLE_CHECKSUM.key()) && HoodieTableConfig.validateChecksum(props);
    }

    public HoodieTableConfig() {
    }

    public static void recover(HoodieStorage storage, StoragePath metadataFolder) throws IOException {
        StoragePath cfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE);
        StoragePath backupCfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE_BACKUP);
        ConfigUtils.recoverIfNeeded(storage, cfgPath, backupCfgPath);
    }

    private static void modify(HoodieStorage storage, StoragePath metadataFolder, Properties modifyProps, BiConsumer<Properties, Properties> modifyFn) {
        StoragePath cfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE);
        StoragePath backupCfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE_BACKUP);
        try {
            String checksum;
            ConfigUtils.recoverIfNeeded(storage, cfgPath, backupCfgPath);
            TypedProperties props = ConfigUtils.fetchConfigs(storage, metadataFolder, HOODIE_PROPERTIES_FILE, HOODIE_PROPERTIES_FILE_BACKUP, 5, 1000);
            try (OutputStream out = storage.create(backupCfgPath, false);){
                HoodieTableConfig.storeProperties(props, out);
            }
            storage.deleteFile(cfgPath);
            try (OutputStream out = storage.create(cfgPath, true);){
                modifyFn.accept(props, modifyProps);
                checksum = HoodieTableConfig.storeProperties(props, out);
            }
            var9_12 = null;
            try (InputStream in = storage.open(cfgPath);){
                props.clear();
                props.load(in);
                if (!props.containsKey(TABLE_CHECKSUM.key()) || !props.getProperty(TABLE_CHECKSUM.key()).equals(checksum)) {
                    storage.deleteFile(cfgPath);
                    throw new HoodieIOException("Checksum property missing or does not match.");
                }
            }
            catch (Throwable throwable) {
                var9_12 = throwable;
                throw throwable;
            }
            storage.deleteFile(backupCfgPath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error updating table configs.", e);
        }
    }

    public static void update(HoodieStorage storage, StoragePath metadataFolder, Properties updatedProps) {
        HoodieTableConfig.modify(storage, metadataFolder, updatedProps, ConfigUtils::upsertProperties);
    }

    public static void delete(HoodieStorage storage, StoragePath metadataFolder, Set<String> deletedProps) {
        Properties props = new Properties();
        deletedProps.forEach(p -> props.setProperty((String)p, ""));
        HoodieTableConfig.modify(storage, metadataFolder, props, ConfigUtils::deleteProperties);
    }

    public static void create(HoodieStorage storage, StoragePath metadataFolder, Properties properties) throws IOException {
        if (!storage.exists(metadataFolder)) {
            storage.createDirectory(metadataFolder);
        }
        HoodieConfig hoodieConfig = new HoodieConfig(properties);
        StoragePath propertyPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE);
        HoodieTableVersion tableVersion = HoodieTableConfig.getTableVersion(hoodieConfig);
        try (OutputStream outputStream = storage.create(propertyPath);){
            if (!hoodieConfig.contains(NAME)) {
                throw new IllegalArgumentException(NAME.key() + " property needs to be specified");
            }
            hoodieConfig.setDefaultValue(TYPE);
            hoodieConfig.setDefaultValue(TIMELINE_HISTORY_PATH);
            hoodieConfig.setDefaultValue(TIMELINE_PATH);
            if (!hoodieConfig.contains(TIMELINE_LAYOUT_VERSION)) {
                hoodieConfig.setValue(TIMELINE_LAYOUT_VERSION, TimelineLayoutVersion.CURR_VERSION.toString());
            }
            if (hoodieConfig.contains(BOOTSTRAP_BASE_PATH)) {
                if (tableVersion.greaterThan(HoodieTableVersion.SEVEN)) {
                    hoodieConfig.setDefaultValue(BOOTSTRAP_INDEX_TYPE, BootstrapIndexType.getBootstrapIndexType(hoodieConfig).toString());
                } else {
                    hoodieConfig.setDefaultValue(BOOTSTRAP_INDEX_CLASS_NAME, BootstrapIndexType.getDefaultBootstrapIndexClassName(hoodieConfig));
                }
            }
            if (hoodieConfig.contains(TIMELINE_TIMEZONE)) {
                HoodieInstantTimeGenerator.setCommitTimeZone(HoodieTimelineTimeZone.valueOf(hoodieConfig.getString(TIMELINE_TIMEZONE)));
            }
            hoodieConfig.setDefaultValue(DROP_PARTITION_COLUMNS);
            HoodieTableConfig.dropInvalidConfigs(hoodieConfig);
            HoodieTableConfig.storeProperties(hoodieConfig.getProps(), outputStream);
        }
    }

    public static long generateChecksum(Properties props) {
        if (!props.containsKey(NAME.key())) {
            throw new IllegalArgumentException(NAME.key() + " property needs to be specified");
        }
        String table = props.getProperty(NAME.key());
        String database = props.getProperty(DATABASE_NAME.key(), "");
        return BinaryUtil.generateChecksum(StringUtils.getUTF8Bytes((String)String.format(TABLE_CHECKSUM_FORMAT, database, table)));
    }

    public static boolean validateChecksum(Properties props) {
        return Long.parseLong(props.getProperty(TABLE_CHECKSUM.key())) == HoodieTableConfig.generateChecksum(props);
    }

    static void dropInvalidConfigs(HoodieConfig config) {
        HoodieTableVersion tableVersion = HoodieTableConfig.getTableVersion(config);
        Map definedTableConfigs = HoodieTableConfig.definedTableConfigs().stream().collect(Collectors.toMap(ConfigProperty::key, Function.identity()));
        List<String> invalidConfigs = config.getProps().keySet().stream().map(k -> (String)k).filter(key -> definedTableConfigs.containsKey(key) && !HoodieTableConfig.validateConfigVersion((ConfigProperty)definedTableConfigs.get(key), tableVersion)).collect(Collectors.toList());
        invalidConfigs.forEach(key -> config.getProps().remove(key));
    }

    static boolean validateConfigVersion(ConfigProperty<?> configProperty, HoodieTableVersion tableVersion) {
        boolean valid;
        if (!configProperty.getSinceVersion().isPresent()) {
            return true;
        }
        HoodieTableVersion firstVersion = HoodieTableVersion.fromReleaseVersion((String)configProperty.getSinceVersion().get());
        boolean bl = valid = tableVersion.greaterThan(firstVersion) || tableVersion.equals((Object)firstVersion);
        if (!valid) {
            LOG.warn("Table version {} is lower than or equal to config's first version {}. Config {} will be ignored.", new Object[]{tableVersion, firstVersion, configProperty.key()});
        }
        return valid;
    }

    public static Option<String> getPartitionFieldPropForKeyGenerator(HoodieConfig config) {
        return Option.ofNullable((Object)config.getString(PARTITION_FIELDS));
    }

    public static Option<List<String>> getPartitionFieldsForKeyGenerator(HoodieConfig config) {
        return Option.ofNullable((Object)config.getString(PARTITION_FIELDS)).map(field -> Arrays.asList(field.split(",")));
    }

    public static Option<String> getPartitionFieldProp(HoodieConfig config) {
        return HoodieTableConfig.getPartitionFields(config).map(fields -> String.join((CharSequence)",", fields));
    }

    public static Option<String[]> getPartitionFields(HoodieConfig config) {
        if (HoodieTableConfig.contains(PARTITION_FIELDS, config)) {
            return Option.of((Object)Arrays.stream(config.getString(PARTITION_FIELDS).split(",")).filter(p -> !p.isEmpty()).map(p -> HoodieTableConfig.getPartitionFieldWithoutKeyGenPartitionType(p, config)).collect(Collectors.toList()).toArray(new String[0]));
        }
        return Option.empty();
    }

    public static String getPartitionFieldWithoutKeyGenPartitionType(String partitionField, HoodieConfig config) {
        return partitionField.split(":")[0];
    }

    public static HoodieTableVersion getTableVersion(HoodieConfig config) {
        return HoodieTableConfig.contains(VERSION, config) ? HoodieTableVersion.fromVersionCode(config.getInt(VERSION)) : VERSION.defaultValue();
    }

    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf(this.getStringOrDefault(TYPE));
    }

    public Option<TimelineLayoutVersion> getTimelineLayoutVersion() {
        return this.contains(TIMELINE_LAYOUT_VERSION) ? Option.of((Object)new TimelineLayoutVersion(this.getInt(TIMELINE_LAYOUT_VERSION))) : Option.empty();
    }

    public HoodieTableVersion getTableVersion() {
        return HoodieTableConfig.getTableVersion(this);
    }

    public HoodieTableVersion getTableInitialVersion() {
        return this.contains(INITIAL_VERSION) ? HoodieTableVersion.fromVersionCode(this.getInt(INITIAL_VERSION)) : INITIAL_VERSION.defaultValue();
    }

    public void setTableVersion(HoodieTableVersion tableVersion) {
        this.setValue(VERSION, Integer.toString(tableVersion.versionCode()));
        this.setValue(TIMELINE_LAYOUT_VERSION, Integer.toString(tableVersion.getTimelineLayoutVersion().getVersion()));
    }

    public void setInitialVersion(HoodieTableVersion initialVersion) {
        this.setValue(INITIAL_VERSION, Integer.toString(initialVersion.versionCode()));
    }

    public RecordMergeMode getRecordMergeMode() {
        return RecordMergeMode.getValue(this.getStringOrDefault(RECORD_MERGE_MODE));
    }

    public String getPayloadClass() {
        return HoodieRecordPayload.getPayloadClassName(this);
    }

    public String getRecordMergeStrategyId() {
        return this.getString(RECORD_MERGE_STRATEGY_ID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Triple<RecordMergeMode, String, String> inferCorrectMergingBehavior(RecordMergeMode recordMergeMode, String payloadClassName, String recordMergeStrategyId) {
        String inferredPayloadClassName;
        String inferredRecordMergeStrategyId;
        RecordMergeMode inferredRecordMergeMode;
        if (StringUtils.isNullOrEmpty((String)payloadClassName)) {
            if (StringUtils.isNullOrEmpty((String)recordMergeStrategyId)) {
                ValidationUtils.checkArgument((recordMergeMode != RecordMergeMode.CUSTOM ? 1 : 0) != 0, (String)"Custom merge mode should only be used if you set a payload class or merge strategy ID");
                inferredRecordMergeMode = recordMergeMode == null ? RECORD_MERGE_MODE.defaultValue() : recordMergeMode;
                if (inferredRecordMergeMode == RecordMergeMode.COMMIT_TIME_ORDERING) {
                    inferredRecordMergeStrategyId = "ce9acb64-bde0-424c-9b91-f6ebba25356d";
                } else {
                    if (inferredRecordMergeMode != RecordMergeMode.EVENT_TIME_ORDERING) throw new IllegalStateException("Merge Mode: '" + (Object)((Object)inferredRecordMergeMode) + "' has not been fully implemented.");
                    inferredRecordMergeStrategyId = "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
                }
            } else {
                inferredRecordMergeStrategyId = recordMergeStrategyId;
                if (recordMergeStrategyId.equals("eeb8d96f-b1e4-49fd-bbf8-28ac514178e5")) {
                    ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.EVENT_TIME_ORDERING ? 1 : 0) != 0, (String)"Default merge strategy ID can only be used with the merge mode of EVENT_TIME_ORDERING");
                    inferredRecordMergeMode = RecordMergeMode.EVENT_TIME_ORDERING;
                } else if (recordMergeStrategyId.equals("ce9acb64-bde0-424c-9b91-f6ebba25356d")) {
                    ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.COMMIT_TIME_ORDERING ? 1 : 0) != 0, (String)"Commit time ordering merger strategy ID can only be used with the merge mode of COMMIT_TIME_ORDERING");
                    inferredRecordMergeMode = RecordMergeMode.COMMIT_TIME_ORDERING;
                } else {
                    ValidationUtils.checkArgument((!recordMergeStrategyId.equals("00000000-0000-0000-0000-000000000000") ? 1 : 0) != 0, (String)"Payload based strategy should only be used if you have a custom payload class set");
                    ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.CUSTOM ? 1 : 0) != 0, (String)"Record merge mode must be set to custom when using a custom merge strategy ID");
                    inferredRecordMergeMode = RecordMergeMode.CUSTOM;
                }
            }
            inferredPayloadClassName = HoodieRecordPayload.getAvroPayloadForMergeMode(inferredRecordMergeMode);
            return Triple.of(inferredRecordMergeMode, inferredPayloadClassName, inferredRecordMergeStrategyId);
        } else {
            inferredPayloadClassName = payloadClassName;
            if (payloadClassName.equals(DefaultHoodieRecordPayload.class.getName())) {
                if (StringUtils.isNullOrEmpty((String)recordMergeStrategyId) || recordMergeStrategyId.equals("eeb8d96f-b1e4-49fd-bbf8-28ac514178e5")) {
                    ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.EVENT_TIME_ORDERING ? 1 : 0) != 0, (String)"Only the record merge mode of EVENT_TIME_ORDERING can be used with default payload");
                    inferredRecordMergeMode = RecordMergeMode.EVENT_TIME_ORDERING;
                    inferredRecordMergeStrategyId = "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
                    return Triple.of(inferredRecordMergeMode, inferredPayloadClassName, inferredRecordMergeStrategyId);
                } else {
                    ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.CUSTOM ? 1 : 0) != 0, (String)"Record merge mode, payload class, and merge strategy are in an illegal configuration");
                    ValidationUtils.checkArgument((!recordMergeStrategyId.equals("ce9acb64-bde0-424c-9b91-f6ebba25356d") && !recordMergeStrategyId.equals("00000000-0000-0000-0000-000000000000") ? 1 : 0) != 0, (String)"Record merger strategy is incompatible with payload class");
                    inferredRecordMergeMode = RecordMergeMode.CUSTOM;
                    inferredRecordMergeStrategyId = recordMergeStrategyId;
                }
                return Triple.of(inferredRecordMergeMode, inferredPayloadClassName, inferredRecordMergeStrategyId);
            } else if (payloadClassName.equals(OverwriteWithLatestAvroPayload.class.getName())) {
                ValidationUtils.checkArgument((StringUtils.isNullOrEmpty((String)recordMergeStrategyId) || recordMergeStrategyId.equals("ce9acb64-bde0-424c-9b91-f6ebba25356d") ? 1 : 0) != 0, (String)"Record merge strategy cannot be set if a merge payload is used");
                ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.COMMIT_TIME_ORDERING ? 1 : 0) != 0, (String)"Only commit time ordering merge mode can be used with overwrite payload");
                inferredRecordMergeMode = RecordMergeMode.COMMIT_TIME_ORDERING;
                inferredRecordMergeStrategyId = "ce9acb64-bde0-424c-9b91-f6ebba25356d";
                return Triple.of(inferredRecordMergeMode, inferredPayloadClassName, inferredRecordMergeStrategyId);
            } else {
                ValidationUtils.checkArgument((StringUtils.isNullOrEmpty((String)recordMergeStrategyId) || recordMergeStrategyId.equals("00000000-0000-0000-0000-000000000000") ? 1 : 0) != 0, (String)"Record merge strategy cannot be set if a merge payload is used");
                ValidationUtils.checkArgument((recordMergeMode == null || recordMergeMode == RecordMergeMode.CUSTOM ? 1 : 0) != 0, (String)"Record merge mode must be custom if payload is defined");
                inferredRecordMergeMode = RecordMergeMode.CUSTOM;
                inferredRecordMergeStrategyId = "00000000-0000-0000-0000-000000000000";
            }
        }
        return Triple.of(inferredRecordMergeMode, inferredPayloadClassName, inferredRecordMergeStrategyId);
    }

    public String getPreCombineField() {
        return this.getString(PRECOMBINE_FIELD);
    }

    public Option<String[]> getRecordKeyFields() {
        String keyFieldsValue = this.getStringOrDefault(RECORDKEY_FIELDS, null);
        if (keyFieldsValue == null) {
            return Option.empty();
        }
        return Option.of((Object)Arrays.stream(keyFieldsValue.split(",")).filter(p -> p.length() > 0).collect(Collectors.toList()).toArray(new String[0]));
    }

    public Option<String[]> getPartitionFields() {
        return HoodieTableConfig.getPartitionFields(this);
    }

    public boolean isTablePartitioned() {
        return (Boolean)this.getPartitionFields().map(pfs -> ((String[])pfs).length > 0).orElse((Object)false);
    }

    public Option<String> getSecondaryIndexesMetadata() {
        if (this.contains(SECONDARY_INDEXES_METADATA)) {
            return Option.of((Object)this.getString(SECONDARY_INDEXES_METADATA));
        }
        return Option.empty();
    }

    @Deprecated
    public String getPartitionFieldProp() {
        return (String)HoodieTableConfig.getPartitionFieldProp(this).orElse((Object)"");
    }

    public Option<String> getBootstrapBasePath() {
        return Option.ofNullable((Object)this.getString(BOOTSTRAP_BASE_PATH));
    }

    public Option<Schema> getTableCreateSchema() {
        if (this.contains(CREATE_SCHEMA)) {
            return Option.of((Object)new Schema.Parser().parse(this.getString(CREATE_SCHEMA)));
        }
        return Option.empty();
    }

    public String getDatabaseName() {
        return this.getString(DATABASE_NAME);
    }

    public String getTableName() {
        return this.getString(NAME);
    }

    public HoodieFileFormat getBaseFileFormat() {
        return HoodieFileFormat.valueOf(this.getStringOrDefault(BASE_FILE_FORMAT));
    }

    public HoodieFileFormat getLogFileFormat() {
        return HoodieFileFormat.valueOf(this.getStringOrDefault(LOG_FILE_FORMAT));
    }

    public String getArchivelogFolder() {
        return this.getStringOrDefault(ARCHIVELOG_FOLDER);
    }

    public String getTimelineHistoryPath() {
        return this.getStringOrDefault(TIMELINE_HISTORY_PATH);
    }

    public String getTimelinePath() {
        return this.getStringOrDefault(TIMELINE_PATH);
    }

    public boolean populateMetaFields() {
        return Boolean.parseBoolean(this.getStringOrDefault(POPULATE_META_FIELDS));
    }

    public String getRecordKeyFieldProp() {
        return this.getStringOrDefault(RECORDKEY_FIELDS, HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    public String getRawRecordKeyFieldProp() {
        return this.getStringOrDefault(RECORDKEY_FIELDS, null);
    }

    public boolean isCDCEnabled() {
        return this.getBooleanOrDefault(CDC_ENABLED);
    }

    public HoodieCDCSupplementalLoggingMode cdcSupplementalLoggingMode() {
        return HoodieCDCSupplementalLoggingMode.valueOf(this.getStringOrDefault(CDC_SUPPLEMENTAL_LOGGING_MODE).toUpperCase());
    }

    public String getKeyGeneratorClassName() {
        return KeyGeneratorType.getKeyGeneratorClassName(this);
    }

    public HoodieTimelineTimeZone getTimelineTimezone() {
        return HoodieTimelineTimeZone.valueOf(this.getStringOrDefault(TIMELINE_TIMEZONE));
    }

    public String getHiveStylePartitioningEnable() {
        return this.getStringOrDefault(HIVE_STYLE_PARTITIONING_ENABLE);
    }

    public String getUrlEncodePartitioning() {
        return this.getStringOrDefault(URL_ENCODE_PARTITIONING);
    }

    public Boolean shouldDropPartitionColumns() {
        return this.getBooleanOrDefault(DROP_PARTITION_COLUMNS);
    }

    public boolean isMultipleBaseFileFormatsEnabled() {
        return this.getBooleanOrDefault(MULTIPLE_BASE_FILE_FORMATS_ENABLE);
    }

    public Set<String> getMetadataPartitionsInflight() {
        return new HashSet<String>(StringUtils.split((String)this.getStringOrDefault(TABLE_METADATA_PARTITIONS_INFLIGHT, ""), (String)","));
    }

    public Set<String> getMetadataPartitions() {
        return new HashSet<String>(StringUtils.split((String)this.getStringOrDefault(TABLE_METADATA_PARTITIONS, ""), (String)","));
    }

    public Option<String> getRelativeIndexDefinitionPath() {
        return Option.ofNullable((Object)this.getString(RELATIVE_INDEX_DEFINITION_PATH));
    }

    public boolean isMetadataTableAvailable() {
        return this.isMetadataPartitionAvailable(MetadataPartitionType.FILES);
    }

    public boolean isMetadataPartitionAvailable(MetadataPartitionType metadataPartitionType) {
        return this.getMetadataPartitions().contains(metadataPartitionType.getPartitionPath());
    }

    public void setMetadataPartitionState(HoodieTableMetaClient metaClient, String partitionPath, boolean enabled) {
        ValidationUtils.checkArgument((!partitionPath.contains(",") ? 1 : 0) != 0, (String)("Metadata Table partition path cannot contain a comma: " + partitionPath));
        Set<String> partitions = this.getMetadataPartitions();
        Set<String> partitionsInflight = this.getMetadataPartitionsInflight();
        if (enabled) {
            partitions.add(partitionPath);
            partitionsInflight.remove(partitionPath);
        } else if (partitionPath.equals(MetadataPartitionType.FILES.getPartitionPath())) {
            partitions.clear();
            partitionsInflight.clear();
        } else {
            partitions.remove(partitionPath);
            partitionsInflight.remove(partitionPath);
        }
        this.setValue(TABLE_METADATA_PARTITIONS, partitions.stream().sorted().collect(Collectors.joining(",")));
        this.setValue(TABLE_METADATA_PARTITIONS_INFLIGHT, partitionsInflight.stream().sorted().collect(Collectors.joining(",")));
        HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), this.getProps());
        LOG.info(String.format("MDT %s partition %s has been %s", metaClient.getBasePath(), partitionPath, enabled ? "enabled" : "disabled"));
    }

    public void setMetadataPartitionsInflight(HoodieTableMetaClient metaClient, List<String> partitionPaths) {
        Set<String> partitionsInflight = this.getMetadataPartitionsInflight();
        partitionPaths.forEach(partitionPath -> {
            ValidationUtils.checkArgument((!partitionPath.contains(",") ? 1 : 0) != 0, (String)("Metadata Table partition path cannot contain a comma: " + partitionPath));
            partitionsInflight.add((String)partitionPath);
        });
        this.setValue(TABLE_METADATA_PARTITIONS_INFLIGHT, partitionsInflight.stream().sorted().collect(Collectors.joining(",")));
        HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), this.getProps());
        LOG.info(String.format("MDT %s partitions %s have been set to inflight", metaClient.getBasePath(), partitionPaths));
    }

    public void setMetadataPartitionsInflight(HoodieTableMetaClient metaClient, MetadataPartitionType ... partitionTypes) {
        this.setMetadataPartitionsInflight(metaClient, Arrays.stream(partitionTypes).map(MetadataPartitionType::getPartitionPath).collect(Collectors.toList()));
    }

    public void clearMetadataPartitions(HoodieTableMetaClient metaClient) {
        this.setMetadataPartitionState(metaClient, MetadataPartitionType.FILES.getPartitionPath(), false);
    }

    public Option<HoodieFileFormat> getPartitionMetafileFormat() {
        if (this.getBooleanOrDefault(PARTITION_METAFILE_USE_BASE_FORMAT)) {
            return Option.of((Object)((Object)this.getBaseFileFormat()));
        }
        return Option.empty();
    }

    public Map<String, String> propsMap() {
        return this.props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }
}

