/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.exception.HoodieException;

public enum HoodieTableVersion {
    ZERO(0, CollectionUtils.createImmutableList("0.3.0"), TimelineLayoutVersion.LAYOUT_VERSION_0),
    ONE(1, CollectionUtils.createImmutableList("0.6.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    TWO(2, CollectionUtils.createImmutableList("0.9.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    THREE(3, CollectionUtils.createImmutableList("0.10.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    FOUR(4, CollectionUtils.createImmutableList("0.11.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    FIVE(5, CollectionUtils.createImmutableList("0.12.0", "0.13.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    SIX(6, CollectionUtils.createImmutableList("0.14.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    SEVEN(7, CollectionUtils.createImmutableList("0.16.0"), TimelineLayoutVersion.LAYOUT_VERSION_1),
    EIGHT(8, CollectionUtils.createImmutableList("1.0.0"), TimelineLayoutVersion.LAYOUT_VERSION_2);

    private final int versionCode;
    private final List<String> releaseVersions;
    private final TimelineLayoutVersion timelineLayoutVersion;

    private HoodieTableVersion(int versionCode, List<String> releaseVersions, TimelineLayoutVersion timelineLayoutVersion) {
        this.versionCode = versionCode;
        this.releaseVersions = releaseVersions;
        this.timelineLayoutVersion = timelineLayoutVersion;
    }

    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return this.timelineLayoutVersion;
    }

    public int versionCode() {
        return this.versionCode;
    }

    public static HoodieTableVersion current() {
        return EIGHT;
    }

    public static HoodieTableVersion fromVersionCode(int versionCode) {
        return Arrays.stream(HoodieTableVersion.values()).filter(v -> v.versionCode == versionCode).findAny().orElseThrow(() -> new HoodieException("Unknown table versionCode:" + versionCode));
    }

    public static HoodieTableVersion fromReleaseVersion(String releaseVersion) {
        return Arrays.stream(HoodieTableVersion.values()).filter(v -> v.releaseVersions.contains(releaseVersion)).findAny().orElseThrow(() -> new HoodieException("Unknown table firstReleaseVersion:" + releaseVersion));
    }

    public boolean greaterThanOrEquals(HoodieTableVersion other) {
        return this.greaterThan(other) || this.versionCode == other.versionCode;
    }

    public boolean greaterThan(HoodieTableVersion other) {
        return this.versionCode > other.versionCode;
    }

    public boolean lesserThan(HoodieTableVersion other) {
        return this.versionCode < other.versionCode;
    }
}

