/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormatReader;
import org.apache.hudi.common.table.log.HoodieLogFormatReverseReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieCommandBlock;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieLogRecordReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieLogRecordReader.class);
    protected final Schema readerSchema;
    private final String latestInstantTime;
    protected final HoodieReaderContext<T> readerContext;
    protected final HoodieTableMetaClient hoodieTableMetaClient;
    private final String payloadClassFQN;
    private final String recordKeyField;
    private final Option<String> partitionPathFieldOpt;
    private final Option<String> partitionNameOverrideOpt;
    protected final String preCombineField;
    private final TypedProperties payloadProps;
    protected final List<String> logFilePaths;
    private final boolean reverseReader;
    private final int bufferSize;
    private final Option<InstantRange> instantRange;
    private final boolean withOperationField;
    private final HoodieStorage storage;
    private AtomicLong totalLogFiles = new AtomicLong(0L);
    private final InternalSchema internalSchema;
    private AtomicLong totalLogBlocks = new AtomicLong(0L);
    private AtomicLong totalLogRecords = new AtomicLong(0L);
    private AtomicLong totalRollbacks = new AtomicLong(0L);
    private AtomicLong totalCorruptBlocks = new AtomicLong(0L);
    private Deque<HoodieLogBlock> currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
    protected final boolean forceFullScan;
    private float progress = 0.0f;
    private final boolean populateMetaFields;
    private final List<String> validBlockInstants = new ArrayList<String>();
    private final boolean enableOptimizedLogBlocksScan;
    protected HoodieFileGroupRecordBuffer<T> recordBuffer;

    protected BaseHoodieLogRecordReader(HoodieReaderContext readerContext, HoodieStorage storage, List<String> logFilePaths, boolean reverseReader, int bufferSize, Option<InstantRange> instantRange, boolean withOperationField, boolean forceFullScan, Option<String> partitionNameOverride, Option<String> keyFieldOverride, boolean enableOptimizedLogBlocksScan, HoodieFileGroupRecordBuffer<T> recordBuffer) {
        this.readerContext = readerContext;
        this.readerSchema = readerContext.getSchemaHandler().getRequiredSchema();
        this.latestInstantTime = readerContext.getLatestCommitTime();
        this.hoodieTableMetaClient = HoodieTableMetaClient.builder().setStorage(storage).setBasePath(readerContext.getTablePath()).build();
        HoodieTableConfig tableConfig = this.hoodieTableMetaClient.getTableConfig();
        this.payloadClassFQN = tableConfig.getPayloadClass();
        this.preCombineField = tableConfig.getPreCombineField();
        TypedProperties props = new TypedProperties();
        if (this.preCombineField != null) {
            props.setProperty("hoodie.payload.ordering.field", this.preCombineField);
        }
        this.payloadProps = props;
        this.totalLogFiles.addAndGet(logFilePaths.size());
        this.logFilePaths = logFilePaths;
        this.reverseReader = reverseReader;
        this.storage = storage;
        this.bufferSize = bufferSize;
        this.instantRange = instantRange;
        this.withOperationField = withOperationField;
        this.forceFullScan = forceFullScan;
        this.internalSchema = readerContext.getSchemaHandler().getInternalSchema();
        this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
        if (keyFieldOverride.isPresent()) {
            ValidationUtils.checkState((boolean)partitionNameOverride.isPresent());
            this.populateMetaFields = false;
            this.recordKeyField = (String)keyFieldOverride.get();
            this.partitionPathFieldOpt = Option.empty();
        } else if (tableConfig.populateMetaFields()) {
            this.populateMetaFields = true;
            this.recordKeyField = HoodieRecord.RECORD_KEY_METADATA_FIELD;
            this.partitionPathFieldOpt = Option.of((Object)HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        } else {
            this.populateMetaFields = false;
            this.recordKeyField = tableConfig.getRecordKeyFieldProp();
            this.partitionPathFieldOpt = Option.of((Object)tableConfig.getPartitionFieldProp());
        }
        this.partitionNameOverrideOpt = partitionNameOverride;
        this.recordBuffer = recordBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scanInternal(Option<KeySpec> keySpecOpt, boolean skipProcessingBlocks) {
        BaseHoodieLogRecordReader baseHoodieLogRecordReader = this;
        synchronized (baseHoodieLogRecordReader) {
            if (this.enableOptimizedLogBlocksScan) {
                this.scanInternalV2(keySpecOpt, skipProcessingBlocks);
            } else {
                this.scanInternalV1(keySpecOpt);
            }
        }
    }

    private void scanInternalV1(Option<KeySpec> keySpecOpt) {
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
        List<HoodieLogBlock> validLogBlockInstants = new ArrayList<HoodieLogBlock>();
        HashMap<String, Map<Long, List<Pair<Integer, HoodieLogBlock>>>> blockSequenceMapPerCommit = new HashMap<String, Map<Long, List<Pair<Integer, HoodieLogBlock>>>>();
        this.progress = 0.0f;
        this.totalLogFiles = new AtomicLong(0L);
        this.totalRollbacks = new AtomicLong(0L);
        this.totalCorruptBlocks = new AtomicLong(0L);
        this.totalLogBlocks = new AtomicLong(0L);
        this.totalLogRecords = new AtomicLong(0L);
        HoodieLogFormatReverseReader logFormatReaderWrapper = null;
        HoodieTimeline commitsTimeline = this.hoodieTableMetaClient.getCommitsTimeline();
        HoodieTimeline completedInstantsTimeline = commitsTimeline.filterCompletedInstants();
        HoodieTimeline inflightInstantsTimeline = commitsTimeline.filterInflights();
        try {
            logFormatReaderWrapper = new HoodieLogFormatReverseReader(this.storage, this.logFilePaths.stream().map(logFile -> new HoodieLogFile(new StoragePath(logFile))).collect(Collectors.toList()), this.readerSchema, this.reverseReader, this.bufferSize, this.shouldLookupRecords(), this.recordKeyField, this.internalSchema);
            HashSet<HoodieLogFile> scannedLogFiles = new HashSet<HoodieLogFile>();
            block19: while (logFormatReaderWrapper.hasNext()) {
                HoodieLogFile logFile2 = logFormatReaderWrapper.getLogFile();
                LOG.info("Scanning log file {}", (Object)logFile2);
                scannedLogFiles.add(logFile2);
                this.totalLogFiles.set(scannedLogFiles.size());
                HoodieLogBlock logBlock = logFormatReaderWrapper.next();
                String instantTime = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                String blockSequenceNumberStr = logBlock.getLogBlockHeader().getOrDefault((Object)HoodieLogBlock.HeaderMetadataType.BLOCK_IDENTIFIER, "");
                int blockSeqNo = -1;
                long attemptNo = -1L;
                if (!StringUtils.isNullOrEmpty((String)blockSequenceNumberStr)) {
                    String[] parts = blockSequenceNumberStr.split(",");
                    attemptNo = Long.parseLong(parts[0]);
                    blockSeqNo = Integer.parseInt(parts[1]);
                }
                this.totalLogBlocks.incrementAndGet();
                if (logBlock.isDataOrDeleteBlock() && (InstantComparison.compareTimestamps(logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME), InstantComparison.GREATER_THAN, this.latestInstantTime) || !completedInstantsTimeline.containsOrBeforeTimelineStarts(instantTime) || inflightInstantsTimeline.containsInstant(instantTime) || this.instantRange.isPresent() && !((InstantRange)this.instantRange.get()).isInRange(instantTime))) continue;
                switch (logBlock.getBlockType()) {
                    case HFILE_DATA_BLOCK: 
                    case AVRO_DATA_BLOCK: 
                    case PARQUET_DATA_BLOCK: {
                        LOG.info("Reading a data block from file {} at instant {}", (Object)logFile2.getPath(), (Object)instantTime);
                        this.currentInstantLogBlocks.push(logBlock);
                        validLogBlockInstants.add(logBlock);
                        this.updateBlockSequenceTracker(logBlock, instantTime, blockSeqNo, attemptNo, blockSequenceMapPerCommit);
                        continue block19;
                    }
                    case DELETE_BLOCK: {
                        LOG.info("Reading a delete block from file {}", (Object)logFile2.getPath());
                        this.currentInstantLogBlocks.push(logBlock);
                        validLogBlockInstants.add(logBlock);
                        this.updateBlockSequenceTracker(logBlock, instantTime, blockSeqNo, attemptNo, blockSequenceMapPerCommit);
                        continue block19;
                    }
                    case COMMAND_BLOCK: {
                        HoodieCommandBlock commandBlock = (HoodieCommandBlock)logBlock;
                        String targetInstantForCommandBlock = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME);
                        LOG.info("Reading a command block {} with targetInstantTime {} from file {}", new Object[]{commandBlock.getType(), targetInstantForCommandBlock, logFile2.getPath()});
                        switch (commandBlock.getType()) {
                            case ROLLBACK_BLOCK: {
                                int instantLogBlockSizeBeforeRollback = this.currentInstantLogBlocks.size();
                                this.currentInstantLogBlocks.removeIf(block -> {
                                    if (block.getBlockType() == HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK) {
                                        LOG.info("Rolling back the last corrupted log block read in {}", (Object)logFile2.getPath());
                                        return true;
                                    }
                                    if (targetInstantForCommandBlock.contentEquals(block.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) {
                                        LOG.info("Rolling back an older log block read from {} with instantTime {}", (Object)logFile2.getPath(), (Object)targetInstantForCommandBlock);
                                        return true;
                                    }
                                    return false;
                                });
                                blockSequenceMapPerCommit.remove(targetInstantForCommandBlock);
                                validLogBlockInstants = validLogBlockInstants.stream().filter(block -> {
                                    if (block.getBlockType() == HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK) {
                                        LOG.info("Rolling back the last corrupted log block read in {}", (Object)logFile2.getPath());
                                        return true;
                                    }
                                    if (targetInstantForCommandBlock.contentEquals(block.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME))) {
                                        LOG.info(String.format("Rolling back an older log block read from %s with instantTime %s", logFile2.getPath(), targetInstantForCommandBlock));
                                        return false;
                                    }
                                    return true;
                                }).collect(Collectors.toList());
                                int numBlocksRolledBack = instantLogBlockSizeBeforeRollback - this.currentInstantLogBlocks.size();
                                this.totalRollbacks.addAndGet(numBlocksRolledBack);
                                LOG.info("Number of applied rollback blocks {}", (Object)numBlocksRolledBack);
                                if (numBlocksRolledBack != 0) continue block19;
                                LOG.warn("TargetInstantTime {} invalid or extra rollback command block in {}", (Object)targetInstantForCommandBlock, (Object)logFile2.getPath());
                                continue block19;
                            }
                        }
                        throw new UnsupportedOperationException("Command type not yet supported.");
                    }
                    case CORRUPT_BLOCK: {
                        LOG.info("Found a corrupt block in {}", (Object)logFile2.getPath());
                        this.totalCorruptBlocks.incrementAndGet();
                        this.currentInstantLogBlocks.push(logBlock);
                        validLogBlockInstants.add(logBlock);
                        continue block19;
                    }
                }
                throw new UnsupportedOperationException("Block type not supported yet");
            }
            if (!this.currentInstantLogBlocks.isEmpty()) {
                Pair<Boolean, List<HoodieLogBlock>> dedupedLogBlocksInfo = this.reconcileSpuriousBlocksAndGetValidOnes(validLogBlockInstants, blockSequenceMapPerCommit);
                if (dedupedLogBlocksInfo.getKey().booleanValue()) {
                    this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
                    dedupedLogBlocksInfo.getValue().forEach(block -> this.currentInstantLogBlocks.push((HoodieLogBlock)block));
                    LOG.info("Merging the final data blocks");
                    this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOpt);
                } else {
                    LOG.info("Merging the final data blocks");
                    this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOpt);
                }
            }
            this.progress = 1.0f;
        }
        catch (IOException e) {
            LOG.error("Got IOException when reading log file", (Throwable)e);
            throw new HoodieIOException("IOException when reading log file ", e);
        }
        catch (Exception e) {
            LOG.error("Got exception when reading log file", (Throwable)e);
            throw new HoodieException("Exception when reading log file ", (Throwable)e);
        }
        finally {
            try {
                if (null != logFormatReaderWrapper) {
                    logFormatReaderWrapper.close();
                }
            }
            catch (IOException ioe) {
                LOG.error("Unable to close log format reader", (Throwable)ioe);
            }
        }
    }

    private Pair<Boolean, List<HoodieLogBlock>> reconcileSpuriousBlocksAndGetValidOnes(List<HoodieLogBlock> allValidLogBlocks, Map<String, Map<Long, List<Pair<Integer, HoodieLogBlock>>>> blockSequenceMapPerCommit) {
        boolean dupsFound = blockSequenceMapPerCommit.values().stream().anyMatch(perCommitBlockList -> perCommitBlockList.size() > 1);
        if (dupsFound) {
            for (Map.Entry<String, Map<Long, List<Pair<Integer, HoodieLogBlock>>>> entry : blockSequenceMapPerCommit.entrySet()) {
                Long attemptNo;
                Map<Long, List<Pair<Integer, HoodieLogBlock>>> perCommitBlockSequences = entry.getValue();
                if (perCommitBlockSequences.size() <= 1) continue;
                int maxSequenceCount = -1;
                int maxAttemptNo = -1;
                int totalSequences = perCommitBlockSequences.size();
                int counter = 0;
                for (Map.Entry<Long, List<Pair<Integer, HoodieLogBlock>>> perAttemptEntries : perCommitBlockSequences.entrySet()) {
                    attemptNo = perAttemptEntries.getKey();
                    int size = perAttemptEntries.getValue().size();
                    if (maxSequenceCount < size) {
                        maxSequenceCount = size;
                        maxAttemptNo = Math.toIntExact(attemptNo);
                    }
                    ++counter;
                }
                for (Map.Entry<Long, List<Pair<Integer, HoodieLogBlock>>> perAttemptEntries : perCommitBlockSequences.entrySet()) {
                    attemptNo = perAttemptEntries.getKey();
                    if ((long)maxAttemptNo == attemptNo) continue;
                    List<HoodieLogBlock> logBlocksToRemove = perCommitBlockSequences.get(attemptNo).stream().map(Pair::getValue).collect(Collectors.toList());
                    logBlocksToRemove.forEach(logBlockToRemove -> allValidLogBlocks.remove(logBlocksToRemove));
                }
            }
            return Pair.of(true, allValidLogBlocks);
        }
        return Pair.of(false, allValidLogBlocks);
    }

    private void updateBlockSequenceTracker(HoodieLogBlock logBlock, String instantTime, int blockSeqNo, long attemptNo, Map<String, Map<Long, List<Pair<Integer, HoodieLogBlock>>>> blockSequenceMapPerCommit) {
        if (blockSeqNo != -1 && attemptNo != -1L) {
            blockSequenceMapPerCommit.computeIfAbsent(instantTime, entry -> new HashMap());
            Map<Long, List<Pair<Integer, HoodieLogBlock>>> curCommitBlockMap = blockSequenceMapPerCommit.get(instantTime);
            if (curCommitBlockMap.containsKey(attemptNo)) {
                curCommitBlockMap.get(attemptNo).add(Pair.of(blockSeqNo, logBlock));
            } else {
                curCommitBlockMap.put(attemptNo, new ArrayList());
                curCommitBlockMap.get(attemptNo).add(Pair.of(blockSeqNo, logBlock));
            }
            blockSequenceMapPerCommit.put(instantTime, curCommitBlockMap);
        } else {
            blockSequenceMapPerCommit.computeIfAbsent(instantTime, entry -> new HashMap());
            Map<Long, List<Pair<Integer, HoodieLogBlock>>> curCommitBlockMap = blockSequenceMapPerCommit.get(instantTime);
            curCommitBlockMap.put(0L, new ArrayList());
            curCommitBlockMap.get(0L).add(Pair.of(blockSeqNo, logBlock));
            blockSequenceMapPerCommit.put(instantTime, curCommitBlockMap);
        }
    }

    private void scanInternalV2(Option<KeySpec> keySpecOption, boolean skipProcessingBlocks) {
        this.currentInstantLogBlocks = new ArrayDeque<HoodieLogBlock>();
        this.progress = 0.0f;
        this.totalLogFiles = new AtomicLong(0L);
        this.totalRollbacks = new AtomicLong(0L);
        this.totalCorruptBlocks = new AtomicLong(0L);
        this.totalLogBlocks = new AtomicLong(0L);
        this.totalLogRecords = new AtomicLong(0L);
        HoodieLogFormatReader logFormatReaderWrapper = null;
        HoodieTimeline commitsTimeline = this.hoodieTableMetaClient.getCommitsTimeline();
        HoodieTimeline completedInstantsTimeline = commitsTimeline.filterCompletedInstants();
        HoodieTimeline inflightInstantsTimeline = commitsTimeline.filterInflights();
        try {
            logFormatReaderWrapper = new HoodieLogFormatReader(this.storage, this.logFilePaths.stream().map(logFile -> new HoodieLogFile(new StoragePath(logFile))).collect(Collectors.toList()), this.readerSchema, this.reverseReader, this.bufferSize, this.shouldLookupRecords(), this.recordKeyField, this.internalSchema);
            HashSet<String> targetRollbackInstants = new HashSet<String>();
            HashMap<String, List> instantToBlocksMap = new HashMap<String, List>();
            ArrayList<String> orderedInstantsList = new ArrayList<String>();
            HashSet<HoodieLogFile> scannedLogFiles = new HashSet<HoodieLogFile>();
            block14: while (logFormatReaderWrapper.hasNext()) {
                HoodieLogFile logFile2 = logFormatReaderWrapper.getLogFile();
                LOG.info("Scanning log file {}", (Object)logFile2);
                scannedLogFiles.add(logFile2);
                this.totalLogFiles.set(scannedLogFiles.size());
                HoodieLogBlock logBlock = logFormatReaderWrapper.next();
                String instantTime = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME);
                this.totalLogBlocks.incrementAndGet();
                if (logBlock.getBlockType().equals((Object)HoodieLogBlock.HoodieLogBlockType.CORRUPT_BLOCK)) {
                    LOG.info("Found a corrupt block in {}", (Object)logFile2.getPath());
                    this.totalCorruptBlocks.incrementAndGet();
                    continue;
                }
                if (logBlock.isDataOrDeleteBlock() && InstantComparison.compareTimestamps(logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME), InstantComparison.GREATER_THAN, this.latestInstantTime) || logBlock.getBlockType() != HoodieLogBlock.HoodieLogBlockType.COMMAND_BLOCK && (!completedInstantsTimeline.containsOrBeforeTimelineStarts(instantTime) || inflightInstantsTimeline.containsInstant(instantTime) || this.instantRange.isPresent() && !((InstantRange)this.instantRange.get()).isInRange(instantTime))) continue;
                switch (logBlock.getBlockType()) {
                    case HFILE_DATA_BLOCK: 
                    case AVRO_DATA_BLOCK: 
                    case PARQUET_DATA_BLOCK: 
                    case DELETE_BLOCK: {
                        List logBlocksList = instantToBlocksMap.getOrDefault(instantTime, new ArrayList());
                        if (logBlocksList.isEmpty()) {
                            orderedInstantsList.add(instantTime);
                        }
                        logBlocksList.add(logBlock);
                        instantToBlocksMap.put(instantTime, logBlocksList);
                        continue block14;
                    }
                    case COMMAND_BLOCK: {
                        LOG.info("Reading a command block from file {}", (Object)logFile2.getPath());
                        HoodieCommandBlock commandBlock = (HoodieCommandBlock)logBlock;
                        if (commandBlock.getType().equals((Object)HoodieCommandBlock.HoodieCommandBlockTypeEnum.ROLLBACK_BLOCK)) {
                            this.totalRollbacks.incrementAndGet();
                            String targetInstantForCommandBlock = logBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.TARGET_INSTANT_TIME);
                            targetRollbackInstants.add(targetInstantForCommandBlock);
                            orderedInstantsList.remove(targetInstantForCommandBlock);
                            instantToBlocksMap.remove(targetInstantForCommandBlock);
                            continue block14;
                        }
                        throw new UnsupportedOperationException("Command type not yet supported.");
                    }
                }
                throw new UnsupportedOperationException("Block type not yet supported.");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ordered instant times seen {}", orderedInstantsList);
            }
            int numBlocksRolledBack = 0;
            HashSet<String> instantTimesIncluded = new HashSet<String>();
            HashMap blockTimeToCompactionBlockTimeMap = new HashMap();
            for (int i = orderedInstantsList.size() - 1; i >= 0; --i) {
                List logBlocks;
                String instantTime = (String)orderedInstantsList.get(i);
                List instantsBlocks = (List)instantToBlocksMap.get(instantTime);
                if (instantsBlocks.isEmpty()) {
                    throw new HoodieException("Data corrupted while writing. Found zero blocks for an instant " + instantTime);
                }
                HoodieLogBlock firstBlock = (HoodieLogBlock)instantsBlocks.get(0);
                if (firstBlock.getLogBlockHeader().containsKey((Object)HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES)) {
                    Arrays.stream(firstBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES).split(",")).forEach(originalInstant -> {
                        String finalInstant = blockTimeToCompactionBlockTimeMap.getOrDefault(instantTime, instantTime);
                        blockTimeToCompactionBlockTimeMap.put(originalInstant, finalInstant);
                    });
                    continue;
                }
                String compactedFinalInstantTime = (String)blockTimeToCompactionBlockTimeMap.get(instantTime);
                if (compactedFinalInstantTime == null) {
                    logBlocks = (List)instantToBlocksMap.get(instantTime);
                    Collections.reverse(logBlocks);
                    logBlocks.forEach(block -> this.currentInstantLogBlocks.addLast((HoodieLogBlock)block));
                    instantTimesIncluded.add(instantTime);
                    this.validBlockInstants.add(instantTime);
                    continue;
                }
                if (instantTimesIncluded.contains(compactedFinalInstantTime)) continue;
                logBlocks = (List)instantToBlocksMap.get(compactedFinalInstantTime);
                Collections.reverse(logBlocks);
                logBlocks.forEach(block -> this.currentInstantLogBlocks.addLast((HoodieLogBlock)block));
                instantTimesIncluded.add(compactedFinalInstantTime);
                this.validBlockInstants.add(compactedFinalInstantTime);
            }
            LOG.info("Number of applied rollback blocks {}", (Object)numBlocksRolledBack);
            if (LOG.isDebugEnabled()) {
                LOG.info("Final view of the Block time to compactionBlockMap {}", blockTimeToCompactionBlockTimeMap);
            }
            if (!this.currentInstantLogBlocks.isEmpty() && !skipProcessingBlocks) {
                LOG.info("Merging the final data blocks");
                this.processQueuedBlocksForInstant(this.currentInstantLogBlocks, scannedLogFiles.size(), keySpecOption);
            }
            this.progress = 1.0f;
        }
        catch (IOException e) {
            LOG.error("Got IOException when reading log file", (Throwable)e);
            throw new HoodieIOException("IOException when reading log file ", e);
        }
        catch (Exception e) {
            LOG.error("Got exception when reading log file", (Throwable)e);
            throw new HoodieException("Exception when reading log file ", (Throwable)e);
        }
        finally {
            try {
                if (null != logFormatReaderWrapper) {
                    logFormatReaderWrapper.close();
                }
            }
            catch (IOException ioe) {
                LOG.error("Unable to close log format reader", (Throwable)ioe);
            }
        }
    }

    private void processQueuedBlocksForInstant(Deque<HoodieLogBlock> logBlocks, int numLogFilesSeen, Option<KeySpec> keySpecOpt) throws Exception {
        while (!logBlocks.isEmpty()) {
            LOG.info("Number of remaining logblocks to merge {}", (Object)logBlocks.size());
            HoodieLogBlock lastBlock = logBlocks.pollLast();
            switch (lastBlock.getBlockType()) {
                case HFILE_DATA_BLOCK: 
                case AVRO_DATA_BLOCK: 
                case PARQUET_DATA_BLOCK: {
                    this.recordBuffer.processDataBlock((HoodieDataBlock)lastBlock, keySpecOpt);
                    break;
                }
                case DELETE_BLOCK: {
                    this.recordBuffer.processDeleteBlock((HoodieDeleteBlock)lastBlock);
                    break;
                }
                case CORRUPT_BLOCK: {
                    LOG.warn("Found a corrupt block which was not rolled back");
                    break;
                }
            }
        }
        this.progress = (float)(numLogFilesSeen - 1) / (float)this.logFilePaths.size();
    }

    private boolean shouldLookupRecords() {
        return !this.forceFullScan;
    }

    public float getProgress() {
        return this.progress;
    }

    public long getTotalLogFiles() {
        return this.totalLogFiles.get();
    }

    public long getTotalLogRecords() {
        return this.totalLogRecords.get();
    }

    public long getTotalLogBlocks() {
        return this.totalLogBlocks.get();
    }

    protected String getPayloadClassFQN() {
        return this.payloadClassFQN;
    }

    public Option<String> getPartitionNameOverride() {
        return this.partitionNameOverrideOpt;
    }

    public long getTotalRollbacks() {
        return this.totalRollbacks.get();
    }

    public long getTotalCorruptBlocks() {
        return this.totalCorruptBlocks.get();
    }

    public boolean isWithOperationField() {
        return this.withOperationField;
    }

    protected TypedProperties getPayloadProps() {
        return this.payloadProps;
    }

    public Deque<HoodieLogBlock> getCurrentInstantLogBlocks() {
        return this.currentInstantLogBlocks;
    }

    public List<String> getValidBlockInstants() {
        return this.validBlockInstants;
    }

    private Pair<ClosableIterator<T>, Schema> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        ClosableIterator<T> blockRecordsIterator;
        if (keySpecOpt.isPresent()) {
            KeySpec keySpec = (KeySpec)keySpecOpt.get();
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext, keySpec.getKeys(), keySpec.isFullKey());
        } else {
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext);
        }
        return Pair.of(blockRecordsIterator, dataBlock.getSchema());
    }

    public static abstract class Builder<T> {
        public abstract Builder withHoodieReaderContext(HoodieReaderContext<T> var1);

        public abstract Builder withStorage(HoodieStorage var1);

        public abstract Builder withLogFiles(List<HoodieLogFile> var1);

        public abstract Builder withReverseReader(boolean var1);

        public abstract Builder withBufferSize(int var1);

        public Builder withPartition(String partitionName) {
            throw new UnsupportedOperationException();
        }

        public Builder withInstantRange(Option<InstantRange> instantRange) {
            throw new UnsupportedOperationException();
        }

        public Builder withOperationField(boolean withOperationField) {
            throw new UnsupportedOperationException();
        }

        public Builder withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            throw new UnsupportedOperationException();
        }

        public abstract BaseHoodieLogRecordReader build();
    }
}

