/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;

public class HoodieCommandBlock
extends HoodieLogBlock {
    private final HoodieCommandBlockTypeEnum type;

    public HoodieCommandBlock(Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this((Option<byte[]>)Option.empty(), null, false, (Option<HoodieLogBlock.HoodieLogBlockContentLocation>)Option.empty(), header, new HashMap<HoodieLogBlock.FooterMetadataType, String>());
    }

    public HoodieCommandBlock(Option<byte[]> content, Supplier<SeekableDataInputStream> inputStreamSupplier, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.FooterMetadataType, String> footer) {
        super(header, footer, blockContentLocation, content, inputStreamSupplier, readBlockLazily);
        this.type = HoodieCommandBlockTypeEnum.values()[Integer.parseInt(header.get((Object)HoodieLogBlock.HeaderMetadataType.COMMAND_BLOCK_TYPE))];
    }

    public HoodieCommandBlockTypeEnum getType() {
        return this.type;
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.COMMAND_BLOCK;
    }

    @Override
    public byte[] getContentBytes(HoodieStorage storage) {
        return new byte[0];
    }

    public static enum HoodieCommandBlockTypeEnum {
        ROLLBACK_BLOCK;

    }
}

