/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.LogReaderUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieLogBlock {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieLogBlock.class);
    public static int version = 3;
    private final Map<HeaderMetadataType, String> logBlockHeader;
    private final Map<FooterMetadataType, String> logBlockFooter;
    private final Option<HoodieLogBlockContentLocation> blockContentLocation;
    private Option<byte[]> content;
    private final Supplier<SeekableDataInputStream> inputStreamSupplier;
    protected boolean readBlockLazily;

    public HoodieLogBlock(@Nonnull Map<HeaderMetadataType, String> logBlockHeader, @Nonnull Map<FooterMetadataType, String> logBlockFooter, @Nonnull Option<HoodieLogBlockContentLocation> blockContentLocation, @Nonnull Option<byte[]> content, @Nullable Supplier<SeekableDataInputStream> inputStreamSupplier, boolean readBlockLazily) {
        this.logBlockHeader = logBlockHeader;
        this.logBlockFooter = logBlockFooter;
        this.blockContentLocation = blockContentLocation;
        this.content = content;
        this.inputStreamSupplier = inputStreamSupplier;
        this.readBlockLazily = readBlockLazily;
    }

    public byte[] getContentBytes(HoodieStorage storage) throws IOException {
        throw new HoodieException("No implementation was provided");
    }

    public byte[] getMagic() {
        throw new HoodieException("No implementation was provided");
    }

    public abstract HoodieLogBlockType getBlockType();

    public boolean isDataOrDeleteBlock() {
        return this.getBlockType().isDataOrDeleteBlock();
    }

    public long getLogBlockLength() {
        throw new HoodieException("No implementation was provided");
    }

    public Option<HoodieLogBlockContentLocation> getBlockContentLocation() {
        return this.blockContentLocation;
    }

    public Map<HeaderMetadataType, String> getLogBlockHeader() {
        return this.logBlockHeader;
    }

    public Map<FooterMetadataType, String> getLogBlockFooter() {
        return this.logBlockFooter;
    }

    public Option<byte[]> getContent() {
        return this.content;
    }

    public boolean isCompactedLogBlock() {
        return this.logBlockHeader.containsKey((Object)HeaderMetadataType.COMPACTED_BLOCK_TIMES);
    }

    public Roaring64NavigableMap getRecordPositions() throws IOException {
        if (!this.logBlockHeader.containsKey((Object)HeaderMetadataType.RECORD_POSITIONS)) {
            return new Roaring64NavigableMap();
        }
        return LogReaderUtils.decodeRecordPositionsHeader(this.logBlockHeader.get((Object)HeaderMetadataType.RECORD_POSITIONS));
    }

    protected void addRecordPositionsToHeader(Set<Long> positionSet, int numRecords) {
        if (positionSet.size() == numRecords) {
            try {
                this.logBlockHeader.put(HeaderMetadataType.RECORD_POSITIONS, LogReaderUtils.encodePositions(positionSet));
            }
            catch (IOException e) {
                LOG.error("Cannot write record positions to the log block header.", (Throwable)e);
            }
        } else {
            LOG.warn("There are duplicate keys in the records (number of unique positions: {}, number of records: {}). Skip writing record positions to the log block header.", (Object)positionSet.size(), (Object)numRecords);
        }
    }

    public static byte[] getHeaderMetadataBytes(Map<HeaderMetadataType, String> metadata) throws IOException {
        return HoodieLogBlock.getLogMetadataBytes(metadata);
    }

    public static Map<HeaderMetadataType, String> getHeaderMetadata(SeekableDataInputStream dis) throws IOException {
        return HoodieLogBlock.getLogMetadata(dis, index -> HeaderMetadataType.values()[index]);
    }

    public static byte[] getFooterMetadataBytes(Map<FooterMetadataType, String> metadata) throws IOException {
        return HoodieLogBlock.getLogMetadataBytes(metadata);
    }

    public static Map<FooterMetadataType, String> getFooterMetadata(SeekableDataInputStream dis) throws IOException {
        return HoodieLogBlock.getLogMetadata(dis, index -> FooterMetadataType.values()[index]);
    }

    public static Option<byte[]> tryReadContent(SeekableDataInputStream inputStream, Integer contentLength, boolean readLazily) throws IOException {
        if (readLazily) {
            inputStream.seek(inputStream.getPos() + (long)contentLength.intValue());
            return Option.empty();
        }
        byte[] content = new byte[contentLength.intValue()];
        inputStream.readFully(content, 0, contentLength.intValue());
        return Option.of((Object)content);
    }

    protected void inflate() throws HoodieIOException {
        ValidationUtils.checkState((!this.content.isPresent() ? 1 : 0) != 0, (String)"Block has already been inflated");
        ValidationUtils.checkState((this.inputStreamSupplier != null ? 1 : 0) != 0, (String)"Block should have input-stream provided");
        try (SeekableDataInputStream inputStream = this.inputStreamSupplier.get();){
            this.content = Option.of((Object)new byte[(int)((HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getBlockSize()]);
            inputStream.seek(((HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getContentPositionInLogFile());
            inputStream.readFully((byte[])this.content.get(), 0, ((byte[])this.content.get()).length);
            inputStream.seek(((HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getBlockEndPos());
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
            throw new HoodieIOException("Thread is interrupted while inflating.", (IOException)e);
        }
        catch (IOException e) {
            this.deflate();
            this.inflate();
        }
    }

    protected void deflate() {
        this.content = Option.empty();
    }

    private static <T extends Enum<T>> byte[] getLogMetadataBytes(Map<T, String> metadata) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        output.writeInt(metadata.size());
        for (Map.Entry<T, String> entry : metadata.entrySet()) {
            output.writeInt(((Enum)entry.getKey()).ordinal());
            byte[] bytes = StringUtils.getUTF8Bytes((String)entry.getValue());
            output.writeInt(bytes.length);
            output.write(bytes);
        }
        return baos.toByteArray();
    }

    private static <T> Map<T, String> getLogMetadata(SeekableDataInputStream dis, Function<Integer, T> typeMapper) throws IOException {
        HashMap<T, String> metadata = new HashMap<T, String>();
        try {
            for (int metadataCount = dis.readInt(); metadataCount > 0; --metadataCount) {
                int metadataEntryIndex = dis.readInt();
                int metadataEntrySize = dis.readInt();
                byte[] metadataEntry = new byte[metadataEntrySize];
                dis.readFully(metadataEntry, 0, metadataEntrySize);
                metadata.put(typeMapper.apply(metadataEntryIndex), new String(metadataEntry));
            }
            return metadata;
        }
        catch (EOFException eof) {
            throw new IOException("Could not read metadata fields ", eof);
        }
    }

    public static final class HoodieLogBlockContentLocation {
        private final HoodieStorage storage;
        private final HoodieLogFile logFile;
        private final long contentPositionInLogFile;
        private final long blockSize;
        private final long blockEndPos;

        public HoodieLogBlockContentLocation(HoodieStorage storage, HoodieLogFile logFile, long contentPositionInLogFile, long blockSize, long blockEndPos) {
            this.storage = storage;
            this.logFile = logFile;
            this.contentPositionInLogFile = contentPositionInLogFile;
            this.blockSize = blockSize;
            this.blockEndPos = blockEndPos;
        }

        public HoodieStorage getStorage() {
            return this.storage;
        }

        public HoodieLogFile getLogFile() {
            return this.logFile;
        }

        public long getContentPositionInLogFile() {
            return this.contentPositionInLogFile;
        }

        public long getBlockSize() {
            return this.blockSize;
        }

        public long getBlockEndPos() {
            return this.blockEndPos;
        }
    }

    public static enum FooterMetadataType {

    }

    public static enum HeaderMetadataType {
        INSTANT_TIME(HoodieTableVersion.ONE),
        TARGET_INSTANT_TIME(HoodieTableVersion.ONE),
        SCHEMA(HoodieTableVersion.ONE),
        COMMAND_BLOCK_TYPE(HoodieTableVersion.ONE),
        COMPACTED_BLOCK_TIMES(HoodieTableVersion.FIVE),
        RECORD_POSITIONS(HoodieTableVersion.SIX),
        BLOCK_IDENTIFIER(HoodieTableVersion.SIX),
        IS_PARTIAL(HoodieTableVersion.EIGHT);

        private final HoodieTableVersion earliestTableVersion;

        private HeaderMetadataType(HoodieTableVersion version) {
            this.earliestTableVersion = version;
        }
    }

    public static enum HoodieLogBlockType {
        COMMAND_BLOCK(":command", HoodieTableVersion.ONE),
        DELETE_BLOCK(":delete", HoodieTableVersion.ONE),
        CORRUPT_BLOCK(":corrupted", HoodieTableVersion.ONE),
        AVRO_DATA_BLOCK("avro", HoodieTableVersion.ONE),
        HFILE_DATA_BLOCK("hfile", HoodieTableVersion.ONE),
        PARQUET_DATA_BLOCK("parquet", HoodieTableVersion.FOUR),
        CDC_DATA_BLOCK("cdc", HoodieTableVersion.SIX);

        private static final Map<String, HoodieLogBlockType> ID_TO_ENUM_MAP;
        private final String id;
        private final HoodieTableVersion earliestTableVersion;

        private HoodieLogBlockType(String id, HoodieTableVersion earliestTableVersion) {
            this.id = id;
            this.earliestTableVersion = earliestTableVersion;
        }

        public static HoodieLogBlockType fromId(String id) {
            return ID_TO_ENUM_MAP.get(id);
        }

        public boolean isDataOrDeleteBlock() {
            return this != COMMAND_BLOCK && this != CORRUPT_BLOCK;
        }

        static {
            ID_TO_ENUM_MAP = TypeUtils.getValueToEnumMap(HoodieLogBlockType.class, e -> e.id);
        }
    }
}

