/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.HoodieBaseFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;

public class HoodieUnmergedFileGroupRecordBuffer<T>
extends HoodieBaseFileGroupRecordBuffer<T> {
    private Long putIndex = 0L;
    private Long getIndex = 0L;

    public HoodieUnmergedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partitionNameOverrideOpt, partitionPathFieldOpt, props, readStats);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState((this.baseFileIterator != null ? 1 : 0) != 0, (String)"Base file iterator has not been set yet");
        if (this.baseFileIterator.hasNext()) {
            this.nextRecord = this.readerContext.seal(this.baseFileIterator.next());
            return true;
        }
        if (!this.records.isEmpty()) {
            Long l = this.getIndex;
            Long l2 = this.getIndex = Long.valueOf(this.getIndex + 1L);
            Pair nextRecordInfo = (Pair)this.records.remove(l);
            if (nextRecordInfo == null) {
                throw new HoodieException("Row index should be continuous!");
            }
            if (!((Option)nextRecordInfo.getLeft()).isPresent()) {
                throw new IllegalStateException("No deletes should exist in unmerged reading mode");
            }
            this.nextRecord = ((Option)nextRecordInfo.getKey()).get();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Pair<Option<T>, Map<String, Object>>> getLogRecordIterator() {
        return this.records.values().iterator();
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.UNMERGED;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        Pair recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        if (dataBlock.containsPartialUpdates()) {
            throw new HoodieException("Partial update is not supported for unmerged record read");
        }
        try (ClosableIterator recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                Map<String, Object> metadata = this.readerContext.generateMetadataForRecord(nextRecord, recordsIteratorSchemaPair.getRight());
                Long l = this.putIndex;
                Long l2 = this.putIndex = Long.valueOf(this.putIndex + 1L);
                this.processNextDataRecord(nextRecord, metadata, l);
            }
        }
    }

    @Override
    public void processNextDataRecord(T record, Map<String, Object> metadata, Serializable index) {
        this.records.put(index, Pair.of(Option.ofNullable(this.readerContext.seal(record)), metadata));
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) {
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable index) {
        this.records.put(index, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord(deleteRecord.getRecordKey(), deleteRecord.getPartitionPath(), deleteRecord.getOrderingValue(), (Option<Schema.Type>)this.orderingFieldTypeOpt)));
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.containsKey(recordKey);
    }
}

