/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieLSMTimelineManifest;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.util.ArchivedInstantReadSchemas;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSMTimeline {
    private static final Logger LOG = LoggerFactory.getLogger(LSMTimeline.class);
    public static final int LSM_TIMELINE_INSTANT_VERSION_1 = 1;
    private static final String VERSION_FILE_NAME = "_version_";
    private static final String MANIFEST_FILE_PREFIX = "manifest_";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^(\\d+)_(\\d+)_(\\d)\\.parquet");

    public static Schema getReadSchema(HoodieArchivedTimeline.LoadMode loadMode) {
        switch (loadMode) {
            case TIME: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_WITH_TIME;
            }
            case ACTION: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_WITH_ACTION;
            }
            case METADATA: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_WITH_METADATA;
            }
            case PLAN: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_WITH_PLAN;
            }
            case FULL: {
                return ArchivedInstantReadSchemas.TIMELINE_LSM_READ_SCHEMA_AS_FULL;
            }
        }
        throw new AssertionError((Object)"Unexpected");
    }

    public static boolean isFileInRange(HoodieArchivedTimeline.TimeRangeFilter filter, String fileName) {
        String minInstant = LSMTimeline.getMinInstantTime(fileName);
        String maxInstant = LSMTimeline.getMaxInstantTime(fileName);
        return filter.isInRange(minInstant) || filter.isInRange(maxInstant);
    }

    public static int latestSnapshotVersion(HoodieTableMetaClient metaClient, StoragePath archivePath) throws IOException {
        StoragePath versionFilePath = LSMTimeline.getVersionFilePath(archivePath);
        if (metaClient.getStorage().exists(versionFilePath)) {
            try {
                Option content = FileIOUtils.readDataFromPath((HoodieStorage)metaClient.getStorage(), (StoragePath)versionFilePath);
                if (content.isPresent()) {
                    return Integer.parseInt(StringUtils.fromUTF8Bytes((byte[])((byte[])content.get())));
                }
            }
            catch (Exception e) {
                LOG.warn("Error reading version file {}", (Object)versionFilePath, (Object)e);
            }
        }
        return LSMTimeline.allSnapshotVersions(metaClient, archivePath).stream().max(Integer::compareTo).orElse(-1);
    }

    public static List<Integer> allSnapshotVersions(HoodieTableMetaClient metaClient, StoragePath archivePath) throws IOException {
        if (!metaClient.getStorage().exists(archivePath)) {
            return Collections.emptyList();
        }
        return metaClient.getStorage().listDirectEntries(archivePath, LSMTimeline.getManifestFilePathFilter()).stream().map(fileStatus -> fileStatus.getPath().getName()).map(LSMTimeline::getManifestVersion).collect(Collectors.toList());
    }

    public static HoodieLSMTimelineManifest latestSnapshotManifest(HoodieTableMetaClient metaClient, StoragePath archivePath) throws IOException {
        int latestVersion = LSMTimeline.latestSnapshotVersion(metaClient, archivePath);
        return LSMTimeline.latestSnapshotManifest(metaClient, latestVersion, archivePath);
    }

    public static HoodieLSMTimelineManifest latestSnapshotManifest(HoodieTableMetaClient metaClient, int latestVersion, StoragePath archivePath) {
        if (latestVersion < 0) {
            return HoodieLSMTimelineManifest.EMPTY;
        }
        byte[] content = (byte[])FileIOUtils.readDataFromPath((HoodieStorage)metaClient.getStorage(), (StoragePath)LSMTimeline.getManifestFilePath(latestVersion, archivePath)).get();
        try {
            return HoodieLSMTimelineManifest.fromJsonString(StringUtils.fromUTF8Bytes((byte[])content), HoodieLSMTimelineManifest.class);
        }
        catch (Exception e) {
            throw new HoodieException("Error deserializing manifest entries", (Throwable)e);
        }
    }

    public static StoragePath getManifestFilePath(int snapshotVersion, StoragePath archivePath) {
        return new StoragePath(archivePath, MANIFEST_FILE_PREFIX + snapshotVersion);
    }

    public static StoragePath getVersionFilePath(StoragePath archivePath) {
        return new StoragePath(archivePath, VERSION_FILE_NAME);
    }

    public static List<StoragePathInfo> listAllManifestFiles(HoodieTableMetaClient metaClient, StoragePath archivePath) throws IOException {
        return metaClient.getStorage().listDirectEntries(archivePath, LSMTimeline.getManifestFilePathFilter());
    }

    public static List<StoragePathInfo> listAllMetaFiles(HoodieTableMetaClient metaClient, StoragePath archivePath) throws IOException {
        return metaClient.getStorage().globEntries(new StoragePath(archivePath, "*.parquet"));
    }

    public static int getManifestVersion(String fileName) {
        return Integer.parseInt(fileName.split("_")[1]);
    }

    public static int getFileLayer(String fileName) {
        try {
            Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileName);
            if (fileMatcher.matches()) {
                return Integer.parseInt(fileMatcher.group(3));
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("error getting file layout for archived file: {}", (Object)fileName);
        }
        return 0;
    }

    public static String getMinInstantTime(String fileName) {
        Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileName);
        if (fileMatcher.matches()) {
            return fileMatcher.group(1);
        }
        throw new HoodieException("Unexpected archival file name: " + fileName);
    }

    public static String getMaxInstantTime(String fileName) {
        Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(fileName);
        if (fileMatcher.matches()) {
            return fileMatcher.group(2);
        }
        throw new HoodieException("Unexpected archival file name: " + fileName);
    }

    public static boolean isFileFromLayer(String fileName, int layer) {
        return LSMTimeline.getFileLayer(fileName) == layer;
    }

    public static StoragePathFilter getManifestFilePathFilter() {
        return (StoragePathFilter & Serializable)path -> path.getName().startsWith(MANIFEST_FILE_PREFIX) && !path.getName().endsWith(TEMP_FILE_SUFFIX);
    }
}

