/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.table.timeline.TimeGeneratorType;
import org.apache.hudi.common.util.Option;

public class HoodieTimeGeneratorConfig
extends HoodieConfig {
    public static final String LOCK_PROVIDER_KEY = "hoodie.write.lock.provider";
    private static final String DEFAULT_LOCK_PROVIDER = "org.apache.hudi.client.transaction.lock.InProcessLockProvider";
    public static final ConfigProperty<String> TIME_GENERATOR_TYPE = ConfigProperty.key("hoodie.time.generator.type").defaultValue(TimeGeneratorType.WAIT_TO_ADJUST_SKEW.name()).withValidValues(TimeGeneratorType.WAIT_TO_ADJUST_SKEW.name()).sinceVersion("1.0.0").markAdvanced().withDocumentation("Time generator type, which is used to generate globally monotonically increasing timestamp");
    public static final ConfigProperty<Long> MAX_EXPECTED_CLOCK_SKEW_MS = ConfigProperty.key("hoodie.time.generator.max_expected_clock_skew_ms").defaultValue(200L).withInferFunction(cfg -> {
        if (DEFAULT_LOCK_PROVIDER.equals(cfg.getString(LOCK_PROVIDER_KEY))) {
            return Option.of((Object)1L);
        }
        return Option.empty();
    }).sinceVersion("1.0.0").markAdvanced().withDocumentation("The max expected clock skew time in ms between two processes generating time. Used by " + TimeGeneratorType.WAIT_TO_ADJUST_SKEW.name() + " time generator to implement TrueTime semantics.");
    public static final ConfigProperty<Boolean> TIME_GENERATOR_REUSE_ENABLE = ConfigProperty.key("_hoodie.time.generator.reuse.enable").defaultValue(true).sinceVersion("1.0.1").markAdvanced().withDocumentation("Used only for internal purposes. TimeGeneratos are cached per table base path and re-used across invocations. For some internal purposes, we wanted to avoid using the cached TimeGenerator (like upgrade flows). Hence this config will be used internally during upgrade flow. No advisable for end user to use this config. ");

    private HoodieTimeGeneratorConfig() {
    }

    public TimeGeneratorType getTimeGeneratorType() {
        return TimeGeneratorType.valueOf(this.getString(TIME_GENERATOR_TYPE));
    }

    public long getMaxExpectedClockSkewMs() {
        return this.getLong(MAX_EXPECTED_CLOCK_SKEW_MS);
    }

    public boolean canReuseTimeGenerator() {
        return this.getBoolean(TIME_GENERATOR_REUSE_ENABLE);
    }

    public String getBasePath() {
        return this.getString(HoodieCommonConfig.BASE_PATH);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static HoodieTimeGeneratorConfig defaultConfig(String tablePath) {
        return HoodieTimeGeneratorConfig.newBuilder().withPath(tablePath).build();
    }

    public LockConfiguration getLockConfiguration() {
        return new LockConfiguration(this.props);
    }

    public static class Builder {
        private final HoodieTimeGeneratorConfig timeGeneratorConfig = new HoodieTimeGeneratorConfig();

        public Builder fromProperties(Properties props) {
            this.timeGeneratorConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withDefaultLockProvider(boolean useDefaultLockProvider) {
            if (useDefaultLockProvider) {
                this.timeGeneratorConfig.getProps().setPropertyIfNonNull(HoodieTimeGeneratorConfig.LOCK_PROVIDER_KEY, HoodieTimeGeneratorConfig.DEFAULT_LOCK_PROVIDER);
            }
            return this;
        }

        public Builder withTimeGeneratorType(TimeGeneratorType type) {
            this.timeGeneratorConfig.setValue(TIME_GENERATOR_TYPE, type.name());
            return this;
        }

        public Builder withMaxExpectedClockSkewMs(long skewMs) {
            this.timeGeneratorConfig.setValue(MAX_EXPECTED_CLOCK_SKEW_MS, String.valueOf(skewMs));
            return this;
        }

        public Builder withReuseTimeGenerator(boolean reuseTimeGenerator) {
            this.timeGeneratorConfig.setValue(TIME_GENERATOR_REUSE_ENABLE, String.valueOf(reuseTimeGenerator));
            return this;
        }

        public Builder withPath(String basePath) {
            this.timeGeneratorConfig.setValue(HoodieCommonConfig.BASE_PATH, basePath);
            return this;
        }

        public HoodieTimeGeneratorConfig build() {
            this.timeGeneratorConfig.setDefaults(HoodieTimeGeneratorConfig.class.getName());
            if (!this.timeGeneratorConfig.contains(HoodieTimeGeneratorConfig.LOCK_PROVIDER_KEY).booleanValue()) {
                this.timeGeneratorConfig.setValue(HoodieTimeGeneratorConfig.LOCK_PROVIDER_KEY, HoodieTimeGeneratorConfig.DEFAULT_LOCK_PROVIDER);
            }
            return this.timeGeneratorConfig;
        }
    }
}

