/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodiePreCombineAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieMetadataRecordMerger
extends HoodiePreCombineAvroRecordMerger {
    public static final HoodieMetadataRecordMerger INSTANCE = new HoodieMetadataRecordMerger();

    @Override
    public List<Pair<HoodieRecord, Schema>> fullOuterMerge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        if (newer.isDelete(newSchema, props)) {
            return Collections.singletonList(Pair.of(newer, newSchema));
        }
        ValidationUtils.checkArgument((boolean)older.getRecordKey().equals(newer.getRecordKey()), (String)"Record key must be the same for both records");
        ValidationUtils.checkArgument((boolean)oldSchema.equals((Object)newSchema), (String)"Schema must be the same for both records");
        return Arrays.asList(Pair.of(older, oldSchema), Pair.of(newer, newSchema));
    }
}

