/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieKeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodiePositionBasedFileGroupRecordBuffer<T>
extends HoodieKeyBasedFileGroupRecordBuffer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodiePositionBasedFileGroupRecordBuffer.class);
    private static final String ROW_INDEX_COLUMN_NAME = "row_index";
    public static final String ROW_INDEX_TEMPORARY_COLUMN_NAME = "_tmp_metadata_row_index";
    protected final String baseFileInstantTime;
    private long nextRecordPosition = 0L;
    private boolean needToDoHybridStrategy = false;

    public HoodiePositionBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, String baseFileInstantTime, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partitionNameOverrideOpt, partitionPathFieldOpt, props, readStats);
        this.baseFileInstantTime = baseFileInstantTime;
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return this.readerContext.getShouldMergeUseRecordPosition() ? HoodieFileGroupRecordBuffer.BufferType.POSITION_BASED_MERGE : super.getBufferType();
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            super.processDataBlock(dataBlock, keySpecOpt);
            return;
        }
        List<Long> recordPositions = HoodiePositionBasedFileGroupRecordBuffer.extractRecordPositions(dataBlock, this.baseFileInstantTime);
        if (recordPositions == null) {
            LOG.warn("Falling back to key based merge for Read");
            this.fallbackToKeyBasedBuffer();
            super.processDataBlock(dataBlock, keySpecOpt);
            return;
        }
        HashSet<String> keys = new HashSet();
        boolean isFullKey = true;
        if (keySpecOpt.isPresent()) {
            if (!((KeySpec)keySpecOpt.get()).getKeys().isEmpty()) {
                keys = new HashSet<String>(((KeySpec)keySpecOpt.get()).getKeys());
            }
            isFullKey = ((KeySpec)keySpecOpt.get()).isFullKey();
        }
        if (dataBlock.containsPartialUpdates()) {
            this.enablePartialMerging = true;
        }
        Pair schemaTransformerWithEvolvedSchema = this.getSchemaTransformerWithEvolvedSchema(dataBlock);
        try (ClosableIterator recordIterator = dataBlock.getEngineRecordIterator(this.readerContext);){
            int recordIndex = 0;
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                if (this.shouldSkip(nextRecord, dataBlock.getKeyFieldName(), isFullKey, keys, dataBlock.getSchema())) {
                    ++recordIndex;
                    continue;
                }
                long recordPosition = recordPositions.get(recordIndex++);
                Object evolvedNextRecord = schemaTransformerWithEvolvedSchema.getLeft().apply(nextRecord);
                this.processNextDataRecord(evolvedNextRecord, this.readerContext.generateMetadataForRecord(evolvedNextRecord, schemaTransformerWithEvolvedSchema.getRight()), Long.valueOf(recordPosition));
            }
        }
    }

    private void fallbackToKeyBasedBuffer() {
        this.readerContext.setShouldMergeUseRecordPosition(false);
        ArrayList positions = new ArrayList(this.records.keySet());
        for (Serializable position : positions) {
            Pair entry = (Pair)this.records.get(position);
            Object recordKey = ((Map)entry.getRight()).get("_0");
            if (((Option)entry.getLeft()).isPresent() || recordKey != null) {
                this.records.put((String)recordKey, entry);
                this.records.remove(position);
                continue;
            }
            this.needToDoHybridStrategy = true;
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            super.processDeleteBlock(deleteBlock);
            return;
        }
        List<Long> recordPositions = HoodiePositionBasedFileGroupRecordBuffer.extractRecordPositions(deleteBlock, this.baseFileInstantTime);
        if (recordPositions == null) {
            LOG.warn("Falling back to key based merge for Read");
            this.fallbackToKeyBasedBuffer();
            super.processDeleteBlock(deleteBlock);
            return;
        }
        switch (this.recordMergeMode) {
            case COMMIT_TIME_ORDERING: {
                for (Long recordPosition : recordPositions) {
                    this.records.putIfAbsent(recordPosition, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord(null, "", Integer.valueOf(0))));
                }
                return;
            }
        }
        int recordIndex = 0;
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            long recordPosition = recordPositions.get(recordIndex++);
            this.processNextDeletedRecord(record, Long.valueOf(recordPosition));
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable recordPosition) {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordPosition);
        Option<DeleteRecord> recordOpt = this.doProcessNextDeletedRecord(deleteRecord, existingRecordMetadataPair);
        if (recordOpt.isPresent()) {
            String recordKey = ((DeleteRecord)recordOpt.get()).getRecordKey();
            this.records.put(recordPosition, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord(recordKey, ((DeleteRecord)recordOpt.get()).getPartitionPath(), HoodiePositionBasedFileGroupRecordBuffer.getOrderingValue(this.readerContext, (DeleteRecord)recordOpt.get()))));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.values().stream().filter(r -> ((Option)r.getLeft()).isPresent()).map(r -> this.readerContext.getRecordKey(((Option)r.getKey()).get(), this.readerSchema)).anyMatch(recordKey::equals);
    }

    @Override
    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        Option resultRecord;
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            return this.doHasNextFallbackBaseRecord(baseRecord);
        }
        this.nextRecordPosition = this.readerContext.extractRecordPosition(baseRecord, this.readerSchema, ROW_INDEX_TEMPORARY_COLUMN_NAME, this.nextRecordPosition);
        Pair logRecordInfo = (Pair)this.records.remove(this.nextRecordPosition++);
        Map<String, Object> metadata = this.readerContext.generateMetadataForRecord(baseRecord, this.readerSchema);
        Option option = resultRecord = logRecordInfo != null ? this.merge(Option.of(baseRecord), metadata, (Option)logRecordInfo.getLeft(), (Map)logRecordInfo.getRight()) : this.merge(Option.empty(), Collections.emptyMap(), Option.of(baseRecord), metadata);
        if (resultRecord.isPresent()) {
            this.nextRecord = this.readerContext.seal(resultRecord.get());
            return true;
        }
        return false;
    }

    private boolean doHasNextFallbackBaseRecord(T baseRecord) throws IOException {
        if (this.needToDoHybridStrategy) {
            Pair logRecordInfo;
            this.nextRecordPosition = this.readerContext.extractRecordPosition(baseRecord, this.readerSchema, ROW_INDEX_TEMPORARY_COLUMN_NAME, this.nextRecordPosition);
            if ((logRecordInfo = (Pair)this.records.remove(this.nextRecordPosition++)) != null) {
                this.records.remove(this.readerContext.getRecordKey(baseRecord, this.readerSchema));
                return false;
            }
        }
        return super.hasNextBaseRecord(baseRecord);
    }

    protected boolean shouldSkip(T record, String keyFieldName, boolean isFullKey, Set<String> keys, Schema writerSchema) {
        block6: {
            block5: {
                if (keys.isEmpty()) {
                    return false;
                }
                String recordKey = this.readerContext.getValue(record, writerSchema, keyFieldName).toString();
                if (recordKey == null || recordKey.isEmpty()) {
                    throw new HoodieKeyException("Can not extract the key for a record");
                }
                if (isFullKey && keys.contains(recordKey)) break block5;
                if (isFullKey) break block6;
                if (!keys.stream().anyMatch(recordKey::startsWith)) break block6;
            }
            return false;
        }
        return true;
    }

    protected static List<Long> extractRecordPositions(HoodieLogBlock logBlock, String baseFileInstantTime) throws IOException {
        ArrayList<Long> blockPositions = new ArrayList<Long>();
        String blockBaseFileInstantTime = logBlock.getBaseFileInstantTimeOfPositions();
        if (StringUtils.isNullOrEmpty((String)blockBaseFileInstantTime) || !baseFileInstantTime.equals(blockBaseFileInstantTime)) {
            LOG.debug("The record positions cannot be used because the base file instant time is either missing or different from the base file to merge. Instant time in the header: {}, base file instant time of the file group: {}.", (Object)blockBaseFileInstantTime, (Object)baseFileInstantTime);
            return null;
        }
        Roaring64NavigableMap positions = logBlock.getRecordPositions();
        if (positions == null || positions.isEmpty()) {
            LOG.warn("No record position info is found when attempt to do position based merge.");
            return null;
        }
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            blockPositions.add((Long)iterator.next());
        }
        if (blockPositions.isEmpty()) {
            LOG.warn("No positions are extracted.");
            return null;
        }
        return blockPositions;
    }
}

