/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparator;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieTimeline
implements HoodieTimeline {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieTimeline.class);
    private static final long serialVersionUID = 1L;
    private static final String HASHING_ALGORITHM = "SHA-256";
    protected transient Function<HoodieInstant, Option<byte[]>> details;
    private List<HoodieInstant> instants;
    private volatile transient Set<String> instantTimeSet;
    protected volatile transient Set<String> pendingClusteringInstants;
    private volatile transient Option<HoodieInstant> firstNonSavepointCommit;
    private volatile transient Option<HoodieInstant> firstNonSavepointCommitByCompletionTime;
    private String timelineHash;
    protected TimelineFactory factory;
    protected InstantComparator instantComparator;
    protected InstantGenerator instantGenerator;

    public BaseHoodieTimeline(TimelineLayout layout) {
        this.factory = layout.getTimelineFactory();
        this.instantComparator = layout.getInstantComparator();
        this.instantGenerator = layout.getInstantGenerator();
    }

    public BaseHoodieTimeline(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details, TimelineFactory factory, InstantComparator instantComparator, InstantGenerator instantGenerator) {
        this.details = details;
        this.factory = factory;
        this.instantComparator = instantComparator;
        this.instantGenerator = instantGenerator;
        this.setInstants(instants.collect(Collectors.toList()));
    }

    @Override
    public void setInstants(List<HoodieInstant> instants) {
        this.instants = instants;
        this.timelineHash = this.computeTimelineHash(this.instants);
        this.clearState();
    }

    protected void appendInstants(List<HoodieInstant> newInstants) {
        if (newInstants.isEmpty()) {
            return;
        }
        if (this.instants.isEmpty()) {
            this.setInstants(newInstants);
            return;
        }
        this.instants = BaseHoodieTimeline.mergeInstants(newInstants, this.instants);
        this.timelineHash = this.computeTimelineHash(this.instants);
        this.clearState();
    }

    @Override
    public HoodieTimeline filterInflights() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter(HoodieInstant::isInflight), this.details);
    }

    @Override
    public HoodieTimeline filterInflightsAndRequested() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T i) -> i.getState().equals((Object)HoodieInstant.State.REQUESTED) || i.getState().equals((Object)HoodieInstant.State.INFLIGHT)), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingCompaction() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T instant) -> !instant.isCompleted() && !instant.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingLogCompaction() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T instant) -> !instant.isCompleted() && !instant.getAction().equals("logcompaction")), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingCompactionAndLogCompaction() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T instant) -> !instant.isCompleted() && (!instant.getAction().equals("compaction") || !instant.getAction().equals("logcompaction"))), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedInstants() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedAndCompactionInstants() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.isCompleted() || s.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedOrMajorOrMinorCompactionInstants() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.isCompleted() || s.getAction().equals("compaction") || s.getAction().equals("logcompaction")), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedInstantsOrRewriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("compaction", "logcompaction", "replacecommit");
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.isCompleted() || validActions.contains(s.getAction())), this.details);
    }

    @Override
    public HoodieTimeline getWriteTimeline() {
        Set<String> validActions = CollectionUtils.createSet("commit", "deltacommit", "compaction", "logcompaction", "replacecommit", "clustering");
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> validActions.contains(s.getAction())), this.details);
    }

    @Override
    public HoodieTimeline getContiguousCompletedWriteTimeline() {
        Option<HoodieInstant> earliestPending = this.getWriteTimeline().filterInflightsAndRequested().firstInstant();
        if (earliestPending.isPresent()) {
            return this.getWriteTimeline().filterCompletedInstants().filter(instant -> InstantComparison.compareTimestamps(instant.requestedTime(), InstantComparison.LESSER_THAN, ((HoodieInstant)earliestPending.get()).requestedTime()));
        }
        return this.getWriteTimeline().filterCompletedInstants();
    }

    @Override
    public HoodieTimeline getCompletedReplaceTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("replacecommit")).filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterPendingReplaceTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("replacecommit") && !s.isCompleted()), this.details);
    }

    @Override
    public abstract HoodieTimeline filterPendingClusteringTimeline();

    @Override
    public abstract HoodieTimeline filterPendingReplaceOrClusteringTimeline();

    @Override
    public abstract HoodieTimeline filterPendingReplaceClusteringAndCompactionTimeline();

    @Override
    public HoodieTimeline filterPendingRollbackTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("rollback") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterRequestedRollbackTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("rollback") && s.isRequested()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingCompactionTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("compaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingLogCompactionTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("logcompaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterPendingMajorOrMinorCompactionTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("compaction") || s.getAction().equals("logcompaction") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline findInstantsInRange(String startTs, String endTs) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.isInRange(s.requestedTime(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieTimeline findInstantsInClosedRange(String startTs, String endTs) {
        return this.factory.createDefaultTimeline(this.instants.stream().filter((? super T instant) -> InstantComparison.isInClosedRange(instant.requestedTime(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieTimeline findInstantsInRangeByCompletionTime(String startTs, String endTs) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getCompletionTime() != null && InstantComparison.isInClosedRange(s.getCompletionTime(), startTs, endTs)), this.details);
    }

    @Override
    public HoodieTimeline findInstantsModifiedAfterByCompletionTime(String instantTime) {
        return this.factory.createDefaultTimeline(this.instants.stream().filter((? super T s) -> s.getCompletionTime() == null && InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.GREATER_THAN, instantTime) || s.getCompletionTime() != null && InstantComparison.compareTimestamps(s.getCompletionTime(), InstantComparison.GREATER_THAN, instantTime) && !s.requestedTime().equals(instantTime)), this.details);
    }

    @Override
    public HoodieTimeline findInstantsAfter(String instantTime, int numCommits) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.GREATER_THAN, instantTime)).limit(numCommits), this.details);
    }

    @Override
    public HoodieTimeline findInstantsAfter(String instantTime) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.GREATER_THAN, instantTime)), this.details);
    }

    @Override
    public HoodieTimeline findInstantsAfterOrEquals(String commitTime, int numCommits) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.GREATER_THAN_OR_EQUALS, commitTime)).limit(numCommits), this.details);
    }

    @Override
    public HoodieTimeline findInstantsAfterOrEquals(String commitTime) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.GREATER_THAN_OR_EQUALS, commitTime)), this.details);
    }

    @Override
    public HoodieTimeline findInstantsBefore(String instantTime) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.LESSER_THAN, instantTime)), this.details);
    }

    @Override
    public Option<HoodieInstant> findInstantBefore(String instantTime) {
        return Option.fromJavaOptional(this.instants.stream().filter((? super T instant) -> InstantComparison.compareTimestamps(instant.requestedTime(), InstantComparison.LESSER_THAN, instantTime)).max(Comparator.comparing(HoodieInstant::requestedTime)));
    }

    @Override
    public HoodieTimeline findInstantsBeforeOrEquals(String instantTime) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> InstantComparison.compareTimestamps(s.requestedTime(), InstantComparison.LESSER_THAN_OR_EQUALS, instantTime)), this.details);
    }

    @Override
    public HoodieTimeline filter(Predicate<HoodieInstant> filter) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter(filter), this.details);
    }

    @Override
    public HoodieTimeline filterPendingIndexTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("indexing") && !s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedIndexTimeline() {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals("indexing") && s.isCompleted()), this.details);
    }

    @Override
    public HoodieTimeline getCommitsAndCompactionTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit", "clustering", "compaction"));
    }

    @Override
    public HoodieTimeline getAllCommitsTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "clean", "compaction", "savepoint", "rollback", "replacecommit", "clustering", "indexing", "logcompaction"));
    }

    @Override
    public HoodieTimeline getCommitAndReplaceTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit", "replacecommit", "clustering"));
    }

    @Override
    public HoodieTimeline getCommitTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("commit"));
    }

    @Override
    public HoodieTimeline getDeltaCommitTimeline() {
        return this.factory.createDefaultTimeline(this.filterInstantsByAction("deltacommit"), this::getInstantDetails);
    }

    @Override
    public HoodieTimeline getTimelineOfActions(Set<String> actions) {
        return this.factory.createDefaultTimeline(this.getInstantsAsStream().filter((? super T s) -> actions.contains(s.getAction())), this::getInstantDetails);
    }

    @Override
    public HoodieTimeline getCleanerTimeline() {
        return this.factory.createDefaultTimeline(this.filterInstantsByAction("clean"), this::getInstantDetails);
    }

    @Override
    public HoodieTimeline getRollbackTimeline() {
        return this.factory.createDefaultTimeline(this.filterInstantsByAction("rollback"), this::getInstantDetails);
    }

    @Override
    public HoodieTimeline getRollbackAndRestoreTimeline() {
        return this.getTimelineOfActions(CollectionUtils.createSet("rollback", "restore"));
    }

    @Override
    public HoodieTimeline getSavePointTimeline() {
        return this.factory.createDefaultTimeline(this.filterInstantsByAction("savepoint"), this::getInstantDetails);
    }

    @Override
    public HoodieTimeline getRestoreTimeline() {
        return this.factory.createDefaultTimeline(this.filterInstantsByAction("restore"), this::getInstantDetails);
    }

    protected Stream<HoodieInstant> filterInstantsByAction(String action) {
        return this.getInstantsAsStream().filter((? super T s) -> s.getAction().equals(action));
    }

    @Override
    public boolean empty() {
        return this.instants.isEmpty();
    }

    @Override
    public int countInstants() {
        return this.instants.size();
    }

    @Override
    public Option<HoodieInstant> firstInstant() {
        return Option.fromJavaOptional(this.getInstantsAsStream().findFirst());
    }

    @Override
    public Option<HoodieInstant> firstInstant(String action, HoodieInstant.State state) {
        return Option.fromJavaOptional(this.getInstantsAsStream().filter((? super T s) -> action.equals(s.getAction()) && state.equals((Object)s.getState())).findFirst());
    }

    @Override
    public Option<HoodieInstant> nthInstant(int n) {
        if (this.empty() || n >= this.countInstants()) {
            return Option.empty();
        }
        return Option.of((Object)this.getInstants().get(n));
    }

    @Override
    public Option<HoodieInstant> lastInstant() {
        return this.empty() ? Option.empty() : this.nthInstant(this.countInstants() - 1);
    }

    @Override
    public Option<HoodieInstant> nthFromLastInstant(int n) {
        if (this.countInstants() < n + 1) {
            return Option.empty();
        }
        return this.nthInstant(this.countInstants() - 1 - n);
    }

    @Override
    public boolean containsInstant(HoodieInstant instant) {
        return this.getInstantsAsStream().anyMatch(s -> s.equals(instant));
    }

    @Override
    public boolean containsInstant(String ts) {
        if (this.getOrCreateInstantSet().contains(ts)) {
            return true;
        }
        if (ts.length() == HoodieInstantTimeGenerator.MILLIS_INSTANT_TIMESTAMP_FORMAT_LENGTH && ts.endsWith("999")) {
            String actualOlderFormatTs = ts.substring(0, ts.length() - "999".length());
            return this.containsInstant(actualOlderFormatTs);
        }
        return false;
    }

    @Override
    public boolean containsOrBeforeTimelineStarts(String instant) {
        return this.containsInstant(instant) || this.isBeforeTimelineStarts(instant);
    }

    @Override
    public String getTimelineHash() {
        return this.timelineHash;
    }

    @Override
    public Stream<HoodieInstant> getInstantsAsStream() {
        return this.instants.stream();
    }

    @Override
    public List<HoodieInstant> getInstants() {
        return new ArrayList<HoodieInstant>(this.instants);
    }

    @Override
    public Stream<HoodieInstant> getReverseOrderedInstants() {
        return this.getInstantsAsStream().sorted(this.instantComparator.requestedTimeOrderedComparator().reversed());
    }

    @Override
    public Option<String> getLatestCompletionTime() {
        return Option.fromJavaOptional(this.getInstantsAsStream().filter((? super T s) -> s.getCompletionTime() != null).max(this.instantComparator.completionTimeOrderedComparator()).map(HoodieInstant::getCompletionTime));
    }

    @Override
    public Stream<HoodieInstant> getInstantsOrderedByCompletionTime() {
        return this.getInstantsAsStream().filter((? super T s) -> s.getCompletionTime() != null).sorted(this.instantComparator.completionTimeOrderedComparator());
    }

    @Override
    public boolean isBeforeTimelineStarts(String instant) {
        Option<HoodieInstant> firstNonSavepointCommit = this.getFirstNonSavepointCommit();
        return firstNonSavepointCommit.isPresent() && InstantComparison.compareTimestamps(instant, InstantComparison.LESSER_THAN, ((HoodieInstant)firstNonSavepointCommit.get()).requestedTime());
    }

    @Override
    public boolean isBeforeTimelineStartsByCompletionTime(String completionTime) {
        Option<HoodieInstant> firstNonSavepointCommit = this.getFirstNonSavepointCommitByCompletionTime();
        return firstNonSavepointCommit.isPresent() && InstantComparison.compareTimestamps(completionTime, InstantComparison.LESSER_THAN, ((HoodieInstant)firstNonSavepointCommit.get()).getCompletionTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<HoodieInstant> getFirstNonSavepointCommit() {
        if (this.firstNonSavepointCommit == null) {
            BaseHoodieTimeline baseHoodieTimeline = this;
            synchronized (baseHoodieTimeline) {
                if (this.firstNonSavepointCommit == null) {
                    this.firstNonSavepointCommit = BaseHoodieTimeline.findFirstNonSavepointCommit(this.instants, this.instantComparator.requestedTimeOrderedComparator());
                }
            }
        }
        return this.firstNonSavepointCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<HoodieInstant> getFirstNonSavepointCommitByCompletionTime() {
        if (this.firstNonSavepointCommitByCompletionTime == null) {
            BaseHoodieTimeline baseHoodieTimeline = this;
            synchronized (baseHoodieTimeline) {
                if (this.firstNonSavepointCommitByCompletionTime == null) {
                    this.firstNonSavepointCommitByCompletionTime = BaseHoodieTimeline.findFirstNonSavepointCommit(this.instants.stream().filter(HoodieInstant::isCompleted).collect(Collectors.toList()), this.instantComparator.completionTimeOrderedComparator());
                }
            }
        }
        return this.firstNonSavepointCommitByCompletionTime;
    }

    @Override
    public abstract Option<HoodieInstant> getLastClusteringInstant();

    @Override
    public abstract Option<HoodieInstant> getFirstPendingClusterInstant();

    @Override
    public abstract Option<HoodieInstant> getLastPendingClusterInstant();

    @Override
    public abstract boolean isPendingClusteringInstant(String var1);

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return this.details.apply(instant);
    }

    @Override
    public boolean isEmpty(HoodieInstant instant) {
        return ((byte[])this.getInstantDetails(instant).get()).length == 0;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getInstantsAsStream().map(Object::toString).collect(Collectors.joining(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOrCreateInstantSet() {
        if (this.instantTimeSet == null) {
            BaseHoodieTimeline baseHoodieTimeline = this;
            synchronized (baseHoodieTimeline) {
                if (this.instantTimeSet == null) {
                    this.instantTimeSet = this.instants.stream().map(HoodieInstant::requestedTime).collect(Collectors.toSet());
                }
            }
        }
        return this.instantTimeSet;
    }

    private static Option<HoodieInstant> findFirstNonSavepointCommit(List<HoodieInstant> instants, Comparator<HoodieInstant> instantComparator) {
        Set savepointTimestamps = instants.stream().filter((? super T entry) -> entry.getAction().equals("savepoint")).map(HoodieInstant::requestedTime).collect(Collectors.toSet());
        return Option.fromJavaOptional(instants.stream().filter((? super T entry) -> !savepointTimestamps.contains(entry.requestedTime())).min(instantComparator));
    }

    private void clearState() {
        this.instantTimeSet = null;
        this.firstNonSavepointCommit = null;
    }

    @Override
    public HoodieTimeline mergeTimeline(HoodieTimeline timeline) {
        Stream<HoodieInstant> instantStream = Stream.concat(this.getInstantsAsStream(), timeline.getInstantsAsStream()).sorted();
        Function<HoodieInstant, Option<byte[]>> details = instant -> {
            if (this.getInstantsAsStream().anyMatch(i -> i.equals(instant))) {
                return this.getInstantDetails((HoodieInstant)instant);
            }
            return timeline.getInstantDetails((HoodieInstant)instant);
        };
        return this.factory.createDefaultTimeline(instantStream, details);
    }

    private String computeTimelineHash(List<HoodieInstant> instants) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(HASHING_ALGORITHM);
            instants.forEach(i -> md.update(StringUtils.getUTF8Bytes((String)StringUtils.joinUsingDelim((String)"_", (String[])new String[]{i.requestedTime(), i.getAction(), i.getState().name()}))));
        }
        catch (NoSuchAlgorithmException nse) {
            throw new HoodieException((Throwable)nse);
        }
        return StringUtils.toHexString((byte[])md.digest());
    }

    private static List<HoodieInstant> mergeInstants(List<HoodieInstant> instants1, List<HoodieInstant> instants2) {
        ArrayList<HoodieInstant> merged;
        ValidationUtils.checkArgument((!instants1.isEmpty() && !instants2.isEmpty() ? 1 : 0) != 0, (String)"The instants to merge can not be empty");
        if (InstantComparison.compareTimestamps(instants1.get(instants1.size() - 1).requestedTime(), InstantComparison.LESSER_THAN_OR_EQUALS, instants2.get(0).requestedTime())) {
            merged = new ArrayList<HoodieInstant>(instants1);
            merged.addAll(instants2);
        } else if (InstantComparison.compareTimestamps(instants2.get(instants2.size() - 1).requestedTime(), InstantComparison.LESSER_THAN_OR_EQUALS, instants1.get(0).requestedTime())) {
            merged = new ArrayList<HoodieInstant>(instants2);
            merged.addAll(instants1);
        } else {
            merged = new ArrayList<HoodieInstant>(instants1);
            merged.addAll(instants2);
            Collections.sort(merged);
        }
        return merged;
    }
}

