/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.function.SerializableSupplier;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.table.view.PriorityBasedFileSystemView;
import org.apache.hudi.common.table.view.RemoteHoodieTableFileSystemView;
import org.apache.hudi.common.table.view.RocksDbBasedFileSystemView;
import org.apache.hudi.common.table.view.SpillableMapBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemViewManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemViewManager.class);
    private static final String HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS = "org.apache.hudi.common.table.view.HoodieMetaserverFileSystemView";
    private final StorageConfiguration<?> conf;
    private final FileSystemViewStorageConfig viewStorageConfig;
    private final Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator;
    private final ConcurrentHashMap<String, SyncableFileSystemView> globalViewMap;

    private FileSystemViewManager(HoodieEngineContext context, FileSystemViewStorageConfig viewStorageConfig, Functions.Function2<HoodieTableMetaClient, FileSystemViewStorageConfig, SyncableFileSystemView> viewCreator) {
        this.conf = context.getStorageConf();
        this.viewStorageConfig = viewStorageConfig;
        this.viewCreator = viewCreator;
        this.globalViewMap = new ConcurrentHashMap();
    }

    public void clearFileSystemView(String basePath) {
        SyncableFileSystemView view = this.globalViewMap.remove(basePath);
        if (view != null) {
            view.close();
        }
    }

    public SyncableFileSystemView getFileSystemView(String basePath) {
        return this.globalViewMap.computeIfAbsent(basePath, path -> {
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.conf.newInstance()).setBasePath((String)path).build();
            return this.viewCreator.apply(metaClient, this.viewStorageConfig);
        });
    }

    public SyncableFileSystemView getFileSystemView(HoodieTableMetaClient metaClient) {
        return this.globalViewMap.computeIfAbsent(metaClient.getBasePath().toString(), path -> this.viewCreator.apply(metaClient, this.viewStorageConfig));
    }

    public void close() {
        if (!this.globalViewMap.isEmpty()) {
            this.globalViewMap.values().forEach(SyncableFileSystemView::close);
            this.globalViewMap.clear();
        }
    }

    private static RocksDbBasedFileSystemView createRocksDBBasedFileSystemView(FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new RocksDbBasedFileSystemView(metaClient, timeline, viewConf);
    }

    private static SpillableMapBasedFileSystemView createSpillableMapBasedFileSystemView(FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, HoodieCommonConfig commonConfig) {
        LOG.info("Creating SpillableMap based view for basePath {}.", (Object)metaClient.getBasePath());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        return new SpillableMapBasedFileSystemView(metaClient, timeline, viewConf, commonConfig);
    }

    private static HoodieTableFileSystemView createInMemoryFileSystemView(FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating InMemory based view for basePath {}.", (Object)metaClient.getBasePath());
        HoodieTimeline timeline = metaClient.getActiveTimeline().filterCompletedAndCompactionInstants();
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            ValidationUtils.checkArgument((metadataCreator != null ? 1 : 0) != 0, (String)"Metadata supplier is null. Cannot instantiate metadata file system view");
            return new HoodieMetadataFileSystemView(metaClient, timeline, metadataCreator.apply(metaClient));
        }
        if (metaClient.getMetaserverConfig().isMetaserverEnabled()) {
            return (HoodieTableFileSystemView)ReflectionUtils.loadClass((String)HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS, (Class[])new Class[]{HoodieTableMetaClient.class, HoodieTimeline.class, HoodieMetaserverConfig.class}, (Object[])new Object[]{metaClient, timeline, metaClient.getMetaserverConfig()});
        }
        return new HoodieTableFileSystemView(metaClient, timeline, viewConf.isIncrementalTimelineSyncEnabled());
    }

    public static HoodieTableFileSystemView createInMemoryFileSystemView(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieMetadataConfig metadataConfig) {
        return FileSystemViewManager.createInMemoryFileSystemViewWithTimeline(engineContext, metaClient, metadataConfig, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants());
    }

    public static HoodieTableFileSystemView createInMemoryFileSystemViewWithTimeline(HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, HoodieMetadataConfig metadataConfig, HoodieTimeline timeline) {
        LOG.info("Creating InMemory based view for basePath {}.", (Object)metaClient.getBasePath());
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            return new HoodieMetadataFileSystemView(engineContext, metaClient, timeline, metadataConfig);
        }
        if (metaClient.getMetaserverConfig().isMetaserverEnabled()) {
            return (HoodieTableFileSystemView)ReflectionUtils.loadClass((String)HOODIE_METASERVER_FILE_SYSTEM_VIEW_CLASS, (Class[])new Class[]{HoodieTableMetaClient.class, HoodieTimeline.class, HoodieMetaserverConfig.class}, (Object[])new Object[]{metaClient, timeline, metaClient.getMetaserverConfig()});
        }
        return new HoodieTableFileSystemView(metaClient, timeline);
    }

    private static RemoteHoodieTableFileSystemView createRemoteFileSystemView(FileSystemViewStorageConfig viewConf, HoodieTableMetaClient metaClient) {
        LOG.info("Creating remote view for basePath {}. Server={}:{}, Timeout={}", new Object[]{metaClient.getBasePath(), viewConf.getRemoteViewServerHost(), viewConf.getRemoteViewServerPort(), viewConf.getRemoteTimelineClientTimeoutSecs()});
        return new RemoteHoodieTableFileSystemView(metaClient, viewConf);
    }

    public static FileSystemViewManager createViewManagerWithTableMetadata(HoodieEngineContext context, HoodieMetadataConfig metadataConfig, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig) {
        return FileSystemViewManager.createViewManager(context, config, commonConfig, metaClient -> HoodieTableMetadata.create(context, metaClient.getStorage(), metadataConfig, metaClient.getBasePath().toString(), true));
    }

    public static FileSystemViewManager createViewManager(HoodieEngineContext context, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig) {
        return FileSystemViewManager.createViewManager(context, config, commonConfig, null);
    }

    public static FileSystemViewManager createViewManager(HoodieEngineContext context, FileSystemViewStorageConfig config, HoodieCommonConfig commonConfig, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
        LOG.info("Creating View Manager with storage type {}.", (Object)config.getStorageType());
        switch (config.getStorageType()) {
            case EMBEDDED_KV_STORE: {
                LOG.debug("Creating embedded rocks-db based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConf) -> FileSystemViewManager.createRocksDBBasedFileSystemView(viewConf, metaClient));
            }
            case SPILLABLE_DISK: {
                LOG.debug("Creating Spillable Disk based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConf) -> FileSystemViewManager.createSpillableMapBasedFileSystemView(viewConf, metaClient, commonConfig));
            }
            case MEMORY: {
                LOG.debug("Creating in-memory based Table View");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> FileSystemViewManager.createInMemoryFileSystemView(viewConfig, metaClient, metadataCreator));
            }
            case REMOTE_ONLY: {
                LOG.debug("Creating remote only table view");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> FileSystemViewManager.createRemoteFileSystemView(viewConfig, metaClient));
            }
            case REMOTE_FIRST: {
                LOG.debug("Creating remote first table view");
                return new FileSystemViewManager(context, config, (metaClient, viewConfig) -> {
                    RemoteHoodieTableFileSystemView remoteFileSystemView = FileSystemViewManager.createRemoteFileSystemView(viewConfig, metaClient);
                    SecondaryViewSupplier secondaryViewSupplier = new SecondaryViewSupplier((FileSystemViewStorageConfig)viewConfig, (HoodieTableMetaClient)metaClient, commonConfig, metadataCreator);
                    return new PriorityBasedFileSystemView(remoteFileSystemView, secondaryViewSupplier);
                });
            }
        }
        throw new IllegalArgumentException("Unknown file system view type :" + (Object)((Object)config.getStorageType()));
    }

    private static class SecondaryViewSupplier
    implements SerializableSupplier<SyncableFileSystemView> {
        private final FileSystemViewStorageConfig viewConfig;
        private final HoodieTableMetaClient metaClient;
        private final HoodieCommonConfig commonConfig;
        private final SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator;

        private SecondaryViewSupplier(FileSystemViewStorageConfig viewConfig, HoodieTableMetaClient metaClient, HoodieCommonConfig commonConfig, SerializableFunctionUnchecked<HoodieTableMetaClient, HoodieTableMetadata> metadataCreator) {
            this.viewConfig = viewConfig;
            this.metaClient = metaClient;
            this.commonConfig = commonConfig;
            this.metadataCreator = metadataCreator;
        }

        @Override
        public SyncableFileSystemView get() {
            switch (this.viewConfig.getSecondaryStorageType()) {
                case MEMORY: {
                    return FileSystemViewManager.createInMemoryFileSystemView(this.viewConfig, this.metaClient, this.metadataCreator);
                }
                case EMBEDDED_KV_STORE: {
                    return FileSystemViewManager.createRocksDBBasedFileSystemView(this.viewConfig, this.metaClient);
                }
                case SPILLABLE_DISK: {
                    return FileSystemViewManager.createSpillableMapBasedFileSystemView(this.viewConfig, this.metaClient, this.commonConfig);
                }
            }
            throw new IllegalArgumentException("Secondary Storage type can only be in-memory or spillable. Was :" + (Object)((Object)this.viewConfig.getSecondaryStorageType()));
        }
    }
}

