/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package org.apache.hudi.avro.model;

import org.apache.avro.generic.GenericArray;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.util.Utf8;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.SchemaStore;

/** Data file column statistics */
@org.apache.avro.specific.AvroGenerated
public class HoodieMetadataColumnStats extends org.apache.avro.specific.SpecificRecordBase implements org.apache.avro.specific.SpecificRecord {
  private static final long serialVersionUID = -7383176095874390521L;


  public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieMetadataColumnStats\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"Data file column statistics\",\"fields\":[{\"name\":\"fileName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"File name for which this column statistics applies\",\"default\":null},{\"name\":\"columnName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Column name for which this column statistics applies\",\"default\":null},{\"name\":\"minValue\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"BooleanWrapper\",\"doc\":\"A record wrapping boolean type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"boolean\"}]},{\"type\":\"record\",\"name\":\"IntWrapper\",\"doc\":\"A record wrapping int type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"LongWrapper\",\"doc\":\"A record wrapping long type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"FloatWrapper\",\"doc\":\"A record wrapping float type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"float\"}]},{\"type\":\"record\",\"name\":\"DoubleWrapper\",\"doc\":\"A record wrapping double type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"double\"}]},{\"type\":\"record\",\"name\":\"BytesWrapper\",\"doc\":\"A record wrapping bytes type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"bytes\"}]},{\"type\":\"record\",\"name\":\"StringWrapper\",\"doc\":\"A record wrapping string type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}]},{\"type\":\"record\",\"name\":\"DateWrapper\",\"doc\":\"A record wrapping Date logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]},{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]},{\"type\":\"record\",\"name\":\"TimeMicrosWrapper\",\"doc\":\"A record wrapping Time-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"long\",\"logicalType\":\"time-micros\"}}]},{\"type\":\"record\",\"name\":\"TimestampMicrosWrapper\",\"doc\":\"A record wrapping Timestamp-micros logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"long\"}]},{\"type\":\"record\",\"name\":\"LocalDateWrapper\",\"doc\":\"A record wrapping Local Date type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":\"int\"}]}],\"doc\":\"Minimum value in the range. Based on user data table schema, we can convert this to appropriate type\",\"default\":null},{\"name\":\"maxValue\",\"type\":[\"null\",\"BooleanWrapper\",\"IntWrapper\",\"LongWrapper\",\"FloatWrapper\",\"DoubleWrapper\",\"BytesWrapper\",\"StringWrapper\",\"DateWrapper\",\"DecimalWrapper\",\"TimeMicrosWrapper\",\"TimestampMicrosWrapper\",\"LocalDateWrapper\"],\"doc\":\"Maximum value in the range. Based on user data table schema, we can convert it to appropriate type\",\"default\":null},{\"name\":\"valueCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of values\",\"default\":null},{\"name\":\"nullCount\",\"type\":[\"null\",\"long\"],\"doc\":\"Total count of null values\",\"default\":null},{\"name\":\"totalSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total storage size on disk\",\"default\":null},{\"name\":\"totalUncompressedSize\",\"type\":[\"null\",\"long\"],\"doc\":\"Total uncompressed storage size on disk\",\"default\":null},{\"name\":\"isDeleted\",\"type\":\"boolean\",\"doc\":\"Column range entry valid/deleted flag\"},{\"name\":\"isTightBound\",\"type\":\"boolean\",\"doc\":\"Whether the min/max range of a column is tight bound or not\",\"default\":false}]}");
  public static org.apache.avro.Schema getClassSchema() { return SCHEMA$; }

  private static final SpecificData MODEL$ = new SpecificData();
  static {
    MODEL$.addLogicalTypeConversion(new org.apache.avro.data.TimeConversions.TimeMicrosConversion());
    MODEL$.addLogicalTypeConversion(new org.apache.avro.Conversions.DecimalConversion());
  }

  private static final BinaryMessageEncoder<HoodieMetadataColumnStats> ENCODER =
      new BinaryMessageEncoder<>(MODEL$, SCHEMA$);

  private static final BinaryMessageDecoder<HoodieMetadataColumnStats> DECODER =
      new BinaryMessageDecoder<>(MODEL$, SCHEMA$);

  /**
   * Return the BinaryMessageEncoder instance used by this class.
   * @return the message encoder used by this class
   */
  public static BinaryMessageEncoder<HoodieMetadataColumnStats> getEncoder() {
    return ENCODER;
  }

  /**
   * Return the BinaryMessageDecoder instance used by this class.
   * @return the message decoder used by this class
   */
  public static BinaryMessageDecoder<HoodieMetadataColumnStats> getDecoder() {
    return DECODER;
  }

  /**
   * Create a new BinaryMessageDecoder instance for this class that uses the specified {@link SchemaStore}.
   * @param resolver a {@link SchemaStore} used to find schemas by fingerprint
   * @return a BinaryMessageDecoder instance for this class backed by the given SchemaStore
   */
  public static BinaryMessageDecoder<HoodieMetadataColumnStats> createDecoder(SchemaStore resolver) {
    return new BinaryMessageDecoder<>(MODEL$, SCHEMA$, resolver);
  }

  /**
   * Serializes this HoodieMetadataColumnStats to a ByteBuffer.
   * @return a buffer holding the serialized data for this instance
   * @throws java.io.IOException if this instance could not be serialized
   */
  public java.nio.ByteBuffer toByteBuffer() throws java.io.IOException {
    return ENCODER.encode(this);
  }

  /**
   * Deserializes a HoodieMetadataColumnStats from a ByteBuffer.
   * @param b a byte buffer holding serialized data for an instance of this class
   * @return a HoodieMetadataColumnStats instance decoded from the given buffer
   * @throws java.io.IOException if the given bytes could not be deserialized into an instance of this class
   */
  public static HoodieMetadataColumnStats fromByteBuffer(
      java.nio.ByteBuffer b) throws java.io.IOException {
    return DECODER.decode(b);
  }

  /** File name for which this column statistics applies */
  private java.lang.String fileName;
  /** Column name for which this column statistics applies */
  private java.lang.String columnName;
  /** Minimum value in the range. Based on user data table schema, we can convert this to appropriate type */
  private java.lang.Object minValue;
  /** Maximum value in the range. Based on user data table schema, we can convert it to appropriate type */
  private java.lang.Object maxValue;
  /** Total count of values */
  private java.lang.Long valueCount;
  /** Total count of null values */
  private java.lang.Long nullCount;
  /** Total storage size on disk */
  private java.lang.Long totalSize;
  /** Total uncompressed storage size on disk */
  private java.lang.Long totalUncompressedSize;
  /** Column range entry valid/deleted flag */
  private boolean isDeleted;
  /** Whether the min/max range of a column is tight bound or not */
  private boolean isTightBound;

  /**
   * Default constructor.  Note that this does not initialize fields
   * to their default values from the schema.  If that is desired then
   * one should use <code>newBuilder()</code>.
   */
  public HoodieMetadataColumnStats() {}

  /**
   * All-args constructor.
   * @param fileName File name for which this column statistics applies
   * @param columnName Column name for which this column statistics applies
   * @param minValue Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
   * @param maxValue Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
   * @param valueCount Total count of values
   * @param nullCount Total count of null values
   * @param totalSize Total storage size on disk
   * @param totalUncompressedSize Total uncompressed storage size on disk
   * @param isDeleted Column range entry valid/deleted flag
   * @param isTightBound Whether the min/max range of a column is tight bound or not
   */
  public HoodieMetadataColumnStats(java.lang.String fileName, java.lang.String columnName, java.lang.Object minValue, java.lang.Object maxValue, java.lang.Long valueCount, java.lang.Long nullCount, java.lang.Long totalSize, java.lang.Long totalUncompressedSize, java.lang.Boolean isDeleted, java.lang.Boolean isTightBound) {
    this.fileName = fileName;
    this.columnName = columnName;
    this.minValue = minValue;
    this.maxValue = maxValue;
    this.valueCount = valueCount;
    this.nullCount = nullCount;
    this.totalSize = totalSize;
    this.totalUncompressedSize = totalUncompressedSize;
    this.isDeleted = isDeleted;
    this.isTightBound = isTightBound;
  }

  @Override
  public org.apache.avro.specific.SpecificData getSpecificData() { return MODEL$; }

  @Override
  public org.apache.avro.Schema getSchema() { return SCHEMA$; }

  // Used by DatumWriter.  Applications should not call.
  @Override
  public java.lang.Object get(int field$) {
    switch (field$) {
    case 0: return fileName;
    case 1: return columnName;
    case 2: return minValue;
    case 3: return maxValue;
    case 4: return valueCount;
    case 5: return nullCount;
    case 6: return totalSize;
    case 7: return totalUncompressedSize;
    case 8: return isDeleted;
    case 9: return isTightBound;
    default: throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }
  }

  // Used by DatumReader.  Applications should not call.
  @Override
  @SuppressWarnings(value="unchecked")
  public void put(int field$, java.lang.Object value$) {
    switch (field$) {
    case 0: fileName = value$ != null ? value$.toString() : null; break;
    case 1: columnName = value$ != null ? value$.toString() : null; break;
    case 2: minValue = value$; break;
    case 3: maxValue = value$; break;
    case 4: valueCount = (java.lang.Long)value$; break;
    case 5: nullCount = (java.lang.Long)value$; break;
    case 6: totalSize = (java.lang.Long)value$; break;
    case 7: totalUncompressedSize = (java.lang.Long)value$; break;
    case 8: isDeleted = (java.lang.Boolean)value$; break;
    case 9: isTightBound = (java.lang.Boolean)value$; break;
    default: throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }
  }

  /**
   * Gets the value of the 'fileName' field.
   * @return File name for which this column statistics applies
   */
  public java.lang.String getFileName() {
    return fileName;
  }


  /**
   * Sets the value of the 'fileName' field.
   * File name for which this column statistics applies
   * @param value the value to set.
   */
  public void setFileName(java.lang.String value) {
    this.fileName = value;
  }

  /**
   * Gets the value of the 'columnName' field.
   * @return Column name for which this column statistics applies
   */
  public java.lang.String getColumnName() {
    return columnName;
  }


  /**
   * Sets the value of the 'columnName' field.
   * Column name for which this column statistics applies
   * @param value the value to set.
   */
  public void setColumnName(java.lang.String value) {
    this.columnName = value;
  }

  /**
   * Gets the value of the 'minValue' field.
   * @return Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
   */
  public java.lang.Object getMinValue() {
    return minValue;
  }


  /**
   * Sets the value of the 'minValue' field.
   * Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
   * @param value the value to set.
   */
  public void setMinValue(java.lang.Object value) {
    this.minValue = value;
  }

  /**
   * Gets the value of the 'maxValue' field.
   * @return Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
   */
  public java.lang.Object getMaxValue() {
    return maxValue;
  }


  /**
   * Sets the value of the 'maxValue' field.
   * Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
   * @param value the value to set.
   */
  public void setMaxValue(java.lang.Object value) {
    this.maxValue = value;
  }

  /**
   * Gets the value of the 'valueCount' field.
   * @return Total count of values
   */
  public java.lang.Long getValueCount() {
    return valueCount;
  }


  /**
   * Sets the value of the 'valueCount' field.
   * Total count of values
   * @param value the value to set.
   */
  public void setValueCount(java.lang.Long value) {
    this.valueCount = value;
  }

  /**
   * Gets the value of the 'nullCount' field.
   * @return Total count of null values
   */
  public java.lang.Long getNullCount() {
    return nullCount;
  }


  /**
   * Sets the value of the 'nullCount' field.
   * Total count of null values
   * @param value the value to set.
   */
  public void setNullCount(java.lang.Long value) {
    this.nullCount = value;
  }

  /**
   * Gets the value of the 'totalSize' field.
   * @return Total storage size on disk
   */
  public java.lang.Long getTotalSize() {
    return totalSize;
  }


  /**
   * Sets the value of the 'totalSize' field.
   * Total storage size on disk
   * @param value the value to set.
   */
  public void setTotalSize(java.lang.Long value) {
    this.totalSize = value;
  }

  /**
   * Gets the value of the 'totalUncompressedSize' field.
   * @return Total uncompressed storage size on disk
   */
  public java.lang.Long getTotalUncompressedSize() {
    return totalUncompressedSize;
  }


  /**
   * Sets the value of the 'totalUncompressedSize' field.
   * Total uncompressed storage size on disk
   * @param value the value to set.
   */
  public void setTotalUncompressedSize(java.lang.Long value) {
    this.totalUncompressedSize = value;
  }

  /**
   * Gets the value of the 'isDeleted' field.
   * @return Column range entry valid/deleted flag
   */
  public boolean getIsDeleted() {
    return isDeleted;
  }


  /**
   * Sets the value of the 'isDeleted' field.
   * Column range entry valid/deleted flag
   * @param value the value to set.
   */
  public void setIsDeleted(boolean value) {
    this.isDeleted = value;
  }

  /**
   * Gets the value of the 'isTightBound' field.
   * @return Whether the min/max range of a column is tight bound or not
   */
  public boolean getIsTightBound() {
    return isTightBound;
  }


  /**
   * Sets the value of the 'isTightBound' field.
   * Whether the min/max range of a column is tight bound or not
   * @param value the value to set.
   */
  public void setIsTightBound(boolean value) {
    this.isTightBound = value;
  }

  /**
   * Creates a new HoodieMetadataColumnStats RecordBuilder.
   * @return A new HoodieMetadataColumnStats RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder newBuilder() {
    return new org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder();
  }

  /**
   * Creates a new HoodieMetadataColumnStats RecordBuilder by copying an existing Builder.
   * @param other The existing builder to copy.
   * @return A new HoodieMetadataColumnStats RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder newBuilder(org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder other) {
    if (other == null) {
      return new org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder();
    } else {
      return new org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder(other);
    }
  }

  /**
   * Creates a new HoodieMetadataColumnStats RecordBuilder by copying an existing HoodieMetadataColumnStats instance.
   * @param other The existing instance to copy.
   * @return A new HoodieMetadataColumnStats RecordBuilder
   */
  public static org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder newBuilder(org.apache.hudi.avro.model.HoodieMetadataColumnStats other) {
    if (other == null) {
      return new org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder();
    } else {
      return new org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder(other);
    }
  }

  /**
   * RecordBuilder for HoodieMetadataColumnStats instances.
   */
  @org.apache.avro.specific.AvroGenerated
  public static class Builder extends org.apache.avro.specific.SpecificRecordBuilderBase<HoodieMetadataColumnStats>
    implements org.apache.avro.data.RecordBuilder<HoodieMetadataColumnStats> {

    /** File name for which this column statistics applies */
    private java.lang.String fileName;
    /** Column name for which this column statistics applies */
    private java.lang.String columnName;
    /** Minimum value in the range. Based on user data table schema, we can convert this to appropriate type */
    private java.lang.Object minValue;
    /** Maximum value in the range. Based on user data table schema, we can convert it to appropriate type */
    private java.lang.Object maxValue;
    /** Total count of values */
    private java.lang.Long valueCount;
    /** Total count of null values */
    private java.lang.Long nullCount;
    /** Total storage size on disk */
    private java.lang.Long totalSize;
    /** Total uncompressed storage size on disk */
    private java.lang.Long totalUncompressedSize;
    /** Column range entry valid/deleted flag */
    private boolean isDeleted;
    /** Whether the min/max range of a column is tight bound or not */
    private boolean isTightBound;

    /** Creates a new Builder */
    private Builder() {
      super(SCHEMA$, MODEL$);
    }

    /**
     * Creates a Builder by copying an existing Builder.
     * @param other The existing Builder to copy.
     */
    private Builder(org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder other) {
      super(other);
      if (isValidValue(fields()[0], other.fileName)) {
        this.fileName = data().deepCopy(fields()[0].schema(), other.fileName);
        fieldSetFlags()[0] = other.fieldSetFlags()[0];
      }
      if (isValidValue(fields()[1], other.columnName)) {
        this.columnName = data().deepCopy(fields()[1].schema(), other.columnName);
        fieldSetFlags()[1] = other.fieldSetFlags()[1];
      }
      if (isValidValue(fields()[2], other.minValue)) {
        this.minValue = data().deepCopy(fields()[2].schema(), other.minValue);
        fieldSetFlags()[2] = other.fieldSetFlags()[2];
      }
      if (isValidValue(fields()[3], other.maxValue)) {
        this.maxValue = data().deepCopy(fields()[3].schema(), other.maxValue);
        fieldSetFlags()[3] = other.fieldSetFlags()[3];
      }
      if (isValidValue(fields()[4], other.valueCount)) {
        this.valueCount = data().deepCopy(fields()[4].schema(), other.valueCount);
        fieldSetFlags()[4] = other.fieldSetFlags()[4];
      }
      if (isValidValue(fields()[5], other.nullCount)) {
        this.nullCount = data().deepCopy(fields()[5].schema(), other.nullCount);
        fieldSetFlags()[5] = other.fieldSetFlags()[5];
      }
      if (isValidValue(fields()[6], other.totalSize)) {
        this.totalSize = data().deepCopy(fields()[6].schema(), other.totalSize);
        fieldSetFlags()[6] = other.fieldSetFlags()[6];
      }
      if (isValidValue(fields()[7], other.totalUncompressedSize)) {
        this.totalUncompressedSize = data().deepCopy(fields()[7].schema(), other.totalUncompressedSize);
        fieldSetFlags()[7] = other.fieldSetFlags()[7];
      }
      if (isValidValue(fields()[8], other.isDeleted)) {
        this.isDeleted = data().deepCopy(fields()[8].schema(), other.isDeleted);
        fieldSetFlags()[8] = other.fieldSetFlags()[8];
      }
      if (isValidValue(fields()[9], other.isTightBound)) {
        this.isTightBound = data().deepCopy(fields()[9].schema(), other.isTightBound);
        fieldSetFlags()[9] = other.fieldSetFlags()[9];
      }
    }

    /**
     * Creates a Builder by copying an existing HoodieMetadataColumnStats instance
     * @param other The existing instance to copy.
     */
    private Builder(org.apache.hudi.avro.model.HoodieMetadataColumnStats other) {
      super(SCHEMA$, MODEL$);
      if (isValidValue(fields()[0], other.fileName)) {
        this.fileName = data().deepCopy(fields()[0].schema(), other.fileName);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.columnName)) {
        this.columnName = data().deepCopy(fields()[1].schema(), other.columnName);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.minValue)) {
        this.minValue = data().deepCopy(fields()[2].schema(), other.minValue);
        fieldSetFlags()[2] = true;
      }
      if (isValidValue(fields()[3], other.maxValue)) {
        this.maxValue = data().deepCopy(fields()[3].schema(), other.maxValue);
        fieldSetFlags()[3] = true;
      }
      if (isValidValue(fields()[4], other.valueCount)) {
        this.valueCount = data().deepCopy(fields()[4].schema(), other.valueCount);
        fieldSetFlags()[4] = true;
      }
      if (isValidValue(fields()[5], other.nullCount)) {
        this.nullCount = data().deepCopy(fields()[5].schema(), other.nullCount);
        fieldSetFlags()[5] = true;
      }
      if (isValidValue(fields()[6], other.totalSize)) {
        this.totalSize = data().deepCopy(fields()[6].schema(), other.totalSize);
        fieldSetFlags()[6] = true;
      }
      if (isValidValue(fields()[7], other.totalUncompressedSize)) {
        this.totalUncompressedSize = data().deepCopy(fields()[7].schema(), other.totalUncompressedSize);
        fieldSetFlags()[7] = true;
      }
      if (isValidValue(fields()[8], other.isDeleted)) {
        this.isDeleted = data().deepCopy(fields()[8].schema(), other.isDeleted);
        fieldSetFlags()[8] = true;
      }
      if (isValidValue(fields()[9], other.isTightBound)) {
        this.isTightBound = data().deepCopy(fields()[9].schema(), other.isTightBound);
        fieldSetFlags()[9] = true;
      }
    }

    /**
      * Gets the value of the 'fileName' field.
      * File name for which this column statistics applies
      * @return The value.
      */
    public java.lang.String getFileName() {
      return fileName;
    }


    /**
      * Sets the value of the 'fileName' field.
      * File name for which this column statistics applies
      * @param value The value of 'fileName'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setFileName(java.lang.String value) {
      validate(fields()[0], value);
      this.fileName = value;
      fieldSetFlags()[0] = true;
      return this;
    }

    /**
      * Checks whether the 'fileName' field has been set.
      * File name for which this column statistics applies
      * @return True if the 'fileName' field has been set, false otherwise.
      */
    public boolean hasFileName() {
      return fieldSetFlags()[0];
    }


    /**
      * Clears the value of the 'fileName' field.
      * File name for which this column statistics applies
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearFileName() {
      fileName = null;
      fieldSetFlags()[0] = false;
      return this;
    }

    /**
      * Gets the value of the 'columnName' field.
      * Column name for which this column statistics applies
      * @return The value.
      */
    public java.lang.String getColumnName() {
      return columnName;
    }


    /**
      * Sets the value of the 'columnName' field.
      * Column name for which this column statistics applies
      * @param value The value of 'columnName'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setColumnName(java.lang.String value) {
      validate(fields()[1], value);
      this.columnName = value;
      fieldSetFlags()[1] = true;
      return this;
    }

    /**
      * Checks whether the 'columnName' field has been set.
      * Column name for which this column statistics applies
      * @return True if the 'columnName' field has been set, false otherwise.
      */
    public boolean hasColumnName() {
      return fieldSetFlags()[1];
    }


    /**
      * Clears the value of the 'columnName' field.
      * Column name for which this column statistics applies
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearColumnName() {
      columnName = null;
      fieldSetFlags()[1] = false;
      return this;
    }

    /**
      * Gets the value of the 'minValue' field.
      * Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
      * @return The value.
      */
    public java.lang.Object getMinValue() {
      return minValue;
    }


    /**
      * Sets the value of the 'minValue' field.
      * Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
      * @param value The value of 'minValue'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setMinValue(java.lang.Object value) {
      validate(fields()[2], value);
      this.minValue = value;
      fieldSetFlags()[2] = true;
      return this;
    }

    /**
      * Checks whether the 'minValue' field has been set.
      * Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
      * @return True if the 'minValue' field has been set, false otherwise.
      */
    public boolean hasMinValue() {
      return fieldSetFlags()[2];
    }


    /**
      * Clears the value of the 'minValue' field.
      * Minimum value in the range. Based on user data table schema, we can convert this to appropriate type
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearMinValue() {
      minValue = null;
      fieldSetFlags()[2] = false;
      return this;
    }

    /**
      * Gets the value of the 'maxValue' field.
      * Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
      * @return The value.
      */
    public java.lang.Object getMaxValue() {
      return maxValue;
    }


    /**
      * Sets the value of the 'maxValue' field.
      * Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
      * @param value The value of 'maxValue'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setMaxValue(java.lang.Object value) {
      validate(fields()[3], value);
      this.maxValue = value;
      fieldSetFlags()[3] = true;
      return this;
    }

    /**
      * Checks whether the 'maxValue' field has been set.
      * Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
      * @return True if the 'maxValue' field has been set, false otherwise.
      */
    public boolean hasMaxValue() {
      return fieldSetFlags()[3];
    }


    /**
      * Clears the value of the 'maxValue' field.
      * Maximum value in the range. Based on user data table schema, we can convert it to appropriate type
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearMaxValue() {
      maxValue = null;
      fieldSetFlags()[3] = false;
      return this;
    }

    /**
      * Gets the value of the 'valueCount' field.
      * Total count of values
      * @return The value.
      */
    public java.lang.Long getValueCount() {
      return valueCount;
    }


    /**
      * Sets the value of the 'valueCount' field.
      * Total count of values
      * @param value The value of 'valueCount'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setValueCount(java.lang.Long value) {
      validate(fields()[4], value);
      this.valueCount = value;
      fieldSetFlags()[4] = true;
      return this;
    }

    /**
      * Checks whether the 'valueCount' field has been set.
      * Total count of values
      * @return True if the 'valueCount' field has been set, false otherwise.
      */
    public boolean hasValueCount() {
      return fieldSetFlags()[4];
    }


    /**
      * Clears the value of the 'valueCount' field.
      * Total count of values
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearValueCount() {
      valueCount = null;
      fieldSetFlags()[4] = false;
      return this;
    }

    /**
      * Gets the value of the 'nullCount' field.
      * Total count of null values
      * @return The value.
      */
    public java.lang.Long getNullCount() {
      return nullCount;
    }


    /**
      * Sets the value of the 'nullCount' field.
      * Total count of null values
      * @param value The value of 'nullCount'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setNullCount(java.lang.Long value) {
      validate(fields()[5], value);
      this.nullCount = value;
      fieldSetFlags()[5] = true;
      return this;
    }

    /**
      * Checks whether the 'nullCount' field has been set.
      * Total count of null values
      * @return True if the 'nullCount' field has been set, false otherwise.
      */
    public boolean hasNullCount() {
      return fieldSetFlags()[5];
    }


    /**
      * Clears the value of the 'nullCount' field.
      * Total count of null values
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearNullCount() {
      nullCount = null;
      fieldSetFlags()[5] = false;
      return this;
    }

    /**
      * Gets the value of the 'totalSize' field.
      * Total storage size on disk
      * @return The value.
      */
    public java.lang.Long getTotalSize() {
      return totalSize;
    }


    /**
      * Sets the value of the 'totalSize' field.
      * Total storage size on disk
      * @param value The value of 'totalSize'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setTotalSize(java.lang.Long value) {
      validate(fields()[6], value);
      this.totalSize = value;
      fieldSetFlags()[6] = true;
      return this;
    }

    /**
      * Checks whether the 'totalSize' field has been set.
      * Total storage size on disk
      * @return True if the 'totalSize' field has been set, false otherwise.
      */
    public boolean hasTotalSize() {
      return fieldSetFlags()[6];
    }


    /**
      * Clears the value of the 'totalSize' field.
      * Total storage size on disk
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearTotalSize() {
      totalSize = null;
      fieldSetFlags()[6] = false;
      return this;
    }

    /**
      * Gets the value of the 'totalUncompressedSize' field.
      * Total uncompressed storage size on disk
      * @return The value.
      */
    public java.lang.Long getTotalUncompressedSize() {
      return totalUncompressedSize;
    }


    /**
      * Sets the value of the 'totalUncompressedSize' field.
      * Total uncompressed storage size on disk
      * @param value The value of 'totalUncompressedSize'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setTotalUncompressedSize(java.lang.Long value) {
      validate(fields()[7], value);
      this.totalUncompressedSize = value;
      fieldSetFlags()[7] = true;
      return this;
    }

    /**
      * Checks whether the 'totalUncompressedSize' field has been set.
      * Total uncompressed storage size on disk
      * @return True if the 'totalUncompressedSize' field has been set, false otherwise.
      */
    public boolean hasTotalUncompressedSize() {
      return fieldSetFlags()[7];
    }


    /**
      * Clears the value of the 'totalUncompressedSize' field.
      * Total uncompressed storage size on disk
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearTotalUncompressedSize() {
      totalUncompressedSize = null;
      fieldSetFlags()[7] = false;
      return this;
    }

    /**
      * Gets the value of the 'isDeleted' field.
      * Column range entry valid/deleted flag
      * @return The value.
      */
    public boolean getIsDeleted() {
      return isDeleted;
    }


    /**
      * Sets the value of the 'isDeleted' field.
      * Column range entry valid/deleted flag
      * @param value The value of 'isDeleted'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setIsDeleted(boolean value) {
      validate(fields()[8], value);
      this.isDeleted = value;
      fieldSetFlags()[8] = true;
      return this;
    }

    /**
      * Checks whether the 'isDeleted' field has been set.
      * Column range entry valid/deleted flag
      * @return True if the 'isDeleted' field has been set, false otherwise.
      */
    public boolean hasIsDeleted() {
      return fieldSetFlags()[8];
    }


    /**
      * Clears the value of the 'isDeleted' field.
      * Column range entry valid/deleted flag
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearIsDeleted() {
      fieldSetFlags()[8] = false;
      return this;
    }

    /**
      * Gets the value of the 'isTightBound' field.
      * Whether the min/max range of a column is tight bound or not
      * @return The value.
      */
    public boolean getIsTightBound() {
      return isTightBound;
    }


    /**
      * Sets the value of the 'isTightBound' field.
      * Whether the min/max range of a column is tight bound or not
      * @param value The value of 'isTightBound'.
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder setIsTightBound(boolean value) {
      validate(fields()[9], value);
      this.isTightBound = value;
      fieldSetFlags()[9] = true;
      return this;
    }

    /**
      * Checks whether the 'isTightBound' field has been set.
      * Whether the min/max range of a column is tight bound or not
      * @return True if the 'isTightBound' field has been set, false otherwise.
      */
    public boolean hasIsTightBound() {
      return fieldSetFlags()[9];
    }


    /**
      * Clears the value of the 'isTightBound' field.
      * Whether the min/max range of a column is tight bound or not
      * @return This builder.
      */
    public org.apache.hudi.avro.model.HoodieMetadataColumnStats.Builder clearIsTightBound() {
      fieldSetFlags()[9] = false;
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    public HoodieMetadataColumnStats build() {
      try {
        HoodieMetadataColumnStats record = new HoodieMetadataColumnStats();
        record.fileName = fieldSetFlags()[0] ? this.fileName : (java.lang.String) defaultValue(fields()[0]);
        record.columnName = fieldSetFlags()[1] ? this.columnName : (java.lang.String) defaultValue(fields()[1]);
        record.minValue = fieldSetFlags()[2] ? this.minValue :  defaultValue(fields()[2]);
        record.maxValue = fieldSetFlags()[3] ? this.maxValue :  defaultValue(fields()[3]);
        record.valueCount = fieldSetFlags()[4] ? this.valueCount : (java.lang.Long) defaultValue(fields()[4]);
        record.nullCount = fieldSetFlags()[5] ? this.nullCount : (java.lang.Long) defaultValue(fields()[5]);
        record.totalSize = fieldSetFlags()[6] ? this.totalSize : (java.lang.Long) defaultValue(fields()[6]);
        record.totalUncompressedSize = fieldSetFlags()[7] ? this.totalUncompressedSize : (java.lang.Long) defaultValue(fields()[7]);
        record.isDeleted = fieldSetFlags()[8] ? this.isDeleted : (java.lang.Boolean) defaultValue(fields()[8]);
        record.isTightBound = fieldSetFlags()[9] ? this.isTightBound : (java.lang.Boolean) defaultValue(fields()[9]);
        return record;
      } catch (org.apache.avro.AvroMissingFieldException e) {
        throw e;
      } catch (java.lang.Exception e) {
        throw new org.apache.avro.AvroRuntimeException(e);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumWriter<HoodieMetadataColumnStats>
    WRITER$ = (org.apache.avro.io.DatumWriter<HoodieMetadataColumnStats>)MODEL$.createDatumWriter(SCHEMA$);

  @Override public void writeExternal(java.io.ObjectOutput out)
    throws java.io.IOException {
    WRITER$.write(this, SpecificData.getEncoder(out));
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumReader<HoodieMetadataColumnStats>
    READER$ = (org.apache.avro.io.DatumReader<HoodieMetadataColumnStats>)MODEL$.createDatumReader(SCHEMA$);

  @Override public void readExternal(java.io.ObjectInput in)
    throws java.io.IOException {
    READER$.read(this, SpecificData.getDecoder(in));
  }

}










