/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.jupiter.params.provider.Arguments;

public class MercifulJsonConverterTestBase {
    private static final String DECIMAL_AVRO_FILE_INVALID_PATH = "/decimal-logical-type-invalid.avsc";
    protected static final String DECIMAL_AVRO_FILE_PATH = "/decimal-logical-type.avsc";
    private static final String DECIMAL_FIXED_AVRO_FILE_PATH = "/decimal-logical-type-fixed-type.avsc";
    protected static final String DECIMAL_ZERO_SCALE_AVRO_FILE_PATH = "/decimal-logical-type-zero-scale.avsc";
    private static final String LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH = "/local-timestamp-micros-logical-type.avsc";
    private static final String LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH = "/local-timestamp-millis-logical-type.avsc";
    private static final String DURATION_AVRO_FILE_PATH_INVALID = "/duration-logical-type-invalid.avsc";
    protected static final String DURATION_AVRO_FILE_PATH = "/duration-logical-type.avsc";
    protected static final String DATE_AVRO_FILE_PATH = "/date-type.avsc";
    private static final String DATE_AVRO_INVALID_FILE_PATH = "/date-type-invalid.avsc";
    protected static final String TIMESTAMP_AVRO_FILE_PATH = "/timestamp-logical-type2.avsc";

    static Stream<Object> decimalBadCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_INVALID_PATH, "123.45", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "123333.45", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, null, 123333.45, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "1233", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, null, 1233.0, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "0.222", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, null, 0.222, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "NotAValidString", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "-", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, null, null, true}));
    }

    static Stream<Object> decimalGoodCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "123.45", "123.45", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "123.45", null, 123.45, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "-999.99", "-999.99", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "999.99", null, 999.99, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "0", null, 0.0, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "0", "0", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_AVRO_FILE_PATH, "0", "000.00", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "123.45", "123.45", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "123.45", null, 123.45, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "-999.99", "-999.99", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "999.99", null, 999.99, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "999", null, 999, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "999", null, 999L, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "999", null, (short)999, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "100", null, (byte)100, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "0", null, 0.0, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "0", null, 0, false}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "0", "0", null, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "0", "000.00", null, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "123.45", null, null, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "123.45", null, 123.45, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "-999.99", null, null, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "999.99", null, 999.99, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "0", null, null, true}), Arguments.of((Object[])new Object[]{DECIMAL_FIXED_AVRO_FILE_PATH, "0", null, null, true}), Arguments.of((Object[])new Object[]{DECIMAL_ZERO_SCALE_AVRO_FILE_PATH, "12345", "12345.0", null, false}), Arguments.of((Object[])new Object[]{DECIMAL_ZERO_SCALE_AVRO_FILE_PATH, "12345", null, 12345.0, false}), Arguments.of((Object[])new Object[]{DECIMAL_ZERO_SCALE_AVRO_FILE_PATH, "12345", null, 12345, false}), Arguments.of((Object[])new Object[]{DECIMAL_ZERO_SCALE_AVRO_FILE_PATH, "1230", null, 1230.0, false}), Arguments.of((Object[])new Object[]{DECIMAL_ZERO_SCALE_AVRO_FILE_PATH, "1230", "1.23e+3", null, false}));
    }

    static Stream<Object> zeroScaleDecimalCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"0.0", "0", true}), Arguments.of((Object[])new Object[]{"20.0", "20", true}), Arguments.of((Object[])new Object[]{"320", "320", true}), Arguments.of((Object[])new Object[]{"320.00", "320", true}), Arguments.of((Object[])new Object[]{"-1320.00", "-1320", true}), Arguments.of((Object[])new Object[]{"1520423524459", "1520423524459", true}), Arguments.of((Object[])new Object[]{"1520423524459.0", "1520423524459", true}), Arguments.of((Object[])new Object[]{"1000000000000000.0", "1000000000000000", true}), Arguments.of((Object[])new Object[]{"1.2684037455962608e+16", "12684037455962608", true}), Arguments.of((Object[])new Object[]{"4.0100001e+16", "40100001000000000", true}), Arguments.of((Object[])new Object[]{"3.52838e+17", "352838000000000000", true}), Arguments.of((Object[])new Object[]{"9223372036853999600.0000", "9223372036853999600", true}), Arguments.of((Object[])new Object[]{"999998887654321000000000000000.0000", "999998887654321000000000000000", true}), Arguments.of((Object[])new Object[]{"-999998887654321000000000000000.0000", "-999998887654321000000000000000", true}), Arguments.of((Object[])new Object[]{"3.781239258857277e+16", "37812392588572770", true}), Arguments.of((Object[])new Object[]{"1.6585135379127473e+18", "1658513537912747300", true}), Arguments.of((Object[])new Object[]{"0.0001", null, false}), Arguments.of((Object[])new Object[]{"300.9999", null, false}), Arguments.of((Object[])new Object[]{"1928943043.0001", null, false}));
    }

    static Stream<Object> durationGoodCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{1, 2, 3}), Arguments.of((Object[])new Object[]{-1, -2, -3}), Arguments.of((Object[])new Object[]{-1, -1, -1}), Arguments.of((Object[])new Object[]{0, 0, 0}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}));
    }

    static Stream<Object> durationBadCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{DURATION_AVRO_FILE_PATH, Arrays.asList(Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE)}), Arguments.of((Object[])new Object[]{DURATION_AVRO_FILE_PATH, Arrays.asList(1, 2, 3, 4)}), Arguments.of((Object[])new Object[]{DURATION_AVRO_FILE_PATH, Arrays.asList(1, 2)}), Arguments.of((Object[])new Object[]{DURATION_AVRO_FILE_PATH, new int[0]}), Arguments.of((Object[])new Object[]{DURATION_AVRO_FILE_PATH, "InvalidString"}), Arguments.of((Object[])new Object[]{DURATION_AVRO_FILE_PATH_INVALID, Arrays.asList(1, 2, 3)}));
    }

    static Stream<Object> dateGoodCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{18506, 18506}), Arguments.of((Object[])new Object[]{18506, "2020-09-01"}), Arguments.of((Object[])new Object[]{7323356, "+22020-09-01"}), Arguments.of((Object[])new Object[]{18506, "18506"}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, Integer.toString(Integer.MAX_VALUE)}), Arguments.of((Object[])new Object[]{Integer.MIN_VALUE, Integer.toString(Integer.MIN_VALUE)}));
    }

    static Stream<Object> dateBadCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{DATE_AVRO_INVALID_FILE_PATH, 18506}), Arguments.of((Object[])new Object[]{DATE_AVRO_FILE_PATH, "#$@#%$@$%#@"}), Arguments.of((Object[])new Object[]{DATE_AVRO_FILE_PATH, "22020-09-01000"}), Arguments.of((Object[])new Object[]{DATE_AVRO_FILE_PATH, "2020-02-45"}), Arguments.of((Object[])new Object[]{DATE_AVRO_FILE_PATH, Arrays.asList(1, 2, 3)}));
    }

    static Stream<Object> localTimestampGoodCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13T23:53:36.004", "2024-05-13T23:53:36.004"}), Arguments.of((Object[])new Object[]{1715644416000000L, "2024-05-13T23:53:36", "2024-05-13T23:53:36"}), Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13 23:53:36.004", "2024-05-13 23:53:36.004"}), Arguments.of((Object[])new Object[]{1715644416000000L, "2024-05-13 23:53:36", "2024-05-13 23:53:36"}), Arguments.of((Object[])new Object[]{2024L, "2", "2024"}), Arguments.of((Object[])new Object[]{1715644416004000L, 1715644416004L, 1715644416004000L}), Arguments.of((Object[])new Object[]{1715644416004000L, 1715644416004L, Long.toString(1715644416004000L)}), Arguments.of((Object[])new Object[]{1715644416000004L, "2024-05-13T23:53:36.000", "2024-05-13T23:53:36.000004"}), Arguments.of((Object[])new Object[]{1715644416000004L, "2024-05-13 23:53:36.000", "2024-05-13 23:53:36.000004"}), Arguments.of((Object[])new Object[]{0L, "1970-01-01T00:00:00.000", "1970-01-01T00:00:00.000000"}), Arguments.of((Object[])new Object[]{0L, "1970-01-01 00:00:00.000", "1970-01-01 00:00:00.000000"}), Arguments.of((Object[])new Object[]{Long.MAX_VALUE, "+294247-01-10T04:00:54.775", "+294247-01-10T04:00:54.775807"}), Arguments.of((Object[])new Object[]{Long.MAX_VALUE, "+294247-01-10 04:00:54.775", "+294247-01-10 04:00:54.775807"}), Arguments.of((Object[])new Object[]{0L, 0L, 0L}), Arguments.of((Object[])new Object[]{-1000L, -1L, -1000L}), Arguments.of((Object[])new Object[]{Long.MIN_VALUE, -9223372036854775L, Long.MIN_VALUE}), Arguments.of((Object[])new Object[]{Long.MAX_VALUE, 9223372036854775L, Long.MAX_VALUE}), Arguments.of((Object[])new Object[]{-62167219200000000L, "0000-01-01T00:00:00.00000", "0000-01-01T00:00:00.00000"}), Arguments.of((Object[])new Object[]{-62167219200000000L, -62167219200000L, -62167219200000000L}), Arguments.of((Object[])new Object[]{-62167219200000000L, "0000-01-01 00:00:00.00000", "0000-01-01 00:00:00.00000"}), Arguments.of((Object[])new Object[]{-62167219200000000L, -62167219200000L, -62167219200000000L}));
    }

    static Stream<Object> localTimestampBadCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-05-1323:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-05-1T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-05-1 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-0-13T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-0-13 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "20242-05-13T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "20242-05-13 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "202-05-13T23:53:36.0000000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "202-05-13 23:53:36.0000000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "202-05-13T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "202-05-13 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-05-13T23:53:36.000Z"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MILLI_AVRO_FILE_PATH, "2024-05-13 23:53:36.000Z"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-05-1323:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-05-1T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-05-1 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-0-13T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-0-13 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "20242-05-13T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "20242-05-13 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "202-05-13T23:53:36.0000000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "202-05-13 23:53:36.0000000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "202-05-13T23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "202-05-13 23:53:36.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2022-05-13T99:99:99.000"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-05-13T23:53:36.000Z"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-05-13 23:53:36.000Z"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "Not a timestamp at all!"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024 05 13T23:00"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024 05 13 23:00"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2024-05"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2011-12-03T10:15:30+01:00"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2011-12-03 10:15:30+01:00"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2011-12-03T10:15:30[Europe/ Paris]"}), Arguments.of((Object[])new Object[]{LOCAL_TIMESTAMP_MICRO_AVRO_FILE_PATH, "2011-12-03 10:15:30[Europe/ Paris]"}));
    }

    static Stream<Object> timestampGoodCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13T23:53:36.004Z", "2024-05-13T23:53:36.004Z"}), Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13 23:53:36.004Z", "2024-05-13 23:53:36.004Z"}), Arguments.of((Object[])new Object[]{1715644416000000L, "2024-05-13T23:53:36Z", "2024-05-13T23:53:36Z"}), Arguments.of((Object[])new Object[]{1715644416000000L, "2024-05-13 23:53:36Z", "2024-05-13 23:53:36Z"}), Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13T23:53:36.004", "2024-05-13T23:53:36.004"}), Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13 23:53:36.004", "2024-05-13 23:53:36.004"}), Arguments.of((Object[])new Object[]{1715637216000000L, "2024-05-13T23:53:36+02:00", "2024-05-13T23:53:36+02:00"}), Arguments.of((Object[])new Object[]{1715637216000000L, "2024-05-13 23:53:36+02:00", "2024-05-13 23:53:36+02:00"}), Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13T23:53:36.004+00:00", "2024-05-13T23:53:36.004+00:00"}), Arguments.of((Object[])new Object[]{1715644416004000L, "2024-05-13 23:53:36.004+00:00", "2024-05-13 23:53:36.004+00:00"}), Arguments.of((Object[])new Object[]{1715633616004000L, "2024-05-13T23:53:36.004+03:00", "2024-05-13T23:53:36.004+03:00"}), Arguments.of((Object[])new Object[]{1715633616004000L, "2024-05-13 23:53:36.004+03:00", "2024-05-13 23:53:36.004+03:00"}), Arguments.of((Object[])new Object[]{1715666016004000L, "2024-05-13T23:53:36.004-06:00", "2024-05-13T23:53:36.004-06:00"}), Arguments.of((Object[])new Object[]{1715666016004000L, "2024-05-13 23:53:36.004-06:00", "2024-05-13 23:53:36.004-06:00"}), Arguments.of((Object[])new Object[]{1715675016004000L, "2024-05-13T23:53:36.004-08:30", "2024-05-13T23:53:36.004-08:30"}), Arguments.of((Object[])new Object[]{1715675016004000L, "2024-05-13 23:53:36.004-08:30", "2024-05-13 23:53:36.004-08:30"}), Arguments.of((Object[])new Object[]{2024L, "2", "2024"}), Arguments.of((Object[])new Object[]{1715644416004000L, 1715644416004L, 1715644416004000L}), Arguments.of((Object[])new Object[]{1715644416004000L, 1715644416004L, Long.toString(1715644416004000L)}), Arguments.of((Object[])new Object[]{1715644416000004L, "2024-05-13T23:53:36.000Z", "2024-05-13T23:53:36.000004Z"}), Arguments.of((Object[])new Object[]{1715644416000004L, "2024-05-13 23:53:36.000Z", "2024-05-13 23:53:36.000004Z"}), Arguments.of((Object[])new Object[]{1715653416000004L, "2024-05-13T23:53:36.000-02:30", "2024-05-13T23:53:36.000004-02:30"}), Arguments.of((Object[])new Object[]{1715653416000004L, "2024-05-13 23:53:36.000-02:30", "2024-05-13 23:53:36.000004-02:30"}), Arguments.of((Object[])new Object[]{0L, "1970-01-01T00:00:00.000Z", "1970-01-01T00:00:00.000000Z"}), Arguments.of((Object[])new Object[]{-3600000000L, "1970-01-01T00:00:00.000+01:00", "1970-01-01T00:00:00.000000+01:00"}), Arguments.of((Object[])new Object[]{0L, 0L, 0L}), Arguments.of((Object[])new Object[]{-1000L, -1L, -1000L}), Arguments.of((Object[])new Object[]{Long.MAX_VALUE, 9223372036854775L, Long.MAX_VALUE}), Arguments.of((Object[])new Object[]{-62167219200000000L, -62167219200000L, -62167219200000000L}));
    }

    static Stream<Object> timestampBadCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{TIMESTAMP_AVRO_FILE_PATH, "2024-05-1323:53:36.000"}), Arguments.of((Object[])new Object[]{TIMESTAMP_AVRO_FILE_PATH, "2024-05-1323:99:99.000Z"}), Arguments.of((Object[])new Object[]{TIMESTAMP_AVRO_FILE_PATH, "2024-05-1323:53:36.000 UTC"}), Arguments.of((Object[])new Object[]{TIMESTAMP_AVRO_FILE_PATH, "Tue, 3 Jun 2008 11:05:30 GMT"}));
    }

    static Stream<Object> timeGoodCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{45000000000L, 45000000, 45000000000L}), Arguments.of((Object[])new Object[]{45000000000L, Integer.toString(45000000), Long.toString(45000000000L)}), Arguments.of((Object[])new Object[]{45000000000L, "12:30:00", "12:30:00"}), Arguments.of((Object[])new Object[]{45000001000L, "12:30:00.001", "12:30:00.001"}), Arguments.of((Object[])new Object[]{0L, "00:00:00.000", "00:00:00.00000"}), Arguments.of((Object[])new Object[]{86399999990L, "23:59:59.999", "23:59:59.99999"}), Arguments.of((Object[])new Object[]{Integer.MAX_VALUE, 2147483, Integer.MAX_VALUE}), Arguments.of((Object[])new Object[]{Integer.MIN_VALUE, -2147483, Integer.MIN_VALUE}));
    }

    static Stream<Object> timeBadCaseProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{"00:0"}), Arguments.of((Object[])new Object[]{"00:00:99"}));
    }

    static Stream<Object> uuidDimension() {
        return Stream.of(UUID.randomUUID().toString(), "", "NotAnUUID");
    }

    static Stream<Object> dateProviderForRow() {
        return Stream.of(Arguments.of((Object[])new Object[]{"2020-09-01", 18506}), Arguments.of((Object[])new Object[]{"2020-09-01", "2020-09-01"}), Arguments.of((Object[])new Object[]{null, "+22020-09-01"}), Arguments.of((Object[])new Object[]{"2020-09-01", "18506"}), Arguments.of((Object[])new Object[]{null, Integer.toString(Integer.MAX_VALUE)}), Arguments.of((Object[])new Object[]{null, Integer.toString(Integer.MIN_VALUE)}));
    }

    static Stream<Object> dataNestedJsonAsString() {
        return Stream.of("{\"first\":\"John\",\"last\":\"Smith\"}", "[{\"first\":\"John\",\"last\":\"Smith\"}]", "{\"first\":\"John\",\"last\":\"Smith\",\"suffix\":3}");
    }

    static Stream<Object> nestedRecord() {
        return Stream.of(Arguments.of((Object[])new Object[]{"abc@xyz.com", true}), Arguments.of((Object[])new Object[]{"{\"primary\":\"def@xyz.com\"}", false}));
    }

    static Stream<Object> encodedDecimalScalePrecisionProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{6, 10}), Arguments.of((Object[])new Object[]{30, 32}), Arguments.of((Object[])new Object[]{1, 3}));
    }

    static Stream<Object> encodedDecimalFixedScalePrecisionProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{5, 6, 10}), Arguments.of((Object[])new Object[]{14, 30, 32}), Arguments.of((Object[])new Object[]{2, 1, 3}));
    }
}

