/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Random;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.avro.MercifulJsonConverterTestBase;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.exception.HoodieJsonToAvroConversionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestMercifulJsonConverter
extends MercifulJsonConverterTestBase {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final MercifulJsonConverter CONVERTER = new MercifulJsonConverter(true, "__");
    private static final String LOCAL_TIME_AVRO_FILE_PATH = "/local-timestamp-logical-type.avsc";
    private static final String TIME_AVRO_FILE_PATH = "/time-logical-type.avsc";
    private static final String UUID_AVRO_FILE_PATH = "/uuid-logical-type.avsc";

    @Test
    public void basicConversion() throws IOException {
        Schema simpleSchema = SchemaTestUtil.getSimpleSchema();
        String name = "John Smith";
        int number = 1337;
        String color = "Blue. No yellow!";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", name);
        data.put("favorite_number", number);
        data.put("favorite_color", color);
        String json = MAPPER.writeValueAsString(data);
        GenericData.Record rec = new GenericData.Record(simpleSchema);
        rec.put("name", (Object)name);
        rec.put("favorite_number", (Object)number);
        rec.put("favorite_color", (Object)color);
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, simpleSchema));
    }

    @ParameterizedTest
    @MethodSource(value={"dataNestedJsonAsString"})
    void nestedJsonAsString(String nameInput) throws IOException {
        Schema simpleSchema = SchemaTestUtil.getSimpleSchema();
        String json = String.format("{\"name\": %s, \"favorite_number\": 1337, \"favorite_color\": 10}", nameInput);
        GenericData.Record rec = new GenericData.Record(simpleSchema);
        rec.put("name", (Object)nameInput);
        rec.put("favorite_number", (Object)1337);
        rec.put("favorite_color", (Object)"10");
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, simpleSchema));
    }

    @ParameterizedTest
    @MethodSource(value={"decimalBadCases"})
    void decimalLogicalTypeInvalidCaseTest(String avroFile, String strInput, Double numInput, boolean testFixedByteArray) throws IOException {
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(avroFile);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (strInput != null) {
            data.put("decimalField", strInput);
        } else if (numInput != null) {
            data.put("decimalField", numInput);
        } else if (testFixedByteArray) {
            int[] intArray = new int[]{0, 0, 48, 57};
            data.put("decimalField", intArray);
        }
        String json = MAPPER.writeValueAsString(data);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(json, schema));
    }

    @ParameterizedTest
    @MethodSource(value={"decimalGoodCases"})
    void decimalLogicalTypeTest(String avroFilePath, String groundTruth, String strInput, Number numInput, boolean testFixedByteArray) throws IOException {
        BigDecimal bigDecimal = new BigDecimal(groundTruth);
        HashMap<String, Object> data = new HashMap<String, Object>();
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(avroFilePath);
        GenericData.Record record = new GenericData.Record(schema);
        Conversions.DecimalConversion conv = new Conversions.DecimalConversion();
        Schema decimalFieldSchema = schema.getField("decimalField").schema();
        if (strInput != null) {
            data.put("decimalField", strInput);
        } else if (numInput != null) {
            data.put("decimalField", numInput);
        } else if (testFixedByteArray) {
            Schema fieldSchema = schema.getField("decimalField").schema();
            GenericFixed fixedValue = new Conversions.DecimalConversion().toFixed(bigDecimal, fieldSchema, fieldSchema.getLogicalType());
            byte[] byteArray = fixedValue.bytes();
            int[] intArray = new int[byteArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                intArray[i] = byteArray[i] & 0xFF;
            }
            data.put("decimalField", intArray);
        }
        if (avroFilePath.equals("/decimal-logical-type.avsc") || avroFilePath.equals("/decimal-logical-type-zero-scale.avsc")) {
            record.put("decimalField", (Object)conv.toBytes(bigDecimal, decimalFieldSchema, decimalFieldSchema.getLogicalType()));
        } else {
            record.put("decimalField", (Object)conv.toFixed(bigDecimal, decimalFieldSchema, decimalFieldSchema.getLogicalType()));
        }
        String json = MAPPER.writeValueAsString(data);
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)record, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"zeroScaleDecimalCases"})
    void zeroScaleDecimalConversion(String inputValue, String expected, boolean shouldConvert) {
        Schema schema = new Schema.Parser().parse("{\"namespace\": \"example.avro\",\"type\": \"record\",\"name\": \"decimalLogicalType\",\"fields\": [{\"name\": \"decimalField\", \"type\": {\"type\": \"bytes\", \"logicalType\": \"decimal\", \"precision\": 38, \"scale\": 0}}]}");
        String json = String.format("{\"decimalField\":%s}", inputValue);
        if (shouldConvert) {
            GenericData.Record record = new GenericData.Record(schema);
            Conversions.DecimalConversion conv = new Conversions.DecimalConversion();
            Schema decimalFieldSchema = schema.getField("decimalField").schema();
            record.put("decimalField", (Object)conv.toBytes(new BigDecimal(expected), decimalFieldSchema, decimalFieldSchema.getLogicalType()));
            GenericRecord real = CONVERTER.convert(json, schema);
            Assertions.assertEquals((Object)record, (Object)real);
        } else {
            Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(json, schema));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"durationGoodCases"})
    void durationLogicalTypeTest(int months, int days, int milliseconds) throws IOException {
        ArrayList<Integer> num = new ArrayList<Integer>();
        num.add(months);
        num.add(days);
        num.add(milliseconds);
        HashMap<String, ArrayList<Integer>> data = new HashMap<String, ArrayList<Integer>>();
        data.put("duration", num);
        String json = MAPPER.writeValueAsString(data);
        ByteBuffer buffer = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(months);
        buffer.putInt(days);
        buffer.putInt(milliseconds);
        buffer.flip();
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath("/duration-logical-type.avsc");
        GenericData.Record durationRecord = new GenericData.Record(schema);
        durationRecord.put("duration", (Object)new GenericData.Fixed(schema.getField("duration").schema(), buffer.array()));
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)durationRecord, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"durationBadCases"})
    void durationLogicalTypeBadTest(String schemaFile, Object input) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("duration", input);
        String json = MAPPER.writeValueAsString(data);
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(schemaFile);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(json, schema));
    }

    @ParameterizedTest
    @MethodSource(value={"dateGoodCaseProvider"})
    void dateLogicalTypeTest(int groundTruth, Object dateInput) throws IOException {
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath("/date-type.avsc");
        GenericData.Record record = new GenericData.Record(schema);
        record.put("dateField", (Object)groundTruth);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dateField", dateInput);
        String json = MAPPER.writeValueAsString(data);
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)record, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"dateBadCaseProvider"})
    void dateLogicalTypeTest(String schemaFile, Object input) throws IOException {
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(schemaFile);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dateField", input);
        String json = MAPPER.writeValueAsString(data);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(json, schema));
    }

    @ParameterizedTest
    @MethodSource(value={"localTimestampGoodCaseProvider"})
    void localTimestampLogicalTypeGoodCaseTest(Long expectedMicroSecOfDay, Object timeMilli, Object timeMicro) throws IOException {
        long microSecOfDay = expectedMicroSecOfDay;
        long milliSecOfDay = expectedMicroSecOfDay / 1000L;
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(LOCAL_TIME_AVRO_FILE_PATH);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("localTimestampMillisField", (Object)milliSecOfDay);
        record.put("localTimestampMicrosField", (Object)microSecOfDay);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("localTimestampMillisField", timeMilli);
        data.put("localTimestampMicrosField", timeMicro);
        String json = MAPPER.writeValueAsString(data);
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)record, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"localTimestampBadCaseProvider"})
    void localTimestampLogicalTypeBadTest(String schemaFile, Object input) throws IOException {
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(schemaFile);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("timestamp", input);
        String json = MAPPER.writeValueAsString(data);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(json, schema));
    }

    @ParameterizedTest
    @MethodSource(value={"timestampGoodCaseProvider"})
    void timestampLogicalTypeGoodCaseTest(Long expectedMicroSecOfDay, Object timeMilli, Object timeMicro) throws IOException {
        long microSecOfDay = expectedMicroSecOfDay;
        long milliSecOfDay = expectedMicroSecOfDay / 1000L;
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath("/timestamp-logical-type2.avsc");
        GenericData.Record record = new GenericData.Record(schema);
        record.put("timestampMillisField", (Object)milliSecOfDay);
        record.put("timestampMicrosField", (Object)microSecOfDay);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("timestampMillisField", timeMilli);
        data.put("timestampMicrosField", timeMicro);
        String json = MAPPER.writeValueAsString(data);
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)record, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"timestampBadCaseProvider"})
    void timestampLogicalTypeBadTest(Object badInput) throws IOException {
        String validInput = "2024-05-13T23:53:36.000Z";
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath("/timestamp-logical-type2.avsc");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("timestampMillisField", validInput);
        data.put("timestampMicrosField", badInput);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(MAPPER.writeValueAsString((Object)data), schema));
        data.clear();
        data.put("timestampMillisField", badInput);
        data.put("timestampMicrosField", validInput);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(MAPPER.writeValueAsString((Object)data), schema));
    }

    @ParameterizedTest
    @MethodSource(value={"timeGoodCaseProvider"})
    void timeLogicalTypeTest(Long expectedMicroSecOfDay, Object timeMilli, Object timeMicro) throws IOException {
        long microSecOfDay = expectedMicroSecOfDay;
        int milliSecOfDay = (int)(expectedMicroSecOfDay / 1000L);
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(TIME_AVRO_FILE_PATH);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("timeMicroField", (Object)microSecOfDay);
        record.put("timeMillisField", (Object)milliSecOfDay);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("timeMicroField", timeMicro);
        data.put("timeMillisField", timeMilli);
        String json = MAPPER.writeValueAsString(data);
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)record, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"timeBadCaseProvider"})
    void timeLogicalTypeBadCaseTest(Object invalidInput) throws IOException {
        String validInput = "00:00:00";
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(TIME_AVRO_FILE_PATH);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("timeMicroField", validInput);
        data.put("timeMillisField", invalidInput);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(MAPPER.writeValueAsString((Object)data), schema));
        data.clear();
        data.put("timeMicroField", invalidInput);
        data.put("timeMillisField", validInput);
        Assertions.assertThrows(HoodieJsonToAvroConversionException.class, () -> CONVERTER.convert(MAPPER.writeValueAsString((Object)data), schema));
    }

    @ParameterizedTest
    @MethodSource(value={"uuidDimension"})
    void uuidLogicalTypeTest(String uuid) throws IOException {
        Schema schema = SchemaTestUtil.getSchemaFromResourceFilePath(UUID_AVRO_FILE_PATH);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("uuidField", (Object)uuid);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("uuidField", uuid);
        String json = MAPPER.writeValueAsString(data);
        GenericRecord real = CONVERTER.convert(json, schema);
        Assertions.assertEquals((Object)record, (Object)real);
    }

    @ParameterizedTest
    @MethodSource(value={"nestedRecord"})
    void nestedRecordTest(String contactInput, boolean isString) {
        String nestedSchemaStr = "{\"type\":\"record\",\"name\":\"User\",\"fields\":[{\"name\":\"name\",\"type\":\"string\"},{\"name\":\"contact\",\"type\":{\"type\":\"record\",\"name\":\"Contact\",\"fields\":[{\"name\":\"email\",\"type\":\"string\"}]}}]}";
        String json = isString ? String.format("{\"name\":\"Jane Smith\",\"contact\":{\"email\":\"%s\"}}", contactInput) : String.format("{\"name\":\"Jane Smith\",\"contact\":{\"email\":%s}}", contactInput);
        Schema nestedSchema = new Schema.Parser().parse(nestedSchemaStr);
        GenericData.Record userRecord = new GenericData.Record(nestedSchema);
        Schema contactSchema = nestedSchema.getField("contact").schema();
        GenericData.Record contactRecord = new GenericData.Record(contactSchema);
        contactRecord.put("email", (Object)contactInput);
        userRecord.put("name", (Object)"Jane Smith");
        userRecord.put("contact", (Object)contactRecord);
        Assertions.assertEquals((Object)userRecord, (Object)CONVERTER.convert(json, nestedSchema));
    }

    @Test
    public void conversionWithFieldNameSanitization() throws IOException {
        String sanitizedSchemaString = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\", \"fields\": [{\"name\": \"__name\", \"type\": \"string\"}, {\"name\": \"favorite__number\", \"type\": \"int\"}, {\"name\": \"favorite__color__\", \"type\": \"string\"}]}";
        Schema sanitizedSchema = Schema.parse((String)sanitizedSchemaString);
        String name = "John Smith";
        int number = 1337;
        String color = "Blue. No yellow!";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("$name", name);
        data.put("favorite-number", number);
        data.put("favorite.color!", color);
        String json = MAPPER.writeValueAsString(data);
        GenericData.Record rec = new GenericData.Record(sanitizedSchema);
        rec.put("__name", (Object)name);
        rec.put("favorite__number", (Object)number);
        rec.put("favorite__color__", (Object)color);
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, sanitizedSchema));
    }

    @Test
    public void conversionWithFieldNameAliases() throws IOException {
        String schemaStringWithAliases = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\", \"fields\": [{\"name\": \"name\", \"type\": \"string\", \"aliases\": [\"$name\"]}, {\"name\": \"favorite_number\",  \"type\": \"int\", \"aliases\": [\"unused\", \"favorite-number\"]}, {\"name\": \"favorite_color\", \"type\": \"string\", \"aliases\": [\"favorite.color!\"]}, {\"name\": \"unmatched\", \"type\": \"string\", \"default\": \"default_value\"}]}";
        Schema sanitizedSchema = Schema.parse((String)schemaStringWithAliases);
        String name = "John Smith";
        int number = 1337;
        String color = "Blue. No yellow!";
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("$name", name);
        data.put("favorite-number", number);
        data.put("favorite.color!", color);
        String json = MAPPER.writeValueAsString(data);
        GenericData.Record rec = new GenericData.Record(sanitizedSchema);
        rec.put("name", (Object)name);
        rec.put("favorite_number", (Object)number);
        rec.put("favorite_color", (Object)color);
        Assertions.assertEquals((Object)rec, (Object)CONVERTER.convert(json, sanitizedSchema));
    }

    @ParameterizedTest
    @MethodSource(value={"encodedDecimalScalePrecisionProvider"})
    void testEncodedDecimal(int scale, int precision) throws JsonProcessingException {
        Random rand = new Random();
        BigDecimal decfield = BigDecimal.valueOf(rand.nextDouble()).setScale(scale, RoundingMode.HALF_UP).round(new MathContext(precision, RoundingMode.HALF_UP));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("_row_key", "mykey");
        long timestamp = 214523432L;
        data.put("timestamp", timestamp);
        data.put("rider", "myrider");
        data.put("decfield", Base64.getEncoder().encodeToString(decfield.unscaledValue().toByteArray()));
        data.put("driver", "mydriver");
        data.put("fare", rand.nextDouble() * 100.0);
        data.put("_hoodie_is_deleted", false);
        String json = MAPPER.writeValueAsString(data);
        Schema tripSchema = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"decfield\",\"type\":{\"type\":\"bytes\",\"name\":\"abc\",\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\":\"lowprecision\",\"type\":{\"type\":\"bytes\",\"name\":\"def\",\"logicalType\":\"decimal\",\"precision\":4,\"scale\":2}},{\"name\":\"highprecision\",\"type\":{\"type\":\"bytes\",\"name\":\"ghi\",\"logicalType\":\"decimal\",\"precision\":32,\"scale\":12}},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}".replace("6", Integer.toString(scale)).replace("10", Integer.toString(precision)));
        GenericRecord genrec = CONVERTER.convert(json, tripSchema);
        Schema decimalFieldSchema = tripSchema.getField("decfield").schema();
        BigDecimal decoded = HoodieAvroUtils.convertBytesToBigDecimal((byte[])((ByteBuffer)genrec.get("decfield")).array(), (LogicalTypes.Decimal)((LogicalTypes.Decimal)decimalFieldSchema.getLogicalType()));
        Assertions.assertEquals((Object)decfield, (Object)decoded);
    }

    @ParameterizedTest
    @MethodSource(value={"encodedDecimalFixedScalePrecisionProvider"})
    void testEncodedDecimalAvroSparkPostProcessorCase(int size, int scale, int precision) throws JsonProcessingException {
        Random rand = new Random();
        String postProcessSchemaString = String.format("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"\"},{\"name\":\"_row_key\",\"type\":\"string\",\"doc\":\"\"},{\"name\":\"rider\",\"type\":\"string\",\"doc\":\"\"},{\"name\":\"decfield\",\"type\":{\"type\":\"fixed\",\"name\":\"fixed\",\"namespace\":\"tripUberRec.decfield\",\"size\":%d,\"logicalType\":\"decimal\",\"precision\":%d,\"scale\":%d},\"doc\":\"\"},{\"name\":\"driver\",\"type\":\"string\",\"doc\":\"\"},{\"name\":\"fare\",\"type\":\"double\",\"doc\":\"\"},{\"name\":\"_hoodie_is_deleted\",\"type\":\"boolean\",\"doc\":\"\"}]}", size, precision, scale);
        Schema postProcessSchema = new Schema.Parser().parse(postProcessSchemaString);
        BigDecimal decfield = BigDecimal.valueOf(rand.nextDouble()).setScale(scale, RoundingMode.HALF_UP).round(new MathContext(precision, RoundingMode.HALF_UP));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("_row_key", "mykey");
        long timestamp = 214523432L;
        data.put("timestamp", timestamp);
        data.put("rider", "myrider");
        data.put("decfield", Base64.getEncoder().encodeToString(decfield.unscaledValue().toByteArray()));
        data.put("driver", "mydriver");
        data.put("fare", rand.nextDouble() * 100.0);
        data.put("_hoodie_is_deleted", false);
        String json = MAPPER.writeValueAsString(data);
        GenericRecord genrec = CONVERTER.convert(json, postProcessSchema);
        GenericData.Fixed fixed = (GenericData.Fixed)genrec.get("decfield");
        Conversions.DecimalConversion decimalConverter = new Conversions.DecimalConversion();
        Schema decimalFieldSchema = postProcessSchema.getField("decfield").schema();
        Assertions.assertEquals((Object)decfield, (Object)decimalConverter.fromFixed((GenericFixed)fixed, decimalFieldSchema, decimalFieldSchema.getLogicalType()));
    }
}

