/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.util.Properties;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TestConfigProperty;

public class HoodieTestFakeConfig
extends HoodieConfig {
    public static ConfigProperty<String> FAKE_STRING_CONFIG = TestConfigProperty.FAKE_STRING_CONFIG;
    public static ConfigProperty<Integer> FAKE_INTEGER_CONFIG = TestConfigProperty.FAKE_INTEGER_CONFIG;
    public static ConfigProperty<String> FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER = TestConfigProperty.FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER;
    public static ConfigProperty<String> FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY = TestConfigProperty.FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY;

    private HoodieTestFakeConfig() {
    }

    private HoodieTestFakeConfig(Properties props) {
        super(props);
    }

    public String getFakeString() {
        return this.getString(FAKE_STRING_CONFIG);
    }

    public int getFakeInteger() {
        return this.getInt(FAKE_INTEGER_CONFIG);
    }

    public String getFakeStringNoDefaultWithInfer() {
        return this.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER);
    }

    public String getFakeStringNoDefaultWithInferEmpty() {
        return this.getString(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieTestFakeConfig config = new HoodieTestFakeConfig();

        public Builder withFakeString(String value) {
            this.config.setValue(FAKE_STRING_CONFIG, value);
            return this;
        }

        public Builder withFakeInteger(int value) {
            this.config.setValue(FAKE_INTEGER_CONFIG, String.valueOf(value));
            return this;
        }

        public Builder withFakeStringNoDefaultWithInfer(String value) {
            this.config.setValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER, value);
            return this;
        }

        public Builder withFakeStringNoDefaultWithInferEmpty(String value) {
            this.config.setValue(FAKE_STRING_CONFIG_NO_DEFAULT_WITH_INFER_EMPTY, value);
            return this;
        }

        public HoodieTestFakeConfig build() {
            this.setDefaults();
            return new HoodieTestFakeConfig((Properties)this.config.getProps());
        }

        private void setDefaults() {
            this.config.setDefaults(HoodieTestFakeConfig.class.getName());
        }
    }
}

