/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.storage.StoragePath;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestFileSlice {
    @Test
    void testGetLatestInstantTime() {
        String baseInstant = "003";
        String deltaInstant2 = "002";
        String deltaInstant4 = "004";
        FileSlice fileSlice = new FileSlice("par1", baseInstant, "fg1");
        MatcherAssert.assertThat((Object)fileSlice.getLatestInstantTime(), (Matcher)CoreMatchers.is((Object)baseInstant));
        fileSlice.addLogFile(new HoodieLogFile(new StoragePath(TestFileSlice.getLogFileName(deltaInstant2))));
        MatcherAssert.assertThat((Object)fileSlice.getLatestInstantTime(), (Matcher)CoreMatchers.is((Object)baseInstant));
        fileSlice.addLogFile(new HoodieLogFile(new StoragePath(TestFileSlice.getLogFileName(deltaInstant4))));
        MatcherAssert.assertThat((Object)fileSlice.getLatestInstantTime(), (Matcher)CoreMatchers.is((Object)deltaInstant4));
    }

    private static String getLogFileName(String instantTime) {
        return ".fg1_" + instantTime + ".log.1_1-0-1";
    }
}

