/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieLSMTimelineManifest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class TestHoodieLSMTimelineManifest {
    @Test
    void testSerializeDeserialize() throws Exception {
        HoodieLSMTimelineManifest.LSMFileEntry entry1 = HoodieLSMTimelineManifest.LSMFileEntry.getInstance((String)"file1", (long)1024L);
        HoodieLSMTimelineManifest.LSMFileEntry entry2 = HoodieLSMTimelineManifest.LSMFileEntry.getInstance((String)"file2", (long)2048L);
        HoodieLSMTimelineManifest manifest = new HoodieLSMTimelineManifest(Arrays.asList(entry1, entry2));
        String expected = "{\n  \"files\" : [ {\n    \"fileName\" : \"file1\",\n    \"fileLen\" : 1024\n  }, {\n    \"fileName\" : \"file2\",\n    \"fileLen\" : 2048\n  } ]\n}";
        MatcherAssert.assertThat((Object)manifest.toJsonString(), (Matcher)CoreMatchers.is((Object)expected));
        HoodieLSMTimelineManifest deserialized = (HoodieLSMTimelineManifest)HoodieLSMTimelineManifest.fromJsonString((String)expected, HoodieLSMTimelineManifest.class);
        MatcherAssert.assertThat((Object)deserialized.getFiles().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)deserialized.getFiles().stream().map(HoodieLSMTimelineManifest.LSMFileEntry::getFileName).collect(Collectors.joining(",")), (Matcher)CoreMatchers.is((Object)"file1,file2"));
        MatcherAssert.assertThat((Object)deserialized.getFiles().stream().map(entry -> String.valueOf(entry.getFileLen())).collect(Collectors.joining(",")), (Matcher)CoreMatchers.is((Object)"1024,2048"));
    }
}

