/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.LogFileIterator;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestLogFileIterator {
    @Test
    public void testIteratorWithPlainHashMap() {
        HashMap<String, HoodieAvroRecord> inMemoryMap = new HashMap<String, HoodieAvroRecord>();
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey("key1", "p1"), null);
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey("key2", "p2"), null);
        inMemoryMap.put("key1", record1);
        inMemoryMap.put("key2", record2);
        HoodieMergedLogRecordScanner scanner = (HoodieMergedLogRecordScanner)Mockito.mock(HoodieMergedLogRecordScanner.class);
        Mockito.when((Object)scanner.getRecords()).thenReturn(inMemoryMap);
        LogFileIterator iterator = new LogFileIterator(scanner);
        Assertions.assertTrue((boolean)iterator.hasNext());
        HoodieRecord next1 = (HoodieRecord)iterator.next();
        Assertions.assertNotNull((Object)next1);
        Assertions.assertTrue((boolean)iterator.hasNext());
        HoodieRecord next2 = (HoodieRecord)iterator.next();
        Assertions.assertNotNull((Object)next2);
        Assertions.assertFalse((boolean)iterator.hasNext());
        iterator.close();
    }

    @Test
    public void testIteratorWithExternalSpillableMap() throws Exception {
        ExternalSpillableMap<String, HoodieRecord> spillableMap = TestLogFileIterator.getSpillableRecordMap();
        HoodieMergedLogRecordScanner scanner = (HoodieMergedLogRecordScanner)Mockito.mock(HoodieMergedLogRecordScanner.class);
        Mockito.when((Object)scanner.getRecords()).thenReturn(spillableMap);
        LogFileIterator iterator = new LogFileIterator(scanner);
        int count = 0;
        while (iterator.hasNext()) {
            HoodieRecord rec = (HoodieRecord)iterator.next();
            Assertions.assertNotNull((Object)rec);
            ++count;
        }
        Assertions.assertEquals((int)2, (int)count);
        iterator.close();
    }

    private static ExternalSpillableMap<String, HoodieRecord> getSpillableRecordMap() throws IOException {
        ExternalSpillableMap spillableMap = new ExternalSpillableMap(1L, "/tmp", (SizeEstimator)new DefaultSizeEstimator(), (SizeEstimator)new HoodieRecordSizeEstimator(HoodieTestDataGenerator.AVRO_SCHEMA), ExternalSpillableMap.DiskMapType.BITCASK, (CustomSerializer)new DefaultSerializer(), false, TestLogFileIterator.class.getSimpleName());
        HoodieAvroRecord recordA = new HoodieAvroRecord(new HoodieKey("keyA", "p1"), null);
        HoodieAvroRecord recordB = new HoodieAvroRecord(new HoodieKey("keyB", "p2"), null);
        spillableMap.put((Serializable)((Object)"keyA"), (Object)recordA);
        spillableMap.put((Serializable)((Object)"keyB"), (Object)recordB);
        return spillableMap;
    }
}

