/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v2.CommitMetadataSerDeV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class BaseTestCommitMetadataSerDe {
    protected static final String TEST_PARTITION_PATH = "2023/01/01";
    protected static final String TEST_FILE_ID = "test-file-id";
    protected static final String TEST_PREV_COMMIT = "000001";
    protected static final String TEST_BASE_FILE = "test-base-file";
    protected String testPath;

    protected abstract CommitMetadataSerDe getSerDe();

    protected abstract HoodieInstant createTestInstant(String var1, String var2);

    @BeforeEach
    public void setUp() {
        this.testPath = "file:///path/1/";
    }

    @Test
    protected void testEmptyMetadataSerDe() throws Exception {
        HoodieCommitMetadata emptyMetadata = new HoodieCommitMetadata();
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("commit", "001");
        byte[] serialized = TimelineMetadataUtils.convertMetadataToByteArray((Object)emptyMetadata, (CommitMetadataSerDe)serDe);
        HoodieCommitMetadata deserialized = (HoodieCommitMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream(serialized), () -> false, HoodieCommitMetadata.class);
        Assertions.assertNotNull((Object)deserialized);
        Assertions.assertEquals((int)0, (int)deserialized.getPartitionToWriteStats().size());
        Assertions.assertEquals((Object)false, (Object)deserialized.getCompacted());
        Assertions.assertEquals((Object)WriteOperationType.UNKNOWN, (Object)deserialized.getOperationType());
        Assertions.assertTrue((boolean)deserialized.getExtraMetadata().isEmpty());
    }

    @Test
    protected void testPopulatedMetadataSerDe() throws Exception {
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        HoodieWriteStat writeStat = this.createTestWriteStat();
        metadata.addWriteStat(TEST_PARTITION_PATH, writeStat);
        metadata.setOperationType(WriteOperationType.INSERT);
        metadata.setCompacted(Boolean.valueOf(true));
        metadata.addMetadata("test-key", "test-value");
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("commit", "001");
        byte[] serialized = TimelineMetadataUtils.convertMetadataToByteArray((Object)metadata, (CommitMetadataSerDe)serDe);
        HoodieCommitMetadata deserialized = (HoodieCommitMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream(serialized), () -> false, HoodieCommitMetadata.class);
        this.verifyCommitMetadata(deserialized);
        this.verifyWriteStat((HoodieWriteStat)((List)deserialized.getPartitionToWriteStats().get(TEST_PARTITION_PATH)).get(0));
    }

    @Test
    protected void testReplaceCommitMetadataSerDe() throws Exception {
        HoodieReplaceCommitMetadata metadata = new HoodieReplaceCommitMetadata();
        HoodieWriteStat writeStat = this.createTestWriteStat();
        metadata.addWriteStat(TEST_PARTITION_PATH, writeStat);
        metadata.addReplaceFileId(TEST_PARTITION_PATH, "replaced-file-1");
        metadata.addReplaceFileId(TEST_PARTITION_PATH, "replaced-file-2");
        metadata.addReplaceFileId("other-partition", "replaced-file-3");
        metadata.setOperationType(WriteOperationType.CLUSTER);
        metadata.setCompacted(Boolean.valueOf(true));
        metadata.addMetadata("test-key-1", "test-value-1");
        metadata.addMetadata("test-key-2", "test-value-2");
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("replacecommit", "001");
        byte[] serialized = TimelineMetadataUtils.convertMetadataToByteArray((Object)metadata, (CommitMetadataSerDe)serDe);
        HoodieReplaceCommitMetadata deserialized = (HoodieReplaceCommitMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream(serialized), () -> false, HoodieReplaceCommitMetadata.class);
        this.verifyReplaceCommitMetadata(deserialized);
        this.verifyWriteStat((HoodieWriteStat)((List)deserialized.getPartitionToWriteStats().get(TEST_PARTITION_PATH)).get(0));
        this.verifyReplaceFileIds(deserialized.getPartitionToReplaceFileIds());
    }

    private StoragePathInfo generateFileStatus(String filePath) {
        return new StoragePathInfo(new StoragePath(filePath), 1L, true, 2, 1000000L, 1L);
    }

    @Test
    protected void testRollbackMetadataSerDe() throws Exception {
        HoodieRollbackMetadata metadata = new HoodieRollbackMetadata();
        HashMap<StoragePathInfo, Long> commandBlocksCount = new HashMap<StoragePathInfo, Long>();
        commandBlocksCount.put(this.generateFileStatus("file:///path/1/partition2/.log.1"), 1L);
        HoodieRollbackPartitionMetadata rollbackPartitionMetadata = new HoodieRollbackPartitionMetadata();
        rollbackPartitionMetadata.setPartitionPath("p1");
        rollbackPartitionMetadata.setSuccessDeleteFiles(Arrays.asList("f1"));
        rollbackPartitionMetadata.setFailedDeleteFiles(new ArrayList());
        rollbackPartitionMetadata.setRollbackLogFiles(new HashMap());
        HashMap<String, HoodieRollbackPartitionMetadata> partitionMetadataMap = new HashMap<String, HoodieRollbackPartitionMetadata>();
        partitionMetadataMap.put("p1", rollbackPartitionMetadata);
        metadata.setPartitionMetadata(partitionMetadataMap);
        metadata.setInstantsRollback(Collections.singletonList(new HoodieInstantInfo("001", "commit")));
        metadata.setStartRollbackTime("002");
        metadata.setTimeTakenInMillis(100L);
        metadata.setTotalFilesDeleted(1);
        metadata.setCommitsRollback(Arrays.asList("111", "222"));
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("rollback", "002");
        byte[] serialized = TimelineMetadataUtils.convertMetadataToByteArray((Object)metadata, (CommitMetadataSerDe)serDe);
        HoodieRollbackMetadata deserialized = (HoodieRollbackMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream(serialized), () -> false, HoodieRollbackMetadata.class);
        Assertions.assertNotNull((Object)deserialized);
        Assertions.assertEquals(Collections.singletonList(new HoodieInstantInfo("001", "commit")), (Object)deserialized.getInstantsRollback());
        Assertions.assertEquals((Object)"002", (Object)deserialized.getStartRollbackTime());
        Assertions.assertEquals((long)100L, (long)deserialized.getTimeTakenInMillis());
        Assertions.assertEquals((int)1, (int)deserialized.getTotalFilesDeleted());
    }

    @Test
    protected void testEmptyFile() throws Exception {
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("rollback", "002");
        Option serialized = Option.of((Object)new byte[0]);
        HoodieRollbackMetadata deserialized = (HoodieRollbackMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream((byte[])serialized.get()), () -> true, HoodieRollbackMetadata.class);
        Assertions.assertNotNull((Object)deserialized);
        Assertions.assertNull((Object)deserialized.getStartRollbackTime());
        Assertions.assertNull((Object)deserialized.getCommitsRollback());
        Assertions.assertNull((Object)deserialized.getPartitionMetadata());
        Assertions.assertNull((Object)deserialized.getVersion());
    }

    @Test
    protected void testCorruptedAvroFile() {
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("rollback", "002");
        Option serialized = Option.of((Object)new byte[0]);
        Exception ex = (Exception)Assertions.assertThrows(IOException.class, () -> {
            HoodieRollbackMetadata cfr_ignored_0 = (HoodieRollbackMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream((byte[])serialized.get()), () -> false, HoodieRollbackMetadata.class);
        });
        Assertions.assertEquals((Object)ex.getCause().getMessage(), (Object)"Not an Avro data file.");
    }

    @Test
    protected void testCorruptedJsonFile() {
        CommitMetadataSerDe serDe = this.getSerDe();
        HoodieInstant instant = this.createTestInstant("commit", "002");
        Option serialized = Option.of((Object)new byte[0]);
        Exception ex = (Exception)Assertions.assertThrows(IOException.class, () -> {
            HoodieCommitMetadata cfr_ignored_0 = (HoodieCommitMetadata)serDe.deserialize(instant, (InputStream)new ByteArrayInputStream((byte[])serialized.get()), () -> false, HoodieCommitMetadata.class);
        });
        if (serDe instanceof CommitMetadataSerDeV2) {
            Assertions.assertEquals((Object)ex.getCause().getMessage(), (Object)"Not an Avro data file.");
        } else {
            Assertions.assertEquals((Object)ex.getCause().getMessage(), (Object)"No content to map due to end-of-input\n at [Source: (ByteArrayInputStream); line: 1, column: 0]");
        }
    }

    protected HoodieWriteStat createTestWriteStat() {
        HoodieWriteStat writeStat = new HoodieWriteStat();
        writeStat.setFileId(TEST_FILE_ID);
        writeStat.setPath(this.testPath);
        writeStat.setPrevCommit(TEST_PREV_COMMIT);
        writeStat.setNumWrites(100L);
        writeStat.setNumUpdateWrites(50L);
        writeStat.setTotalWriteBytes(1024L);
        writeStat.setTotalWriteErrors(0L);
        writeStat.setPartitionPath(TEST_PARTITION_PATH);
        writeStat.setFileSizeInBytes(2048L);
        writeStat.setPrevBaseFile(TEST_BASE_FILE);
        writeStat.setMinEventTime(Long.valueOf(1000L));
        writeStat.setMaxEventTime(Long.valueOf(2000L));
        HashMap<String, Long> cdcStats = new HashMap<String, Long>();
        cdcStats.put("cdc-file-1.log", 512L);
        writeStat.setCdcStats(cdcStats);
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalScanTime(100L);
        runtimeStats.setTotalCreateTime(200L);
        runtimeStats.setTotalUpsertTime(300L);
        writeStat.setRuntimeStats(runtimeStats);
        writeStat.setTotalLogFilesCompacted(5L);
        writeStat.setTotalLogReadTimeMs(150L);
        writeStat.setTotalLogSizeCompacted(1024L);
        writeStat.setTempPath("temp/path/file1");
        return writeStat;
    }

    protected void verifyCommitMetadata(HoodieCommitMetadata metadata) {
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((int)1, (int)metadata.getPartitionToWriteStats().size());
        Assertions.assertEquals((Object)true, (Object)metadata.getCompacted());
        Assertions.assertEquals((Object)WriteOperationType.INSERT, (Object)metadata.getOperationType());
        Assertions.assertEquals((Object)"test-value", metadata.getExtraMetadata().get("test-key"));
    }

    private void verifyReplaceCommitMetadata(HoodieReplaceCommitMetadata metadata) {
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertEquals((Object)true, (Object)metadata.getCompacted());
        Assertions.assertEquals((Object)WriteOperationType.CLUSTER, (Object)metadata.getOperationType());
        Assertions.assertEquals((Object)"test-value-1", metadata.getExtraMetadata().get("test-key-1"));
        Assertions.assertEquals((Object)"test-value-2", metadata.getExtraMetadata().get("test-key-2"));
    }

    protected void verifyWriteStat(HoodieWriteStat stat) {
        Assertions.assertEquals((Object)TEST_FILE_ID, (Object)stat.getFileId());
        Assertions.assertEquals((Object)this.testPath, (Object)stat.getPath());
        Assertions.assertEquals((Object)TEST_PREV_COMMIT, (Object)stat.getPrevCommit());
        Assertions.assertEquals((long)100L, (long)stat.getNumWrites());
        Assertions.assertEquals((long)50L, (long)stat.getNumUpdateWrites());
        Assertions.assertEquals((long)1024L, (long)stat.getTotalWriteBytes());
        Assertions.assertEquals((long)0L, (long)stat.getTotalWriteErrors());
        Assertions.assertEquals((Object)TEST_PARTITION_PATH, (Object)stat.getPartitionPath());
        Assertions.assertEquals((long)2048L, (long)stat.getFileSizeInBytes());
        Assertions.assertEquals((Object)TEST_BASE_FILE, (Object)stat.getPrevBaseFile());
        Assertions.assertEquals((long)1000L, (Long)stat.getMinEventTime());
        Assertions.assertEquals((long)2000L, (Long)stat.getMaxEventTime());
        Assertions.assertEquals((long)512L, (Long)((Long)stat.getCdcStats().get("cdc-file-1.log")));
        Assertions.assertNotNull((Object)stat.getRuntimeStats());
        Assertions.assertEquals((long)100L, (long)stat.getRuntimeStats().getTotalScanTime());
        Assertions.assertEquals((long)200L, (long)stat.getRuntimeStats().getTotalCreateTime());
        Assertions.assertEquals((long)300L, (long)stat.getRuntimeStats().getTotalUpsertTime());
        Assertions.assertEquals((long)5L, (long)stat.getTotalLogFilesCompacted());
        Assertions.assertEquals((long)150L, (long)stat.getTotalLogReadTimeMs());
        Assertions.assertEquals((long)1024L, (long)stat.getTotalLogSizeCompacted());
        Assertions.assertEquals((Object)"temp/path/file1", (Object)stat.getTempPath());
        Assertions.assertEquals((long)0L, (long)stat.getNumUpdates());
    }

    private void verifyReplaceFileIds(Map<String, List<String>> replaceFileIds) {
        Assertions.assertEquals((int)2, (int)replaceFileIds.size());
        Assertions.assertEquals(Arrays.asList("replaced-file-1", "replaced-file-2"), replaceFileIds.get(TEST_PARTITION_PATH));
        Assertions.assertEquals(Collections.singletonList("replaced-file-3"), replaceFileIds.get("other-partition"));
    }
}

