/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.view.HoodieFileGroupSizeEstimator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestHoodieFileGroupSizeEstimator {
    TestHoodieFileGroupSizeEstimator() {
    }

    @Test
    void estimatorSkipsTimeline() {
        HoodieFileGroup fileGroup1 = (HoodieFileGroup)Mockito.mock(HoodieFileGroup.class);
        HoodieFileGroup fileGroup2 = (HoodieFileGroup)Mockito.mock(HoodieFileGroup.class);
        HoodieFileGroupId fileGroupId = new HoodieFileGroupId("path1", UUID.randomUUID().toString());
        List<FileSlice> fileSlices = Collections.singletonList(new FileSlice(fileGroupId, "001", new HoodieBaseFile("/tmp/" + FSUtils.makeBaseFileName((String)"001", (String)"1-0-1", (String)fileGroupId.getFileId(), (String)"parquet")), Collections.emptyList()));
        Mockito.when((Object)fileGroup1.getFileGroupId()).thenReturn((Object)fileGroupId);
        Mockito.when((Object)fileGroup1.getAllFileSlices()).thenReturn(fileSlices.stream());
        Mockito.when((Object)fileGroup2.getFileGroupId()).thenReturn((Object)new HoodieFileGroupId("path2", UUID.randomUUID().toString()));
        Mockito.when((Object)fileGroup2.getAllFileSlices()).thenReturn(Stream.empty());
        long result = new HoodieFileGroupSizeEstimator().sizeEstimate(Arrays.asList(fileGroup1, fileGroup2));
        Assertions.assertTrue((result > 0L ? 1 : 0) != 0);
        ((HoodieFileGroup)Mockito.verify((Object)fileGroup1, (VerificationMode)Mockito.never())).getTimeline();
        ((HoodieFileGroup)Mockito.verify((Object)fileGroup2, (VerificationMode)Mockito.never())).getTimeline();
    }
}

