/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;

public final class Transformations {
    public static <T> List<T> flatten(Iterator<List<T>> iteratorOfLists) {
        ArrayList flattened = new ArrayList();
        iteratorOfLists.forEachRemaining(flattened::addAll);
        return flattened;
    }

    public static <T> Iterator<T> flattenAsIterator(Iterator<List<T>> iteratorOfLists) {
        return Transformations.flatten(iteratorOfLists).iterator();
    }

    public static Set<String> recordsToRecordKeySet(List<HoodieRecord> records) {
        return records.stream().map(HoodieRecord::getRecordKey).collect(Collectors.toSet());
    }

    public static List<HoodieKey> recordsToHoodieKeys(List<HoodieRecord> records) {
        return records.stream().map(HoodieRecord::getKey).collect(Collectors.toList());
    }

    public static Map<String, List<HoodieRecord>> recordsToPartitionRecordsMap(List<HoodieRecord> records) {
        return records.stream().collect(Collectors.groupingBy(HoodieRecord::getPartitionPath));
    }

    public static <T> List<T> randomSelect(List<T> items, int n) {
        int numSelected;
        int s = items.size();
        if (n < 0 || n > s) {
            throw new IllegalArgumentException(String.format("Invalid number of items to select! Valid range for n: [0, %s]", s));
        }
        ArrayList<T> selected = new ArrayList<T>();
        int i = 0;
        for (numSelected = 0; i < s && numSelected < n; i += 2, ++numSelected) {
            selected.add(items.get(i));
        }
        i = 1;
        for (numSelected = selected.size(); i < s && numSelected < n; i += 2, ++numSelected) {
            selected.add(items.get(i));
        }
        return selected;
    }

    public static List<HoodieKey> randomSelectAsHoodieKeys(List<HoodieRecord> records, int n) {
        return Transformations.randomSelect(Transformations.recordsToHoodieKeys(records), n);
    }
}

