/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.storage.HoodieStorage;

public class HoodieFileGroupReaderTestUtils {
    public static HoodieFileGroupReader<IndexedRecord> createFileGroupReader(Option<FileSlice> fileSliceOpt, String basePath, String latestCommitTime, Schema schema, boolean shouldUseRecordPosition, long start, long length, TypedProperties properties, HoodieStorage storage, HoodieReaderContext<IndexedRecord> readerContext, HoodieTableMetaClient metaClient, boolean allowInflightCommits) {
        assert (fileSliceOpt.isPresent());
        return new HoodieFileGroupReaderBuilder().withReaderContext(readerContext).withStorage(storage).withFileSlice((FileSlice)fileSliceOpt.get()).withStart(start).withLength(length).withProperties(properties).withAllowInflightCommits(allowInflightCommits).build(basePath, latestCommitTime, schema, shouldUseRecordPosition, metaClient);
    }

    public static class HoodieFileGroupReaderBuilder {
        private HoodieReaderContext<IndexedRecord> readerContext;
        private FileSlice fileSlice;
        private HoodieStorage storage;
        private TypedProperties props;
        private long start;
        private long length;
        private boolean allowInflightCommits = false;

        public HoodieFileGroupReaderBuilder withReaderContext(HoodieReaderContext<IndexedRecord> context) {
            this.readerContext = context;
            return this;
        }

        public HoodieFileGroupReaderBuilder withFileSlice(FileSlice fileSlice) {
            this.fileSlice = fileSlice;
            return this;
        }

        public HoodieFileGroupReaderBuilder withStorage(HoodieStorage storage) {
            this.storage = storage;
            return this;
        }

        public HoodieFileGroupReaderBuilder withProperties(TypedProperties props) {
            this.props = props;
            return this;
        }

        public HoodieFileGroupReaderBuilder withStart(long start) {
            this.start = start;
            return this;
        }

        public HoodieFileGroupReaderBuilder withLength(long length) {
            this.length = length;
            return this;
        }

        public HoodieFileGroupReaderBuilder withAllowInflightCommits(boolean allowInflightCommits) {
            this.allowInflightCommits = allowInflightCommits;
            return this;
        }

        public HoodieFileGroupReader<IndexedRecord> build(String basePath, String latestCommitTime, Schema schema, boolean shouldUseRecordPosition, HoodieTableMetaClient metaClient) {
            this.props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), String.valueOf(1048576000));
            this.props.setProperty(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), basePath + "/" + ".hoodie/.temp");
            this.props.setProperty(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), ExternalSpillableMap.DiskMapType.ROCKS_DB.name());
            this.props.setProperty(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), "false");
            return new HoodieFileGroupReader(this.readerContext, this.storage, basePath, latestCommitTime, this.fileSlice, schema, schema, Option.empty(), metaClient, this.props, this.start, this.length, shouldUseRecordPosition, this.allowInflightCommits);
        }
    }
}

