/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils.reader;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SpillableMapUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class HoodieTestReaderContext
extends HoodieReaderContext<IndexedRecord> {
    private Option<HoodieRecordMerger> customMerger;
    private Option<String> payloadClass;

    public HoodieTestReaderContext(Option<HoodieRecordMerger> customMerger, Option<String> payloadClass) {
        this.customMerger = customMerger;
        this.payloadClass = payloadClass;
    }

    public ClosableIterator<IndexedRecord> getFileRecordIterator(StoragePath filePath, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        HoodieAvroFileReader reader = (HoodieAvroFileReader)HoodieIOFactory.getIOFactory((HoodieStorage)storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(new HoodieConfig(), filePath, HoodieFileFormat.PARQUET, Option.empty());
        return reader.getIndexedRecordIterator(dataSchema, requiredSchema);
    }

    public IndexedRecord convertAvroRecord(IndexedRecord record) {
        return record;
    }

    public GenericRecord convertToAvroRecord(IndexedRecord record, Schema schema) {
        return (GenericRecord)record;
    }

    public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
        if (mergeMode == RecordMergeMode.CUSTOM) {
            return this.customMerger;
        }
        return Option.of((Object)HoodieAvroRecordMerger.INSTANCE);
    }

    public Object getValue(IndexedRecord record, Schema schema, String fieldName) {
        return this.getFieldValueFromIndexedRecord(record, schema, fieldName);
    }

    public String getRecordKey(IndexedRecord record, Schema schema) {
        return this.getFieldValueFromIndexedRecord(record, schema, "_row_key").toString();
    }

    public HoodieRecord<IndexedRecord> constructHoodieRecord(BufferedRecord<IndexedRecord> bufferedRecord) {
        String appliedPayloadClass;
        String string = appliedPayloadClass = this.payloadClass.isPresent() ? (String)this.payloadClass.get() : DefaultHoodieRecordPayload.class.getName();
        if (bufferedRecord.isDelete()) {
            return (HoodieRecord)SpillableMapUtils.generateEmptyPayload((String)bufferedRecord.getRecordKey(), null, (Comparable)bufferedRecord.getOrderingValue(), (String)appliedPayloadClass);
        }
        return new HoodieAvroIndexedRecord((IndexedRecord)bufferedRecord.getRecord());
    }

    public IndexedRecord seal(IndexedRecord record) {
        Schema schema = record.getSchema();
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        for (Schema.Field field : schema.getFields()) {
            builder.set(field, record.get(field.pos()));
        }
        return builder.build();
    }

    public IndexedRecord toBinaryRow(Schema schema, IndexedRecord record) {
        return record;
    }

    public ClosableIterator<IndexedRecord> mergeBootstrapReaders(ClosableIterator<IndexedRecord> skeletonFileIterator, Schema skeletonRequiredSchema, ClosableIterator<IndexedRecord> dataFileIterator, Schema dataRequiredSchema) {
        return null;
    }

    public UnaryOperator<IndexedRecord> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
        if (!renamedColumns.isEmpty()) {
            throw new UnsupportedOperationException("Schema evolution is not supported for the test reader context");
        }
        Map<String, Integer> fromFields = IntStream.range(0, from.getFields().size()).boxed().collect(Collectors.toMap(i -> ((Schema.Field)from.getFields().get((int)i)).name(), i -> i));
        Map<String, Integer> toFields = IntStream.range(0, to.getFields().size()).boxed().collect(Collectors.toMap(i -> ((Schema.Field)to.getFields().get((int)i)).name(), i -> i));
        List missingFields = to.getFields().stream().filter(f -> !fromFields.containsKey(f.name())).collect(Collectors.toList());
        if (!missingFields.isEmpty()) {
            throw new HoodieException("There are some fields missing in source schema: " + missingFields);
        }
        Map<Integer, Integer> fieldMap = toFields.entrySet().stream().filter(e -> fromFields.containsKey(e.getKey())).collect(Collectors.toMap(e -> (Integer)fromFields.get(e.getKey()), Map.Entry::getValue));
        return record -> {
            GenericData.Record outputRecord = new GenericData.Record(to);
            for (int i = 0; i < from.getFields().size(); ++i) {
                if (!fieldMap.containsKey(i)) continue;
                int j = (Integer)fieldMap.get(i);
                outputRecord.put(j, record.get(i));
            }
            return outputRecord;
        };
    }

    private Object getFieldValueFromIndexedRecord(IndexedRecord record, Schema recordSchema, String fieldName) {
        Schema.Field field = recordSchema.getField(fieldName);
        if (field == null) {
            return null;
        }
        int pos = field.pos();
        return record.get(pos);
    }
}

