/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestConfigUtils {
    public static final ConfigProperty<String> TEST_BOOLEAN_CONFIG_PROPERTY = ConfigProperty.key((String)"hoodie.test.boolean.config").defaultValue((Object)"true").withAlternatives(new String[]{"hudi.test.boolean.config"}).markAdvanced().withDocumentation("Testing boolean config.");

    private static Stream<Arguments> separatorArgs() {
        ArrayList<Option> separatorList = new ArrayList<Option>();
        separatorList.add(Option.empty());
        separatorList.add(Option.of((Object)"\n"));
        separatorList.add(Option.of((Object)","));
        return separatorList.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"separatorArgs"})
    public void testToMapSucceeds(Option<String> separator) {
        String sepString = separator.isPresent() ? (String)separator.get() : "\n";
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        expectedMap.put("k.1.1.2", "v1");
        expectedMap.put("k.2.1.2", "v2");
        expectedMap.put("k.3.1.2", "v3");
        String srcKv = String.format("k.1.1.2=v1%sk.2.1.2=v2%sk.3.1.2=v3", sepString, sepString);
        Map<String, String> outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format("k.1.1.2=v1%sk.2.1.2=v2%sk.3.1.2=v3%s", sepString, sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format("k.1.1.2=v1%sk.2.1.2=v2%s%sk.3.1.2=v3", sepString, sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format("k.1.1.2=v1%s  %sk.2.1.2=v2%s%sk.3.1.2=v3", sepString, sepString, sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
        srcKv = String.format(" k.1.1.2 =   v1%s k.2.1.2 = v2 %sk.3.1.2 = v3", sepString, sepString);
        outMap = this.toMap(srcKv, separator);
        Assertions.assertEquals(expectedMap, outMap);
    }

    @Test
    void testGetRawValueWithAltKeys() {
        TypedProperties properties = new TypedProperties();
        ExternalSpillableMap.DiskMapType diskMapType = (ExternalSpillableMap.DiskMapType)ConfigUtils.getRawValueWithAltKeys((Properties)properties, (ConfigProperty)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE, (boolean)true);
        Assertions.assertEquals((Object)ExternalSpillableMap.DiskMapType.BITCASK, (Object)diskMapType);
        properties.put((Object)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Object)ExternalSpillableMap.DiskMapType.ROCKS_DB);
        diskMapType = (ExternalSpillableMap.DiskMapType)ConfigUtils.getRawValueWithAltKeys((Properties)properties, (ConfigProperty)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE, (boolean)true);
        Assertions.assertEquals((Object)ExternalSpillableMap.DiskMapType.ROCKS_DB, (Object)diskMapType);
        properties.remove((Object)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key());
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ExternalSpillableMap.DiskMapType cfr_ignored_0 = (ExternalSpillableMap.DiskMapType)ConfigUtils.getRawValueWithAltKeys((Properties)properties, (ConfigProperty)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE, (boolean)false);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"separatorArgs"})
    public void testToMapThrowError(Option<String> separator) {
        String sepString = separator.isPresent() ? (String)separator.get() : "\n";
        String srcKv = String.format("k.1.1.2=v1=v1.1%sk.2.1.2=v2%sk.3.1.2=v3", sepString, sepString);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.toMap(srcKv, separator));
    }

    private Map<String, String> toMap(String config, Option<String> separator) {
        if (separator.isEmpty()) {
            return ConfigUtils.toMap((String)config);
        }
        return ConfigUtils.toMap((String)config, (String)((String)separator.get()));
    }
}

