/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.common.util.RetryHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRetryHelper {
    private static final int NUM = 1;
    private static final long INTERVAL_TIME = 1L;

    @Test
    public void testCheckIfExceptionInRetryList() throws Exception {
        RetryHelper retryHelper = new RetryHelper(1L, 1, 1L, "");
        Method privateOne = retryHelper.getClass().getDeclaredMethod("checkIfExceptionInRetryList", Exception.class);
        privateOne.setAccessible(true);
        boolean retry = (Boolean)privateOne.invoke((Object)retryHelper, new IOException("test"));
        Assertions.assertTrue((boolean)retry);
        retry = (Boolean)privateOne.invoke((Object)retryHelper, new Exception("test"));
        Assertions.assertFalse((boolean)retry);
        retryHelper = new RetryHelper(1L, 1, 1L, Exception.class.getName());
        retry = (Boolean)privateOne.invoke((Object)retryHelper, new UnsupportedOperationException("test"));
        Assertions.assertTrue((boolean)retry);
    }

    @Test
    public void testCheckTooManyTimes() {
        int maxRetries = 100;
        RetryHelper retryHelper = new RetryHelper(1L, maxRetries, 1L, null);
        AtomicInteger counter = new AtomicInteger(0);
        Assertions.assertDoesNotThrow(() -> retryHelper.start((RetryHelper.CheckedFunction & Serializable)() -> {
            if (counter.incrementAndGet() < maxRetries) {
                throw new IOException("test");
            }
            return true;
        }));
    }
}

