/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.time.Instant;
import org.apache.hudi.common.util.SystemClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class TestSystemClock {
    TestSystemClock() {
    }

    @Test
    void testNow() {
        Instant instant = Instant.now();
        try (MockedStatic instantMock = Mockito.mockStatic(Instant.class);){
            instantMock.when(Instant::now).thenReturn((Object)instant);
            SystemClock clock = new SystemClock();
            Assertions.assertEquals((Object)instant, (Object)clock.now());
        }
    }

    @Test
    void testCurrentEpoch() {
        Instant instant = Instant.now();
        try (MockedStatic instantMock = Mockito.mockStatic(Instant.class);){
            instantMock.when(Instant::now).thenReturn((Object)instant);
            SystemClock clock = new SystemClock();
            Assertions.assertEquals((long)instant.toEpochMilli(), (long)clock.currentEpoch());
        }
    }
}

